--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--


DROP FUNCTION IF EXISTS merchant_do_insert_issued_token;
CREATE FUNCTION merchant_do_insert_issued_token (
  IN in_h_issue_pub BYTEA,
  IN in_h_contract_terms BYTEA,
  IN in_blind_sig BYTEA,
  OUT out_no_family BOOL,
  OUT out_existed BOOL)
LANGUAGE plpgsql
AS $$
DECLARE
  my_rec RECORD;
  my_tfk_serial INT8;
  my_tf_serial INT8;
BEGIN

SELECT token_family_key_serial
      ,token_family_serial
  INTO my_rec
  FROM merchant_token_family_keys
 WHERE h_pub = in_h_issue_pub;

IF NOT FOUND
THEN
  out_no_family = TRUE;
  out_existed = FALSE;
  return;
END IF;

my_tfk_serial = my_rec.token_family_key_serial;
my_tf_serial = my_rec.token_family_serial;
out_no_family = FALSE;

INSERT INTO merchant_issued_tokens
  (token_family_key_serial
  ,h_contract_terms
  ,blind_sig
  ) VALUES
  (my_tfk_serial
  ,in_h_contract_terms
  ,in_blind_sig)
  ON CONFLICT DO NOTHING;

IF NOT FOUND
THEN
  out_existed = TRUE;
  return;
END IF;
out_existed = FALSE;

UPDATE merchant_token_families
   SET issued=issued+1
  WHERE token_family_serial=my_tf_serial;
  

END $$;
