/* registers.c generated by valac 0.56.17, the Vala compiler
 * generated from registers.vala, do not modify */

/* Registers facility functions

   Copyright (c) 2001-2022 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <estr.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define NUM_REGISTERS 256
#define GETKEY_DEFAULT -1
#define KBD_CTRL ((Keystroke) 01000)
#define KBD_CANCEL (KBD_CTRL | 'g')
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef guint Keystroke;

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
typedef gboolean (*MovementDelegate) (gpointer user_data);
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef void (*BufferWriter) (gpointer user_data);

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
typedef struct _WindowPrivate WindowPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

VALA_EXTERN ImmutableEstr* regs[NUM_REGISTERS];
ImmutableEstr* regs[NUM_REGISTERS] = {0};
VALA_EXTERN glong regnum;
glong regnum = 0L;
VALA_EXTERN Buffer* cur_bp;
VALA_EXTERN Window* cur_wp;

VALA_EXTERN gboolean insert_register (void);
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
VALA_EXTERN void registers_init (void);
static gboolean __lambda119_ (glong uniarg,
                       GeeQueue* args);
VALA_EXTERN gboolean noarg (GeeQueue* args);
VALA_EXTERN void minibuf_write (const gchar* fmt,
                    ...);
VALA_EXTERN Keystroke getkey (gint delay);
VALA_EXTERN gboolean int_arg (GeeQueue* args,
                  glong* n);
VALA_EXTERN gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
VALA_EXTERN void minibuf_clear (void);
VALA_EXTERN gboolean buffer_warn_if_no_mark (Buffer* self);
VALA_EXTERN gpointer region_ref (gpointer instance);
VALA_EXTERN void region_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_region (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_region (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_region (const GValue* value);
VALA_EXTERN GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
VALA_EXTERN ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
VALA_EXTERN Region* region_calculate (void);
static gboolean ___lambda119__function (glong uniarg,
                                 GeeQueue* args);
VALA_EXTERN LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
VALA_EXTERN LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
VALA_EXTERN gpointer lisp_func_ref (gpointer instance);
VALA_EXTERN void lisp_func_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_lisp_func (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_lisp_func (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_lisp_func (const GValue* value);
VALA_EXTERN GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda120_ (glong uniarg,
                       GeeQueue* args);
VALA_EXTERN gboolean buffer_warn_if_readonly (Buffer* self);
VALA_EXTERN void minibuf_error (const gchar* fmt,
                    ...);
VALA_EXTERN gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _insert_register_movement_delegate (gpointer self);
VALA_EXTERN gpointer marker_ref (gpointer instance);
VALA_EXTERN void marker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_marker (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_marker (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_marker (const GValue* value);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
VALA_EXTERN gpointer undo_ref (gpointer instance);
VALA_EXTERN void undo_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_undo (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_undo (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_undo (const GValue* value);
VALA_EXTERN GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
VALA_EXTERN gpointer var_entry_ref (gpointer instance);
VALA_EXTERN void var_entry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_var_entry (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_var_entry (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_var_entry (const GValue* value);
VALA_EXTERN GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
static gboolean ___lambda120__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda121_ (glong uniarg,
                       GeeQueue* args);
VALA_EXTERN void write_temp_buffer (const gchar* name,
                        gboolean show,
                        BufferWriter func,
                        gpointer func_target);
static void __lambda122_ (void);
VALA_EXTERN gpointer window_ref (gpointer instance);
VALA_EXTERN void window_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_window (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_window (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_window (const GValue* value);
VALA_EXTERN GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
VALA_EXTERN void bprintf (const gchar* fmt,
              ...);
static void ___lambda122__buffer_writer (gpointer self);
static gboolean ___lambda121__function (glong uniarg,
                                 GeeQueue* args);

gboolean
insert_register (void)
{
	Buffer* _tmp0_;
	ImmutableEstr* _tmp1_;
	gboolean result;
#line 26 "src/registers.vala"
	_tmp0_ = cur_bp;
#line 26 "src/registers.vala"
	_tmp1_ = regs[regnum];
#line 26 "src/registers.vala"
	buffer_insert_estr (_tmp0_, _tmp1_);
#line 27 "src/registers.vala"
	result = TRUE;
#line 27 "src/registers.vala"
	return result;
#line 366 "registers.c"
}

static gboolean
__lambda119_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	glong reg = 0L;
	gboolean result;
#line 35 "src/registers.vala"
	ok = TRUE;
#line 36 "src/registers.vala"
	reg = (glong) 1;
#line 37 "src/registers.vala"
	if (noarg (args)) {
#line 38 "src/registers.vala"
		minibuf_write ("Copy to register: ", NULL);
#line 39 "src/registers.vala"
		reg = (glong) getkey (GETKEY_DEFAULT);
#line 386 "registers.c"
	} else {
		glong _tmp0_ = 0L;
		gboolean _tmp1_;
#line 40 "src/registers.vala"
		_tmp1_ = int_arg (args, &_tmp0_);
#line 40 "src/registers.vala"
		reg = _tmp0_;
#line 40 "src/registers.vala"
		if (!_tmp1_) {
#line 41 "src/registers.vala"
			ok = FALSE;
#line 398 "registers.c"
		}
	}
#line 43 "src/registers.vala"
	if (ok) {
#line 44 "src/registers.vala"
		if (reg == ((glong) KBD_CANCEL)) {
#line 45 "src/registers.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 407 "registers.c"
		} else {
			Buffer* _tmp2_;
#line 47 "src/registers.vala"
			minibuf_clear ();
#line 48 "src/registers.vala"
			if (reg < ((glong) 0)) {
#line 49 "src/registers.vala"
				reg = (glong) 0;
#line 416 "registers.c"
			}
#line 50 "src/registers.vala"
			reg %= (glong) NUM_REGISTERS;
#line 53 "src/registers.vala"
			_tmp2_ = cur_bp;
#line 53 "src/registers.vala"
			if (buffer_warn_if_no_mark (_tmp2_)) {
#line 54 "src/registers.vala"
				ok = FALSE;
#line 426 "registers.c"
			} else {
				Buffer* _tmp3_;
				Region* _tmp4_;
				Region* _tmp5_;
				ImmutableEstr* _tmp6_;
#line 56 "src/registers.vala"
				_tmp3_ = cur_bp;
#line 56 "src/registers.vala"
				_tmp4_ = region_calculate ();
#line 56 "src/registers.vala"
				_tmp5_ = _tmp4_;
#line 56 "src/registers.vala"
				_tmp6_ = buffer_get_region (_tmp3_, _tmp5_);
#line 56 "src/registers.vala"
				_immutable_estr_unref0 (regs[reg]);
#line 56 "src/registers.vala"
				regs[reg] = _tmp6_;
#line 56 "src/registers.vala"
				_region_unref0 (_tmp5_);
#line 446 "registers.c"
			}
		}
	}
#line 59 "src/registers.vala"
	result = ok;
#line 59 "src/registers.vala"
	return result;
#line 454 "registers.c"
}

static gboolean
___lambda119__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda119_ (uniarg, args);
#line 32 "src/registers.vala"
	return result;
#line 465 "registers.c"
}

static gboolean
_insert_register_movement_delegate (gpointer self)
{
	gboolean result;
	result = insert_register ();
#line 93 "src/registers.vala"
	return result;
#line 475 "registers.c"
}

static gboolean
__lambda120_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	Buffer* _tmp0_;
	glong reg = 0L;
	gboolean result;
#line 68 "src/registers.vala"
	ok = TRUE;
#line 69 "src/registers.vala"
	_tmp0_ = cur_bp;
#line 69 "src/registers.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 70 "src/registers.vala"
		result = FALSE;
#line 70 "src/registers.vala"
		return result;
#line 496 "registers.c"
	}
#line 72 "src/registers.vala"
	reg = (glong) 1;
#line 73 "src/registers.vala"
	if (noarg (args)) {
#line 74 "src/registers.vala"
		minibuf_write ("Insert register: ", NULL);
#line 75 "src/registers.vala"
		reg = (glong) getkey (GETKEY_DEFAULT);
#line 506 "registers.c"
	} else {
		glong _tmp1_ = 0L;
		gboolean _tmp2_;
#line 76 "src/registers.vala"
		_tmp2_ = int_arg (args, &_tmp1_);
#line 76 "src/registers.vala"
		reg = _tmp1_;
#line 76 "src/registers.vala"
		if (!_tmp2_) {
#line 77 "src/registers.vala"
			ok = FALSE;
#line 518 "registers.c"
		}
	}
#line 79 "src/registers.vala"
	if (ok) {
#line 80 "src/registers.vala"
		if (reg == ((glong) KBD_CANCEL)) {
#line 81 "src/registers.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 527 "registers.c"
		} else {
			glong index = 0L;
			ImmutableEstr* _tmp3_;
#line 83 "src/registers.vala"
			minibuf_clear ();
#line 84 "src/registers.vala"
			reg %= (glong) NUM_REGISTERS;
#line 86 "src/registers.vala"
			index = reg;
#line 87 "src/registers.vala"
			_tmp3_ = regs[index];
#line 87 "src/registers.vala"
			if (_tmp3_ == NULL) {
#line 88 "src/registers.vala"
				minibuf_error ("Register does not contain text", NULL);
#line 89 "src/registers.vala"
				ok = FALSE;
#line 545 "registers.c"
			} else {
				Buffer* _tmp4_;
#line 91 "src/registers.vala"
				funcall ("set-mark-command", NULL, NULL);
#line 92 "src/registers.vala"
				regnum = reg;
#line 93 "src/registers.vala"
				execute_with_uniarg (uniarg, _insert_register_movement_delegate, NULL, NULL, NULL);
#line 94 "src/registers.vala"
				funcall ("exchange-point-and-mark", NULL, NULL);
#line 95 "src/registers.vala"
				_tmp4_ = cur_bp;
#line 95 "src/registers.vala"
				_tmp4_->mark_active = FALSE;
#line 560 "registers.c"
			}
		}
	}
#line 99 "src/registers.vala"
	result = ok;
#line 99 "src/registers.vala"
	return result;
#line 568 "registers.c"
}

static gboolean
___lambda120__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda120_ (uniarg, args);
#line 65 "src/registers.vala"
	return result;
#line 579 "registers.c"
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1405 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1406 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1406 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1407 "glib-2.0.vapi"
	g_strchug (_result_);
#line 1408 "glib-2.0.vapi"
	result = _result_;
#line 1408 "glib-2.0.vapi"
	return result;
#line 600 "registers.c"
}

static void
__lambda122_ (void)
{
	{
		guint i = 0U;
#line 113 "src/registers.vala"
		i = (guint) 0;
#line 610 "registers.c"
		{
			gboolean _tmp0_ = FALSE;
#line 113 "src/registers.vala"
			_tmp0_ = TRUE;
#line 113 "src/registers.vala"
			while (TRUE) {
#line 617 "registers.c"
				ImmutableEstr* _tmp2_;
#line 113 "src/registers.vala"
				if (!_tmp0_) {
#line 621 "registers.c"
					guint _tmp1_;
#line 113 "src/registers.vala"
					i = i + 1;
#line 113 "src/registers.vala"
					_tmp1_ = i;
#line 627 "registers.c"
				}
#line 113 "src/registers.vala"
				_tmp0_ = FALSE;
#line 113 "src/registers.vala"
				if (!(i < ((guint) NUM_REGISTERS))) {
#line 113 "src/registers.vala"
					break;
#line 635 "registers.c"
				}
#line 114 "src/registers.vala"
				_tmp2_ = regs[i];
#line 114 "src/registers.vala"
				if (_tmp2_ != NULL) {
#line 641 "registers.c"
					gchar* s = NULL;
					ImmutableEstr* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gint len = 0;
					Window* _tmp7_;
					gchar* _tmp8_ = NULL;
					const gchar* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
#line 115 "src/registers.vala"
					_tmp3_ = regs[i];
#line 115 "src/registers.vala"
					_tmp4_ = immutable_estr_get_text (_tmp3_);
#line 115 "src/registers.vala"
					_tmp5_ = _tmp4_;
#line 115 "src/registers.vala"
					_tmp6_ = string_chug ((const gchar*) _tmp5_);
#line 115 "src/registers.vala"
					s = _tmp6_;
#line 116 "src/registers.vala"
					_tmp7_ = cur_wp;
#line 116 "src/registers.vala"
					len = MIN (20, MAX (0, ((gint) _tmp7_->ewidth) - 6)) + 1;
#line 118 "src/registers.vala"
					if (g_ascii_isprint ((gchar) i)) {
#line 669 "registers.c"
						gchar* _tmp9_;
#line 118 "src/registers.vala"
						_tmp9_ = g_strdup_printf ("%c", (gint) ((gchar) i));
#line 118 "src/registers.vala"
						_g_free0 (_tmp8_);
#line 118 "src/registers.vala"
						_tmp8_ = _tmp9_;
#line 677 "registers.c"
					} else {
						gchar* _tmp10_;
#line 118 "src/registers.vala"
						_tmp10_ = g_strdup_printf ("\\%o", i);
#line 118 "src/registers.vala"
						_g_free0 (_tmp8_);
#line 118 "src/registers.vala"
						_tmp8_ = _tmp10_;
#line 686 "registers.c"
					}
#line 118 "src/registers.vala"
					bprintf ("Register %s contains ", _tmp8_, NULL);
#line 119 "src/registers.vala"
					_tmp11_ = s;
#line 119 "src/registers.vala"
					_tmp12_ = strlen (_tmp11_);
#line 119 "src/registers.vala"
					_tmp13_ = _tmp12_;
#line 119 "src/registers.vala"
					if (_tmp13_ > 0) {
#line 698 "registers.c"
						const gchar* _tmp14_;
#line 120 "src/registers.vala"
						_tmp14_ = s;
#line 120 "src/registers.vala"
						bprintf ("text starting with\n    %.*s\n", len, _tmp14_, NULL);
#line 704 "registers.c"
					} else {
						const gchar* _tmp15_;
						ImmutableEstr* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
#line 121 "src/registers.vala"
						_tmp15_ = s;
#line 121 "src/registers.vala"
						_tmp16_ = regs[i];
#line 121 "src/registers.vala"
						_tmp17_ = immutable_estr_get_text (_tmp16_);
#line 121 "src/registers.vala"
						_tmp18_ = _tmp17_;
#line 121 "src/registers.vala"
						if (g_strcmp0 (_tmp15_, (const gchar*) _tmp18_) != 0) {
#line 122 "src/registers.vala"
							bprintf ("whitespace\n", NULL);
#line 722 "registers.c"
						} else {
#line 124 "src/registers.vala"
							bprintf ("the empty string\n", NULL);
#line 726 "registers.c"
						}
					}
#line 114 "src/registers.vala"
					_g_free0 (_tmp8_);
#line 114 "src/registers.vala"
					_g_free0 (s);
#line 733 "registers.c"
				}
			}
		}
	}
}

static void
___lambda122__buffer_writer (gpointer self)
{
#line 109 "src/registers.vala"
	__lambda122_ ();
#line 745 "registers.c"
}

static gboolean
__lambda121_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result;
#line 109 "src/registers.vala"
	write_temp_buffer ("*Registers List*", TRUE, ___lambda122__buffer_writer, NULL);
#line 127 "src/registers.vala"
	result = TRUE;
#line 127 "src/registers.vala"
	return result;
#line 759 "registers.c"
}

static gboolean
___lambda121__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda121_ (uniarg, args);
#line 106 "src/registers.vala"
	return result;
#line 770 "registers.c"
}

void
registers_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
#line 32 "src/registers.vala"
	_tmp0_ = lisp_func_new ("copy-to-register", ___lambda119__function, TRUE, "Copy region into register REGISTER.");
#line 32 "src/registers.vala"
	_tmp1_ = _tmp0_;
#line 32 "src/registers.vala"
	_lisp_func_unref0 (_tmp1_);
#line 65 "src/registers.vala"
	_tmp2_ = lisp_func_new ("insert-register", ___lambda120__function, TRUE, "Insert contents of the user specified register.\n" \
"Puts point before and mark after the inserted text.");
#line 65 "src/registers.vala"
	_tmp3_ = _tmp2_;
#line 65 "src/registers.vala"
	_lisp_func_unref0 (_tmp3_);
#line 106 "src/registers.vala"
	_tmp4_ = lisp_func_new ("list-registers", ___lambda121__function, TRUE, "List defined registers.");
#line 106 "src/registers.vala"
	_tmp5_ = _tmp4_;
#line 106 "src/registers.vala"
	_lisp_func_unref0 (_tmp5_);
#line 800 "registers.c"
}

