<!--
AAMfP: a simple personal kanban metrics spreadsheet

Copyright (C)  2019-2020  Marco Bresciani.

Copying and distribution of this file, with or without modification, are
permitted in any medium without royalty provided the copyright notice
and this notice are preserved. This file is offered as-is, without any
warranty.

SPDX-FileCopyrightText: 2019-2020 Marco Bresciani

SPDX-License-Identifier: FSFAP
-->
# AAMfP: a simple personal kanban metrics spreadsheet

[![standard-readme compliant](https://img.shields.io/badge/readme%20style-standard-brightgreen.svg?style=plastic)](https://github.com/RichardLitt/standard-readme)
[![](https://reuse.software/badge/reuse-compliant.svg)](https://reuse.software/)

[![Donate using Liberapay](https://liberapay.com/assets/widgets/donate.svg)](https://liberapay.com/marcoXbresciani/donate)
![Liberapay patrons](https://img.shields.io/liberapay/patrons/marcoXbresciani?style=plastic)
![Liberapay receiving](https://img.shields.io/liberapay/receives/marcoXbresciani?style=plastic)

![Mastodon Follow](https://img.shields.io/mastodon/follow/91124?domain=https%3A%2F%2Ffosstodon.org&style=plastic)
![Website](https://img.shields.io/website?style=plastic&url=https%3A%2F%2Fsavannah.nongnu.org%2Fprojects%2Faamfp%2F)
![Security Headers](https://img.shields.io/security-headers?style=plastic&url=https%3A%2F%2Fsavannah.nongnu.org%2Fprojects%2Faamfp%2F)

Use this spreadsheet to improve your activities using Personal Kanban
concepts and applying Kanban method flow metrics.

Improve your daily workflow with this
[LibreOffice](https://www.libreoffice.org/) Calc spreadsheet using the
concepts of [Personal Kanban](http://personalkanban.com/pk/) and
applying some [Kanban
method](https://leankanban.com/project/what-is-km/) flow metrics as
described in the book [Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) (and
compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool) by Dan Vacanti.
<blockquote class="twitter-tweet"><p lang="en" dir="ltr">Kanban Metrics Spreadsheet for <a href="https://twitter.com/libreoffice?ref_src=twsrc%5Etfw">@libreoffice</a> - If you want flow metrics, and you don&#39;t have access to Microsoft Excel, consider this as a great option developed by <a href="https://twitter.com/marcoXbresciani?ref_src=twsrc%5Etfw">@marcoXbresciani</a> <a href="https://t.co/m8To66FkkM">https://t.co/m8To66FkkM</a></p>&mdash; Troy Magennis (@t_magennis) <a href="https://twitter.com/t_magennis/status/1234539546047438849?ref_src=twsrc%5Etfw">March 2, 2020</a></blockquote> <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>

## Table of Contents
* [Background](#background)
  * [Visualize Your Work](#visualize-your-work)
  * [Limit Your Work-in-Progress](#limit-your-work-in-progress)
* [Install](#install)
* [Usage](#usage)
  * [Hints](#hints)
* [Maintainer](#maintainer)
* [Contributing](#contributing)
* [License](#license)
   * [Official GPL Logo](#official-gpl-logo)
   * [Official GFDL Logo](#official-gfdl-logo)
   * [AMYMADE's buttons](#amymades-buttons)
   * [GNU FreeFont](#gnu-freefont)

## Background
For **Kanban** method starts from here: [What is Kanban | Lean
Kanban](https://leankanban.com/project/wkanban/) and the [Essential
Kanban Condensed Guide](https://leankanban.com/guide/).

For **Personal Kanban** starts from here: [Map your work, control your
life: Personal Kanban](http://personalkanban.com/pk/) and [Personal
Kanban: The Book | Personal Kanban](http://personalkanban.com/pk/book/).

For more details and explanations on *metrics*, please see the book
[Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) by Vacanti,
Daniel S..

For more details and explanations on *flow* management, please see the
book [The Principles of Product Development Flow: Second Generation Lean
Product Development](http://reinertsenassociates.com/books/) by
Reinertsen, Donald G..

See also **[Kanban One](https://www.kanbanone.com)**, an online tool
that covers the features of this spreadsheet (and more).

### Visualize Your Work
Together with its digital content, the project also contains printable
PDF and ODG (LibreOffice Draw) versions of an [A3
format](https://en.wikipedia.org/wiki/ISO_216) kanban board with
**Backlog**, **Next**, **In-progress** and **Done** columns.
It's there for you to print, and use to easily visualize your workflow
and work items!

### Limit Your Work-in-Progress
On top of **Next** and **In-progress** columns of the printable board
above, there is a specific **WIP** area inside which you can (and
should) write the WIP limit for such columns: remember to write the
limit in both columns, to be sure to properly apply Kanban method
concepts and obtain real improvements.

## Install
Latest release is
**v.[16.0.0](https://download.savannah.nongnu.org/releases/aamfp/16.0.0/)
'Italia'** (see
https://en.wikipedia.org/wiki/Anniversary_of_the_Unification_of_Italy).

See [Downloads](https://download.savannah.nongnu.org/releases/aamfp/)
page for all available releases.

For full versions history and details see the
[CHANGELOG.md](http://hg.savannah.nongnu.org/hgweb/aamfp/file/tip/CHANGELOG.md)
file.

The only requirement for this spreadsheet is, necessarily, to have
[LibreOffice](https://www.libreoffice.org/) installed or anyway
available in your system.
Please see [LibreOffice](https://www.libreoffice.org/) reference site
for downloads and installation instructions.

## Usage
This is not a fully-featured Kanban tool with a ton of metrics, but a
simple spreadsheet aiming to help in personal (and continuous)
improvement, there is no need to have a detailed scientific description
of all charts and metrics (see the reference books, for those).
In this section you can find some human-friendly and empirical hints to
help you manage your activities and continuously improve your work flow.

See [USAGE.md](USAGE.md) file for more details and descriptions of
fields and charts.

### Hints
* Keep your WIP under control (a.k.a. Limit WIP), to avoid spreading
  effort on too many work items at the same time.
  The *Effort Run Chart* shows you how much percentage of your working
  time you're giving, on average, to each ongoing work item.
  This mean you have to control and keep limited the number of
  activities you're working on, at the same time.
* The [CFD](USAGE.md#CFD) chart should show almost parallel lines, if
  some levels increase or decrease too much with respect to other levels
  (diverge), there might be a bottleneck.
* Try to keep Throughput (or, even better, the Delivery Rate) as much
  steady as possible, and always aim to increase it in order to increase
  your completion speed.
  This will help your predictability.
* The idea behind the Lead Time Distribution chart is to make the curved
  shape as thin and higher as possible, so reducing the long tail given
  by higher lead times.
* Always analyze root causes for special work items, that is: check why
  completed work items have lead times higher than overall 95th (or
  maybe 85th) percentile values.
  There might be room for improvement to avoid further work items with
  long lead times.
* If work items are blocked too many times or for too longer time,
  always check the root causes and improve on that side: removing
  blockers helps you moving your work items faster through the flow.
* [**Next**](USAGE.md#workitems) column is a so-called queue, that is a
  waiting column: all work items that have been confirmed and accepted
  (committed) for work to start shall be moved there.
  There is no need to (a.k.a. you should not) mark work items in this
  column as "blocked", first because they are not actually blocked
  (they're just waiting for you!), second, because the Net Flow
  Efficiency metric is there to also take care of tracking the time
  spent in this column.
* Always define (and possibly write down) specific procedures for
  similar work items.
  Having standard procedures for each Work Item Type helps you in
  avoiding errors when applying the procedure, while reading it, and
  also helps you find defects in the procedure, giving room to further
  process improvement.

## Maintainer
This project has been started by Marco Bresciani and is currently
maintained by Marco Bresciani.

For questions or requests, feel free to get in touch:
* **[@AAMfP@fosstodon.org](https://fosstodon.org/@AAMfP)** on the
  [Mastodon](https://en.wikipedia.org/wiki/Mastodon_(software) federated
  social network).
* **[aamfp_](ring:2e5e3ab18b487d096464ed0a0b2c2af468a8838a)** user on
  the [GNU Jami](https://jami.net) (former GNU Ring, former SFLphone)
  distributed communication platform.

Feel free to open an
[issue](https://savannah.nongnu.org/support/?group=aamfp) for bugs,
enhancements, proposals or tasks.

## Thanks
Thanks to (in appearing order):
* [Gavi](https://bitbucket.org/classicPintus/) for having solved bug
  [#1](https://web.archive.org/web/20190918131734/https://bitbucket.org/marcobresciani/aamfp/issues/1/wrong-cfd-counting)
  and for creating **[Kanban One](https://www.kanbanone.com)** together
  with Francesco.
* [Samuele Accordini](https://it.linkedin.com/in/samueleaccordini) for
  citing this spreadsheet in his LinkedIn article (in Italian) [Personal
  Kanban: il trainer del
  tempo](https://www.linkedin.com/pulse/personal-kanban-il-trainer-del-tempo-samuele-accordini).
* [Rudiger Wolf](https://bitbucket.org/rnwolf/) for having creating his
  [Pandas Agile Metrics](https://github.com/rnwolf/pandas_agile_metrics)
  project "Inspired by https://bitbucket.org/marcobresciani/aamfp/".

## Contributing
It's probably difficult to allow multiple people working on the same
spreadsheet, so I'm currently working alone on this.
Examples, suggestions, hints, issues are very welcome, anyway.

If you know your LibreOffice macro programming or UNO, please drop me a
line (see [Maintainer](#maintainer))!
We'll try to share work on the spreadsheet.

## License
GNU General Public License v3.0 or later Marco Bresciani

This section also lists all the copyright notes for third parties
components used in this project.
```
 ,' ,-_-. '.
((_/)o o(\_))
 `-'(. .)`-'
     \_/

Copyright (C)  2019-2020  Marco Bresciani.

Copying and distribution of this file, with or without modification, are
permitted in any medium without royalty provided the copyright notice
and this notice are preserved. This file is offered as-is, without any
warranty.
```

### Official GPL Logo
These images are in the public domain. See
https://www.gnu.org/graphics/license-logos.html.en.

### Official GFDL Logo
Copyright © 2007, 2008, 2011, 2018 Free Software Foundation, Inc.
Available under the GNU Free Documentation License v1.3. See
https://www.gnu.org/graphics/license-logos.html.en.

### AMYMADE's buttons
AMYMADE's buttons for Definition of Free Cultural Works are in the
public domain as described in
https://freedomdefined.org/Logos_and_buttons#AMYMADE.27s_buttons

### GNU FreeFont
Both spreadsheet and the printable kanban board use and include **GNU
FreeFont 20120503**.
```
Free UCS scalable fonts is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 3 of the License, or (at
your option) any later version.

The fonts are distributed in the hope that they will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

As a special exception, if you create a document which uses this font,
and embed this font or unaltered portions of this font into the
document, this font does not by itself cause the resulting document to
be covered by the GNU General Public License. This exception does not
however invalidate any other reasons why the document might be covered
by the GNU General Public License. If you modify this font, you may
extend this exception to your version of the font, but you are not
obligated to do so.  If you do not wish to do so, delete this exception
statement from your version.
```
