# AAMfP: a simple (Personal) Kanban metrics spreadsheet for personal use #
Copyright © 2017, 2018 Marco Bresciani.	

![Creative Commons License](https://i.creativecommons.org/l/by-sa/4.0/80x15.png) *AAMfP: a simple (Personal) Kanban metrics spreadsheet for personal use* by *Marco Bresciani* is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International License](http://creativecommons.org/licenses/by-sa/4.0/).

## Intro ##
Improve your daily work and activities with this LibreOffice Calc spreadsheet using the concepts of "Personal Kanban" and applying some flow metrics as described in the book "Actionable Agile Metrics for Predictability" (and compatible with ActionableAgile™ Analytics tool).

## Usage ##
The only sheet you need to modify is the "Activities" sheet where you can add, for each activity, the dates when such activities have changed state. CoS (Class of Service) and WIT (Work Item Type) column values are not mandatory.

In order to have proper metrics, chart and data, you have to keep the "Activities" sheet rows in proper order. Ordering criteria are all following (crescent) ordered columns: "Done", "Doing", "Todo", "Deadline", "Backlog", "ID". Once the column are ordered in this way, you can scroll all other sheets where you can find the metrics and charts.

"Deadline" column value is optional and the content is conditionally formatted. Deadline is: today, red cell; this week, orange cell; this month, yellow cell; next month, green cell. Expired completed activity, red text.

The whole "Activities" sheet is compatible with ActionableAgile™ Analitycs tool (see https://www.actionableagile.com/format-data-file/): simply export "Activities" sheet as CSV (carefully select comma as cell separator) and then import it in the tool. 	

### Visualize your work ###
The "Downloads" page (see https://bitbucket.org/marcobresciani/aamfp/downloads/) contains a PDF and ODG (LibreOffice Draw) version of a printable Personal Kanban board with "Backlog", "Todo", "Doing" (with "Blocked") and "Done" columns.

### Limit your work-in-progress ###
Remember to add your WIP limit to each of the columns in the board above, to be sure to properly apply Kanban concepts and obtain real improvements.

## History	##
* v. 8.0.1 Solve bug #4. Rename columns to better fit KMM book.
* v. 8.0.0 Solve bugs #2 and #3. Plus add Links column.
* v. 7.2.1	Bug solved in the CFD. Now the column "Date" of the CFD Data starts from the min - 1 day  
* v. 7.2.0	Add “Age” to scatterplot to represent deleted or WIP activities current LT. Add “mLT” to scatterplot.
* v. 7.0.0	Moving back basic statistics to "LT Data" folder in order to keep better compatibility with ActionableAgile™ Analitycs tool.
* v. 6.0.0	Moving basic statistics to "Activities" folder making easier filtering scatterplot by CoS (or whatever).
* v. 5.0.0	English translation.
* v. 4.1.0	Grafico CFD fatto da cumulativo ("Dati CFD"). IN CORSO: aggiunta dati età in "Backlog".
* v. 4.0.0	Dati CFD da min(*) altrimenti i conti non tornano... Ricalcolo medie Little.
* v. 3.0.0	Rinominata "Opzioni" in "Backlog" per compatibilità col formato di ActionableAgile™ Analitycs.
* v. 2.0.0	Dati CFD da min("Fatto") invece che da min(*).
* v. 1.4.1	Rimosso il vincolo di inizio delle ascisse.
* v. 1.4.0	Massimo dell'ascissa dei grafici a massimo "Fatto", non più assoluto.
* v. 1.3.2	Arrotondamento (giorno) intero percentili e media.
* v. 1.3.1	Correzione calcolo throughput.
* v. 1.3.0	Formattazione automatica per attività chiuse in ritardo.
* v. 1.2.0	Formattazione automatica per Scadenza.
* v. 1.1.0	CoS filtrate per classi standard. Pagina dati efficienza (Flow Efficiency).
* v. 1.0.0  Vedi [SemVer](https://semver.org/).

## References ##
For the **Kanban** method starts from here: https://leankanban.com/project/wkanban/ and the Essential Kanban Condensed Guide https://leankanban.com/guide/.

For **Personal Kanban** starts from here: http://personalkanban.com/pk/ and the reference book http://personalkanban.com/pk/book/.

For more details on metrics read the book *Actionable Agile Metrics for Predictability* by Vacanti, Daniel S. here https://leanpub.com/actionableagilemetrics.