/*
**    This file is part of AASM.
**
**    AASM is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 3 of the License, or
**    (at your option) any later version.
**
**    AASM is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with AASM; if not, write to the Free Software
**    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**    Copyright Alexandre Becoulet, 2002
**    contact : alexandre.becoulet@free.fr
*/

#include <stdarg.h>
#include <string.h>

#include "aasm/error.h"

#include "scan.h"

/*
** decimal value
*/

const auto_state_t	automata_dec[1] =
  {
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1, -1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
  };

/*
** numerical value
** [0-9][0-9x][0-9a-fA-F]*
*/

const auto_state_t	automata_num[6] =
  {
    /* state 0 first digit */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1, -1, -1, -1, -1, -1, -1,  3, -1, -1, -1, -1, -1, -1, -1, -1,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      2,  1,  1,  1,  1,  1,  1,  1,  1,  1, -1, -1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},

    /* state 1 digit */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2, -2, -2,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -2,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -2,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},

    /* state 2 post 0 */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3, -3, -3, -3, -3, -3,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -3, -3, -1, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -3, -3, -3, -3, -3, -3, -3, -3, -1, -3, -3, -3, -3, -3, -3, -3,
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3,
     -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3},

    /* state 3 quoted value */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-4,  0,  0,  0,  0,  0,  0,  0,  0, -4,  0,  0, -4,  0,  0,  0,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},

    /* state 4 quote end */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
    /*0   0   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
     -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5},

    /* state 5 quoted value escape */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-6, -2, -2, -2, -2, -2, -2, -2, -2, -6, -2, -2, -6  -2, -2, -2,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2}
  };

const auto_state_t	automata_idf[2] =
  {
    /* state 0 [a-zA-Z_] */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -1, -1, -1, -1,  1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},

    /* state 1 [a-zA-Z0-9_] */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2, -2, -2,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2}
  };

/*
** section name
** .[a-zA-Z0-9_.]*
*/

const auto_state_t	automata_section[2] =
  {
    /* state 0 . */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  1, -1,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},

    /* state 1 [a-zA-Z0-9_.] */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,  0, -2,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2, -2, -2,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2}
  };

/*
** operand 
** xx, yy, 'a,b', zz, '\''
*/

const auto_state_t	automata_operand[3] =
  {
    /* state 0 */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1,  0,  0, -1,  0,  0,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1,  0,  0,  0,  0,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},

    /* state 1 ' ' */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-3,  0,  0,  0,  0,  0,  0,  0,  0,  0, -3,  0,  0, -3,  0,  0,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      0,  0,  0,  0,  0,  0,  0, -1,  0,  0,  0,  0,  0,  0,  0,  0,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},

    /* state 2 \ */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4, -1, -1, -4, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}
  };

/*
** simple string
** [^\r\n;]*
*/

const auto_state_t	automata_line[1] =
  {
    /* state 0 */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1,  0,  0, -1,  0,  0,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*0   0   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1,  0,  0,  0,  0,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}
  };

/*
** single char
** .
*/

const auto_state_t	automata_singlechar[2] =
  {
    /* state 0 */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1, -1, -1, -1, -1, -1, -1, -1, -1,  1, -1, -1, -1, -1, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    /*0   0   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1},

    /* state 1 */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*0   0   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
     -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2}
  };

/*
** simple word
** [^ \t\r\n;]*
*/

const auto_state_t	automata_word[1] =
  {
    /* state 0 */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1,  0,  0,  0,  0,  0,  0,  0,  0, -1, -1,  0,  0, -1,  0,  0,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*0   0   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1,  0,  0,  0,  0,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}
  };

/*
** spaces and comment
*/

const auto_state_t	automata_spacecomment[2] =
  {
    /* state 0 [/r/n/t ]* */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0, -1, -1,  0, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*0   0   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},

    /* state 1 ;.* */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}
  };

/*
** double quoted string
** "[^"\]*""
*/

const auto_state_t	automata_string[4] =
  {
    /* state 0 " */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1, -1,  1, -1, -1, -1, -1,  1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},

    /* state 1 [^"\] */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
      0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},

    /* state 2 . */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},

    /* state 3 */

    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
    {-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
    /*.   .   .   .   .   .   .   .   .   .   .   .   .   .   .   .  */
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
    /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
    /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
    /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
    /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
    /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
    /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
     -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4},
  };

unsigned int	scan_store(const char	*in,
			   const char	**end,
			   const char	*format,
			   ...)
{
  va_list			ap;
  unsigned int			match_count = 0;

  va_start(ap, format);
  while (*format && *in)
    {
      switch (format[0])
	{
	  /* space and comment */
	case ('#'):
	  {
	    int			state = 0;

	    while ((state += automata_spacecomment[state][(unsigned)*in]) >= 0)
	      in++;
	    format++;
	  }
	  break;

	  /* expr match and store */
	case ('%'):
	  {
	    int			state = 0;
	    const auto_state_t	*automata;
	    char		*out = va_arg(ap, char *);

	    /* set automata used for string match */
	    switch (format[1])
	      {
	      case ('s'):
		automata = automata_string;
		break;
	      case ('o'):
		automata = automata_operand;
		break;
	      case ('i'):
		automata = automata_idf;
		break;
	      case ('l'):
		automata = automata_line;
		break;
	      case ('S'):
		automata = automata_section;
		break;
	      case ('w'):
		automata = automata_word;
		break;
	      case ('n'):
		automata = automata_num;
		break;

	      default:
		goto scan_store_end;
	      }

	    /* match at least 1 char and copy to out if != NULL */
	    if ((state += automata[state][(unsigned)*in]) >= 0)
	      {
		if (out)
		  {
		    *out++ = *in++;
		    while ((state += automata[state][(unsigned)*in]) >= 0)
		      *out++ = *in++;
		    *out = 0;
		  }
		else
		  {
		    in++;
		    while ((state += automata[state][(unsigned)*in]) >= 0)
		      in++;
		  }

		if (state < -1) /* exit state < -1 mean don't match */
		  goto scan_store_end;
		else
		  match_count++;
	      }
	    else
	      goto scan_store_end;

	    format += 2;
	  }
	  break;

	  /* match single char */
	default:
	  if (format[0] != in[0])
	    goto scan_store_end;
	  format++, in++;
	}
    }

 scan_store_end:
  if (end)
    *end = in;

  va_end(ap);
  return (match_count);
}

const char	*scan_skip(const char		*str,
			   const auto_state_t	*automata)
{
  int			state = 0;

  while ((state += automata[state][(unsigned)*str]) >= 0)
    str++;

  return (str);
}

unsigned int	scan_get_len(const char			*str,
			     const auto_state_t		*automata)
{
  int			state = 0;
  unsigned int		i = 0;

  while ((state += automata[state][(unsigned)str[i]]) >= 0)
    i++;

  return (i);
}

const char	*scan_get_end(const char		*str,
			      const auto_state_t	*automata,
			      const char		**end,
			      char			*buffer)
{
  int			state = 0;
  unsigned int		i = 0;

  while ((state += automata[state][(unsigned)str[i]]) >= 0)
    buffer[i] = str[i], i++;
  buffer[i] = 0;

  *end = str + i;
  return (buffer);
}

const char	*scan_get(const char		*str,
			  const auto_state_t	*automata,
			  char			*buffer)
{
  int			state = 0;
  unsigned int		i = 0;

  while ((state += automata[state][(unsigned)str[i]]) >= 0)
    buffer[i] = str[i], i++;
  buffer[i] = 0;

  return (buffer);
}

unsigned int	scan_hash(const char		*str,
			  const auto_state_t	*automata)
{
  int			state = 0;
  unsigned int		i = 0;
  unsigned int		hash = 0;

  while ((state += automata[state][(unsigned)str[i]]) >= 0)
    {
      hash ^= str[i] << i;
      i++;
    }

  return (hash);
}

static const char		scan_stresc[256] =
  {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
    -1, -1, 34, -1, -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, -1,
   /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 92, -1, -1, -1,
   /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
    -1,  7,  8, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, 10, -1,
   /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
    -1, -1, 13, -1,  9, -1, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
  };

static const int		scan_num_val[256] =
  {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*    !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /  */
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?  */
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1,
   /*@   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O  */
    -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _  */
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*`   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o  */
    -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   /*p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~   .  */
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
  };

unsigned int	scan_string_escape(const aasm_u8_t	*in,
				   aasm_u8_t		*out,
				   unsigned		end_char)
{
  const aasm_u8_t	*start = out;

  while (*in && (*in != end_char))
    {
      if (in[0] == '\\')
	{
	  int		val1;
	  int		val2;

	  switch (in[1])
	    {
	    case ('0'):
	    case ('a'):
	    case ('b'):
	    case ('t'):
	    case ('n'):
	    case ('v'):
	    case ('f'):
	    case ('r'):
	    case ('\\'):
	    case ('\''):
	    case ('"'):
	      *out++ = scan_stresc[in[1]];
	      in += 2;
	      break;

	    case ('x'):
	      if ((val1 = scan_num_val[in[2]]) >= 0)
		{
		  in++;
		  if ((val2 = scan_num_val[in[2]]) >= 0)
		    {
		      *out++ = (val1 << 4) | val2;
		      in += 3;
		      break;
		    }
		}

	    default:
	      in++;

	    case (0):
	      in++;
	      error(ERRTYP_WARN, "invalid escape char in string (ignored)", 0);
	    }
	}
      else
	*out++ = *in++;
    }

  if (!*in)
    error(ERRTYP_ERROR, "no ending quote found", 0);

  return (out - start);
}
