/* Generated by re2c 2.0.2 */
#line 1 "../wisitoken_grammar.re2c"
//  generated parser support file. -*- buffer-read-only:t mode: C -*-
//  command line: wisitoken-bnf-generate.exe  --generate LALR Ada re2c wisitoken_grammar.wy
//

//  Copyright (C) 2017 - 2022 Free Software Foundation, Inc.
//
//  Author: Stephen Leake <stephe-leake@stephe-leake.org>
//
//  This file is part of GNU Emacs.
//
//  GNU Emacs is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  GNU Emacs is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with GNU Emacs.  If not, see <http://www.gnu.org/licenses/>.

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>

typedef struct wisi_lexer
{
   unsigned char* buffer;           // input text, in utf-8 encoding
   unsigned char* buffer_last;      // last byte in buffer
   unsigned char* cursor;           // current byte
   unsigned char* byte_token_start; // byte position at start of current token
   size_t         char_pos;         // character position of current character
   size_t         char_token_start; // character position at start of current token
   int            line;             // 1 indexed
   int            line_token_start; // line at start of current token
   unsigned char* marker;           // saved cursor
   size_t         marker_pos;       // saved character position
   size_t         marker_line;      // saved line
   unsigned char* context;          // saved cursor
   size_t         context_pos;      // saved character position
   int            context_line;     // saved line
   int            verbosity;

} wisi_lexer;

#define YYCTYPE unsigned char

#define NO_ERROR 0
#define ERROR_unrecognized_character 1
wisi_lexer* wisitoken_grammar_new_lexer
   (unsigned char* input, size_t length, int verbosity)
{
   wisi_lexer* result        = malloc (sizeof (wisi_lexer));
   result->buffer            = input;
   result->buffer_last       = input + length - 1;
   result->cursor            = input;
   result->byte_token_start  = input;
   result->char_pos          = 1; /* match WisiToken.Buffer_Region */
   result->char_token_start  = 1;
   result->line              = 1;
   result->line_token_start  = result->line;
   result->verbosity         = 0;
   return result;
}

void
wisitoken_grammar_free_lexer(wisi_lexer** lexer)
{
   free(*lexer);
   *lexer = 0;
}

void
wisitoken_grammar_reset_lexer(wisi_lexer* lexer)
{
   lexer->cursor   = lexer->buffer;
   lexer->char_pos = 1;
   lexer->line     = 1;
}

void
wisitoken_grammar_set_verbosity
   (wisi_lexer* lexer, int verbosity)
{
   lexer->verbosity = verbosity;
}

void
wisitoken_grammar_set_position
   (wisi_lexer* lexer, size_t byte_position, size_t char_position, int line)
{
   lexer->cursor   = lexer->buffer + byte_position - 1;
   lexer->char_pos = char_position;
   lexer->line     = line;
}

static void debug(wisi_lexer* lexer, int state, unsigned char ch)
{
   if (lexer->verbosity > 0)
      {
      if (ch < ' ')
         printf ("lexer: %d, 0x%x\n", state, ch);
      else
         printf ("lexer: %d, '%c' 0x%x\n", state, ch, ch);
      }
}
#define YYDEBUG(state, ch) debug(lexer, state, ch)
#define YYCURSOR lexer->cursor

#define YYPEEK() (lexer->cursor <= lexer->buffer_last) ? *lexer->cursor : 4

static void skip(wisi_lexer* lexer)
{
   if (lexer->cursor <= lexer->buffer_last)
   {
      ++lexer->cursor;
      if (lexer->cursor <= lexer->buffer_last)
      {
         /* UFT-8 encoding: https://en.wikipedia.org/wiki/UTF-8#Description */
         if (*lexer->cursor == 0x0A && lexer->cursor > lexer->buffer && *(lexer->cursor - 1) == 0x0D)
           {/* second byte of DOS line ending */
           }
         else if ((*lexer->cursor & 0x80) == 0x80 && (*lexer->cursor & 0xC0) != 0xC0)
           {/* byte 2, 3 or 4 of multi-byte UTF-8 char */
           }
         else
           lexer->char_pos++;
      } else 
         lexer->char_pos++;
   }
}
#define YYSKIP() skip(lexer)
#define YYBACKUP() lexer->marker = lexer->cursor; lexer->marker_pos = lexer->char_pos;lexer->marker_line = lexer->line
#define YYRESTORE() lexer->cursor = lexer->marker; lexer->char_pos = lexer->marker_pos;lexer->line = lexer->marker_line
#define YYBACKUPCTX() lexer->context = lexer->cursor; lexer->context_pos = lexer->char_pos;lexer->context_line = lexer->line
#define YYRESTORECTX() lexer->cursor = lexer->context; lexer->char_pos = lexer->context_pos;lexer->line = lexer->context_line

static void skip_to(wisi_lexer* lexer, char* target)
{
  int i, j;

  // Count all new-lines contained in the skip region. Caller has 
  // skipped the start delimiter; if lexer->cursor is a new-line it
  // has not yet been counted. Start and end delimiters do not contain new-line.
  while (lexer->cursor <= lexer->buffer_last)
    {
      if (*lexer->cursor == 0x0A)
      {
        lexer->line++;
      }
      if (*lexer->cursor == target[0])
      {
        i = 0;
        do
          i++;
        while (0 != target[i] &&
               lexer->cursor + i <= lexer->buffer_last &&
               *(lexer->cursor + i) == target[i]);

        if (0 == target[i])
          {
            for (j = 0; j < i; j++)
               skip(lexer);
            break;
          }
      }
      skip(lexer);
    };
}

int wisitoken_grammar_next_token
  (wisi_lexer* lexer,
   int* id,
   size_t* byte_position,
   size_t* byte_length,
   size_t* char_position,
   size_t* char_length,
   int*    line_start,
   int*    line_length)
{
   int status = NO_ERROR;
   *id = -1;
   if (lexer->cursor > lexer->buffer_last)
   {
      *id            = 42;
      *byte_position = lexer->buffer_last - lexer->buffer + 2;
      *byte_length   = 0;
      *char_position = lexer->char_pos;
      *char_length   = 0;
      *line_start    = lexer->line;
      *line_length   = 0;
      return status;
   }

   lexer->byte_token_start = lexer->cursor;
   lexer->char_token_start = lexer->char_pos;
   lexer->line_token_start = lexer->line;

   while (*id == -1 && status == 0)
   {

#line 207 "../wisitoken_grammar_re2c.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	YYDEBUG(0, *YYCURSOR);
	yych = YYPEEK();
	switch (yych) {
	case 0x04:	goto yy4;
	case '\t':
	case ' ':	goto yy6;
	case '\n':	goto yy8;
	case '\r':	goto yy10;
	case '"':	goto yy11;
	case '%':	goto yy12;
	case '\'':	goto yy14;
	case '(':	goto yy15;
	case ')':	goto yy17;
	case '*':	goto yy19;
	case '+':	goto yy21;
	case '-':	goto yy23;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy25;
	case ':':	goto yy28;
	case ';':	goto yy30;
	case '<':	goto yy32;
	case '=':	goto yy34;
	case '>':	goto yy36;
	case '?':	goto yy38;
	case 'A':
	case 'a':	goto yy40;
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'b':
	case 'd':
	case 'f':
	case 'g':
	case 'h':
	case 'j':
	case 'l':
	case 'm':
	case 'p':
	case 'q':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy42;
	case 'R':
	case 'r':	goto yy44;
	case 'S':
	case 's':	goto yy45;
	case '[':	goto yy46;
	case ']':	goto yy48;
	case 'c':	goto yy50;
	case 'e':	goto yy51;
	case 'i':	goto yy52;
	case 'k':	goto yy53;
	case 'n':	goto yy54;
	case 'o':	goto yy55;
	case 't':	goto yy56;
	case '{':	goto yy57;
	case '|':	goto yy59;
	case '}':	goto yy61;
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy63;
	case 0xE0:	goto yy64;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy65;
	case 0xF0:	goto yy66;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy67;
	case 0xF4:	goto yy68;
	default:	goto yy2;
	}
yy2:
	YYDEBUG(2, YYPEEK());
	YYSKIP();
yy3:
	YYDEBUG(3, YYPEEK());
#line 296 "../wisitoken_grammar.re2c"
	{status = ERROR_unrecognized_character; continue;}
#line 360 "../wisitoken_grammar_re2c.c"
yy4:
	YYDEBUG(4, YYPEEK());
	YYSKIP();
	YYDEBUG(5, YYPEEK());
#line 294 "../wisitoken_grammar.re2c"
	{*id = 42; continue;}
#line 367 "../wisitoken_grammar_re2c.c"
yy6:
	YYDEBUG(6, YYPEEK());
	YYSKIP();
	YYDEBUG(7, YYPEEK());
#line 249 "../wisitoken_grammar.re2c"
	{ lexer->byte_token_start = lexer->cursor;
          lexer->char_token_start = lexer->char_pos;
          lexer->line_token_start = lexer->line;
          continue; }
#line 377 "../wisitoken_grammar_re2c.c"
yy8:
	YYDEBUG(8, YYPEEK());
	YYSKIP();
	YYDEBUG(9, YYPEEK());
#line 253 "../wisitoken_grammar.re2c"
	{*id = 1; lexer->line++; continue;}
#line 384 "../wisitoken_grammar_re2c.c"
yy10:
	YYDEBUG(10, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case '\n':	goto yy8;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case '{':
	case '|':
	case '}':
	case '~':
	case 0x7F:
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy70;
	default:	goto yy3;
	}
yy12:
	YYDEBUG(12, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case '(':	goto yy80;
	case '[':	goto yy82;
	case '{':	goto yy84;
	default:	goto yy13;
	}
yy13:
	YYDEBUG(13, YYPEEK());
#line 282 "../wisitoken_grammar.re2c"
	{*id = 30; continue;}
#line 563 "../wisitoken_grammar_re2c.c"
yy14:
	YYDEBUG(14, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case '{':
	case '|':
	case '}':
	case '~':
	case 0x7F:
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy87;
	default:	goto yy3;
	}
yy15:
	YYDEBUG(15, YYPEEK());
	YYSKIP();
	YYDEBUG(16, YYPEEK());
#line 279 "../wisitoken_grammar.re2c"
	{*id = 27; continue;}
#line 726 "../wisitoken_grammar_re2c.c"
yy17:
	YYDEBUG(17, YYPEEK());
	YYSKIP();
	YYDEBUG(18, YYPEEK());
#line 287 "../wisitoken_grammar.re2c"
	{*id = 35; continue;}
#line 733 "../wisitoken_grammar_re2c.c"
yy19:
	YYDEBUG(19, YYPEEK());
	YYSKIP();
	YYDEBUG(20, YYPEEK());
#line 289 "../wisitoken_grammar.re2c"
	{*id = 37; continue;}
#line 740 "../wisitoken_grammar_re2c.c"
yy21:
	YYDEBUG(21, YYPEEK());
	YYSKIP();
	YYDEBUG(22, YYPEEK());
#line 283 "../wisitoken_grammar.re2c"
	{*id = 31; continue;}
#line 747 "../wisitoken_grammar_re2c.c"
yy23:
	YYDEBUG(23, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case '_':	goto yy25;
	default:	goto yy24;
	}
yy24:
	YYDEBUG(24, YYPEEK());
#line 281 "../wisitoken_grammar.re2c"
	{*id = 29; continue;}
#line 770 "../wisitoken_grammar_re2c.c"
yy25:
	YYDEBUG(25, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	YYDEBUG(26, YYPEEK());
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case '_':	goto yy25;
	default:	goto yy27;
	}
yy27:
	YYDEBUG(27, YYPEEK());
#line 290 "../wisitoken_grammar.re2c"
	{*id = 38; continue;}
#line 794 "../wisitoken_grammar_re2c.c"
yy28:
	YYDEBUG(28, YYPEEK());
	yyaccept = 1;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case ':':	goto yy96;
	default:	goto yy29;
	}
yy29:
	YYDEBUG(29, YYPEEK());
#line 273 "../wisitoken_grammar.re2c"
	{*id = 21; continue;}
#line 809 "../wisitoken_grammar_re2c.c"
yy30:
	YYDEBUG(30, YYPEEK());
	yyaccept = 2;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case ';':	goto yy97;
	default:	goto yy31;
	}
yy31:
	YYDEBUG(31, YYPEEK());
#line 288 "../wisitoken_grammar.re2c"
	{*id = 36; continue;}
#line 824 "../wisitoken_grammar_re2c.c"
yy32:
	YYDEBUG(32, YYPEEK());
	YYSKIP();
	YYDEBUG(33, YYPEEK());
#line 280 "../wisitoken_grammar.re2c"
	{*id = 28; continue;}
#line 831 "../wisitoken_grammar_re2c.c"
yy34:
	YYDEBUG(34, YYPEEK());
	YYSKIP();
	YYDEBUG(35, YYPEEK());
#line 275 "../wisitoken_grammar.re2c"
	{*id = 23; continue;}
#line 838 "../wisitoken_grammar_re2c.c"
yy36:
	YYDEBUG(36, YYPEEK());
	YYSKIP();
	YYDEBUG(37, YYPEEK());
#line 276 "../wisitoken_grammar.re2c"
	{*id = 24; continue;}
#line 845 "../wisitoken_grammar_re2c.c"
yy38:
	YYDEBUG(38, YYPEEK());
	YYSKIP();
	YYDEBUG(39, YYPEEK());
#line 284 "../wisitoken_grammar.re2c"
	{*id = 32; continue;}
#line 852 "../wisitoken_grammar_re2c.c"
yy40:
	YYDEBUG(40, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'C':
	case 'c':	goto yy99;
	default:	goto yy43;
	}
yy41:
	YYDEBUG(41, YYPEEK());
#line 291 "../wisitoken_grammar.re2c"
	{*id = 39; continue;}
#line 868 "../wisitoken_grammar_re2c.c"
yy42:
	YYDEBUG(42, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
yy43:
	YYDEBUG(43, YYPEEK());
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy42;
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy100;
	case 0xE0:	goto yy101;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy102;
	case 0xF0:	goto yy103;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy104;
	case 0xF4:	goto yy105;
	default:	goto yy41;
	}
yy44:
	YYDEBUG(44, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'E':
	case 'e':	goto yy106;
	default:	goto yy43;
	}
yy45:
	YYDEBUG(45, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'H':
	case 'h':	goto yy107;
	default:	goto yy43;
	}
yy46:
	YYDEBUG(46, YYPEEK());
	YYSKIP();
	YYDEBUG(47, YYPEEK());
#line 278 "../wisitoken_grammar.re2c"
	{*id = 26; continue;}
#line 1023 "../wisitoken_grammar_re2c.c"
yy48:
	YYDEBUG(48, YYPEEK());
	YYSKIP();
	YYDEBUG(49, YYPEEK());
#line 286 "../wisitoken_grammar.re2c"
	{*id = 34; continue;}
#line 1030 "../wisitoken_grammar_re2c.c"
yy50:
	YYDEBUG(50, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'o':	goto yy108;
	default:	goto yy43;
	}
yy51:
	YYDEBUG(51, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'l':	goto yy109;
	case 'n':	goto yy110;
	default:	goto yy43;
	}
yy52:
	YYDEBUG(52, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'f':	goto yy111;
	case 'n':	goto yy113;
	default:	goto yy43;
	}
yy53:
	YYDEBUG(53, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'e':	goto yy115;
	default:	goto yy43;
	}
yy54:
	YYDEBUG(54, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'o':	goto yy116;
	default:	goto yy43;
	}
yy55:
	YYDEBUG(55, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'n':	goto yy117;
	default:	goto yy43;
	}
yy56:
	YYDEBUG(56, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'o':	goto yy119;
	default:	goto yy43;
	}
yy57:
	YYDEBUG(57, YYPEEK());
	YYSKIP();
	YYDEBUG(58, YYPEEK());
#line 277 "../wisitoken_grammar.re2c"
	{*id = 25; continue;}
#line 1109 "../wisitoken_grammar_re2c.c"
yy59:
	YYDEBUG(59, YYPEEK());
	YYSKIP();
	YYDEBUG(60, YYPEEK());
#line 272 "../wisitoken_grammar.re2c"
	{*id = 20; continue;}
#line 1116 "../wisitoken_grammar_re2c.c"
yy61:
	YYDEBUG(61, YYPEEK());
	YYSKIP();
	YYDEBUG(62, YYPEEK());
#line 285 "../wisitoken_grammar.re2c"
	{*id = 33; continue;}
#line 1123 "../wisitoken_grammar_re2c.c"
yy63:
	YYDEBUG(63, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy42;
	default:	goto yy3;
	}
yy64:
	YYDEBUG(64, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy100;
	default:	goto yy3;
	}
yy65:
	YYDEBUG(65, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy100;
	default:	goto yy3;
	}
yy66:
	YYDEBUG(66, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy102;
	default:	goto yy3;
	}
yy67:
	YYDEBUG(67, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy102;
	default:	goto yy3;
	}
yy68:
	YYDEBUG(68, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy102;
	default:	goto yy3;
	}
yy69:
	YYDEBUG(69, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
yy70:
	YYDEBUG(70, YYPEEK());
	switch (yych) {
	case ' ':
	case '!':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case '{':
	case '|':
	case '}':
	case '~':
	case 0x7F:	goto yy69;
	case '"':	goto yy72;
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy74;
	case 0xE0:	goto yy75;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy76;
	case 0xF0:	goto yy77;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy78;
	case 0xF4:	goto yy79;
	default:	goto yy71;
	}
yy71:
	YYDEBUG(71, YYPEEK());
	YYRESTORE();
	switch (yyaccept) {
	case 0:
		goto yy3;
	case 1:
		goto yy29;
	case 2:
		goto yy31;
	case 3:
		goto yy41;
	case 4:
		goto yy73;
	case 5:
		goto yy89;
	case 6:
		goto yy112;
	case 7:
		goto yy114;
	case 8:
		goto yy118;
	case 9:
		goto yy137;
	case 10:
		goto yy145;
	case 11:
		goto yy154;
	case 12:
		goto yy157;
	case 13:
		goto yy161;
	case 14:
		goto yy164;
	case 15:
		goto yy171;
	case 16:
		goto yy175;
	case 17:
		goto yy178;
	case 18:
		goto yy185;
	default:
		goto yy194;
	}
yy72:
	YYDEBUG(72, YYPEEK());
	yyaccept = 4;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '"':	goto yy69;
	default:	goto yy73;
	}
yy73:
	YYDEBUG(73, YYPEEK());
#line 292 "../wisitoken_grammar.re2c"
	{*id = 40; continue;}
#line 1679 "../wisitoken_grammar_re2c.c"
yy74:
	YYDEBUG(74, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy69;
	default:	goto yy71;
	}
yy75:
	YYDEBUG(75, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy74;
	default:	goto yy71;
	}
yy76:
	YYDEBUG(76, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy74;
	default:	goto yy71;
	}
yy77:
	YYDEBUG(77, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy76;
	default:	goto yy71;
	}
yy78:
	YYDEBUG(78, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy76;
	default:	goto yy71;
	}
yy79:
	YYDEBUG(79, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy76;
	default:	goto yy71;
	}
yy80:
	YYDEBUG(80, YYPEEK());
	YYSKIP();
	YYDEBUG(81, YYPEEK());
#line 271 "../wisitoken_grammar.re2c"
	{*id = 19; skip_to(lexer, ")%"); continue;}
#line 2016 "../wisitoken_grammar_re2c.c"
yy82:
	YYDEBUG(82, YYPEEK());
	YYSKIP();
	YYDEBUG(83, YYPEEK());
#line 270 "../wisitoken_grammar.re2c"
	{*id = 18; skip_to(lexer, "]%"); continue;}
#line 2023 "../wisitoken_grammar_re2c.c"
yy84:
	YYDEBUG(84, YYPEEK());
	YYSKIP();
	YYDEBUG(85, YYPEEK());
#line 269 "../wisitoken_grammar.re2c"
	{*id = 17; skip_to(lexer, "}%"); continue;}
#line 2030 "../wisitoken_grammar_re2c.c"
yy86:
	YYDEBUG(86, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
yy87:
	YYDEBUG(87, YYPEEK());
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case '{':
	case '|':
	case '}':
	case '~':
	case 0x7F:	goto yy86;
	case '\'':	goto yy88;
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy90;
	case 0xE0:	goto yy91;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy92;
	case 0xF0:	goto yy93;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy94;
	case 0xF4:	goto yy95;
	default:	goto yy71;
	}
yy88:
	YYDEBUG(88, YYPEEK());
	yyaccept = 5;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '\'':	goto yy86;
	default:	goto yy89;
	}
yy89:
	YYDEBUG(89, YYPEEK());
#line 293 "../wisitoken_grammar.re2c"
	{*id = 41; continue;}
#line 2201 "../wisitoken_grammar_re2c.c"
yy90:
	YYDEBUG(90, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy86;
	default:	goto yy71;
	}
yy91:
	YYDEBUG(91, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy90;
	default:	goto yy71;
	}
yy92:
	YYDEBUG(92, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy90;
	default:	goto yy71;
	}
yy93:
	YYDEBUG(93, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy92;
	default:	goto yy71;
	}
yy94:
	YYDEBUG(94, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy92;
	default:	goto yy71;
	}
yy95:
	YYDEBUG(95, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy92;
	default:	goto yy71;
	}
yy96:
	YYDEBUG(96, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case '=':	goto yy120;
	default:	goto yy71;
	}
yy97:
	YYDEBUG(97, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	YYDEBUG(98, YYPEEK());
	switch (yych) {
	case 0x00:
	case 0x01:
	case 0x02:
	case 0x03:
	case 0x05:
	case 0x06:
	case 0x07:
	case 0x08:
	case '\t':
	case '\v':
	case '\f':
	case '\r':
	case 0x0E:
	case 0x0F:
	case 0x10:
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
	case 0x15:
	case 0x16:
	case 0x17:
	case 0x18:
	case 0x19:
	case 0x1A:
	case 0x1B:
	case 0x1C:
	case 0x1D:
	case 0x1E:
	case 0x1F:
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':
	case '/':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '@':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '[':
	case '\\':
	case ']':
	case '^':
	case '_':
	case '`':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case '{':
	case '|':
	case '}':
	case '~':
	case 0x7F:	goto yy97;
	case 0x04:
	case '\n':	goto yy122;
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	goto yy124;
	case 0xE0:	goto yy125;
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:	goto yy126;
	case 0xF0:	goto yy127;
	case 0xF1:
	case 0xF2:
	case 0xF3:	goto yy128;
	case 0xF4:	goto yy129;
	default:	goto yy71;
	}
yy99:
	YYDEBUG(99, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'C':
	case 'c':	goto yy130;
	default:	goto yy43;
	}
yy100:
	YYDEBUG(100, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy42;
	default:	goto yy71;
	}
yy101:
	YYDEBUG(101, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy100;
	default:	goto yy71;
	}
yy102:
	YYDEBUG(102, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy100;
	default:	goto yy71;
	}
yy103:
	YYDEBUG(103, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy102;
	default:	goto yy71;
	}
yy104:
	YYDEBUG(104, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy102;
	default:	goto yy71;
	}
yy105:
	YYDEBUG(105, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy102;
	default:	goto yy71;
	}
yy106:
	YYDEBUG(106, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'D':
	case 'd':	goto yy131;
	default:	goto yy43;
	}
yy107:
	YYDEBUG(107, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'I':
	case 'i':	goto yy132;
	default:	goto yy43;
	}
yy108:
	YYDEBUG(108, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'd':	goto yy133;
	case 'n':	goto yy134;
	default:	goto yy43;
	}
yy109:
	YYDEBUG(109, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 's':	goto yy135;
	default:	goto yy43;
	}
yy110:
	YYDEBUG(110, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'd':	goto yy136;
	default:	goto yy43;
	}
yy111:
	YYDEBUG(111, YYPEEK());
	yyaccept = 6;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy112;
	}
yy112:
	YYDEBUG(112, YYPEEK());
#line 261 "../wisitoken_grammar.re2c"
	{*id = 9; continue;}
#line 3249 "../wisitoken_grammar_re2c.c"
yy113:
	YYDEBUG(113, YYPEEK());
	yyaccept = 7;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy114;
	}
yy114:
	YYDEBUG(114, YYPEEK());
#line 262 "../wisitoken_grammar.re2c"
	{*id = 10; continue;}
#line 3378 "../wisitoken_grammar_re2c.c"
yy115:
	YYDEBUG(115, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'y':	goto yy138;
	default:	goto yy43;
	}
yy116:
	YYDEBUG(116, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'n':	goto yy139;
	default:	goto yy43;
	}
yy117:
	YYDEBUG(117, YYPEEK());
	yyaccept = 8;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy118;
	}
yy118:
	YYDEBUG(118, YYPEEK());
#line 265 "../wisitoken_grammar.re2c"
	{*id = 13; continue;}
#line 3527 "../wisitoken_grammar_re2c.c"
yy119:
	YYDEBUG(119, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'k':	goto yy140;
	default:	goto yy43;
	}
yy120:
	YYDEBUG(120, YYPEEK());
	YYSKIP();
	YYDEBUG(121, YYPEEK());
#line 274 "../wisitoken_grammar.re2c"
	{*id = 22; continue;}
#line 3544 "../wisitoken_grammar_re2c.c"
yy122:
	YYDEBUG(122, YYPEEK());
	YYSKIP();
	YYDEBUG(123, YYPEEK());
#line 254 "../wisitoken_grammar.re2c"
	{*id = 2; if (lexer->cursor[-1] == 0x0a || (lexer->cursor[-1] == 0x0d && lexer->cursor[-2] == 0x0a)) lexer->line++; continue;}
#line 3551 "../wisitoken_grammar_re2c.c"
yy124:
	YYDEBUG(124, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy97;
	default:	goto yy71;
	}
yy125:
	YYDEBUG(125, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy124;
	default:	goto yy71;
	}
yy126:
	YYDEBUG(126, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy124;
	default:	goto yy71;
	}
yy127:
	YYDEBUG(127, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy126;
	default:	goto yy71;
	}
yy128:
	YYDEBUG(128, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xA8:
	case 0xA9:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
	case 0xB0:
	case 0xB1:
	case 0xB2:
	case 0xB3:
	case 0xB4:
	case 0xB5:
	case 0xB6:
	case 0xB7:
	case 0xB8:
	case 0xB9:
	case 0xBA:
	case 0xBB:
	case 0xBC:
	case 0xBD:
	case 0xBE:
	case 0xBF:	goto yy126;
	default:	goto yy71;
	}
yy129:
	YYDEBUG(129, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:	goto yy126;
	default:	goto yy71;
	}
yy130:
	YYDEBUG(130, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'E':
	case 'e':	goto yy141;
	default:	goto yy43;
	}
yy131:
	YYDEBUG(131, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'U':
	case 'u':	goto yy142;
	default:	goto yy43;
	}
yy132:
	YYDEBUG(132, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'F':
	case 'f':	goto yy143;
	default:	goto yy43;
	}
yy133:
	YYDEBUG(133, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'e':	goto yy144;
	default:	goto yy43;
	}
yy134:
	YYDEBUG(134, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'f':	goto yy146;
	default:	goto yy43;
	}
yy135:
	YYDEBUG(135, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'i':	goto yy147;
	default:	goto yy43;
	}
yy136:
	YYDEBUG(136, YYPEEK());
	yyaccept = 9;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy137;
	}
yy137:
	YYDEBUG(137, YYPEEK());
#line 259 "../wisitoken_grammar.re2c"
	{*id = 7; continue;}
#line 4073 "../wisitoken_grammar_re2c.c"
yy138:
	YYDEBUG(138, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'w':	goto yy148;
	default:	goto yy43;
	}
yy139:
	YYDEBUG(139, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '_':	goto yy149;
	default:	goto yy43;
	}
yy140:
	YYDEBUG(140, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'e':	goto yy150;
	default:	goto yy43;
	}
yy141:
	YYDEBUG(141, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'P':
	case 'p':	goto yy151;
	default:	goto yy43;
	}
yy142:
	YYDEBUG(142, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'C':
	case 'c':	goto yy152;
	default:	goto yy43;
	}
yy143:
	YYDEBUG(143, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'T':
	case 't':	goto yy153;
	default:	goto yy43;
	}
yy144:
	YYDEBUG(144, YYPEEK());
	yyaccept = 10;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy145;
	}
yy145:
	YYDEBUG(145, YYPEEK());
#line 256 "../wisitoken_grammar.re2c"
	{*id = 4; continue;}
#line 4265 "../wisitoken_grammar_re2c.c"
yy146:
	YYDEBUG(146, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'l':	goto yy155;
	default:	goto yy43;
	}
yy147:
	YYDEBUG(147, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'f':	goto yy156;
	default:	goto yy43;
	}
yy148:
	YYDEBUG(148, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'o':	goto yy158;
	default:	goto yy43;
	}
yy149:
	YYDEBUG(149, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'g':	goto yy159;
	default:	goto yy43;
	}
yy150:
	YYDEBUG(150, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'n':	goto yy160;
	default:	goto yy43;
	}
yy151:
	YYDEBUG(151, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'T':
	case 't':	goto yy162;
	default:	goto yy43;
	}
yy152:
	YYDEBUG(152, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'E':
	case 'e':	goto yy163;
	default:	goto yy43;
	}
yy153:
	YYDEBUG(153, YYPEEK());
	yyaccept = 11;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy154;
	}
yy154:
	YYDEBUG(154, YYPEEK());
#line 267 "../wisitoken_grammar.re2c"
	{*id = 15; continue;}
#line 4466 "../wisitoken_grammar_re2c.c"
yy155:
	YYDEBUG(155, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'i':	goto yy165;
	default:	goto yy43;
	}
yy156:
	YYDEBUG(156, YYPEEK());
	yyaccept = 12;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy157;
	}
yy157:
	YYDEBUG(157, YYPEEK());
#line 260 "../wisitoken_grammar.re2c"
	{*id = 8; continue;}
#line 4605 "../wisitoken_grammar_re2c.c"
yy158:
	YYDEBUG(158, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'r':	goto yy166;
	default:	goto yy43;
	}
yy159:
	YYDEBUG(159, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'r':	goto yy167;
	default:	goto yy43;
	}
yy160:
	YYDEBUG(160, YYPEEK());
	yyaccept = 13;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy161;
	}
yy161:
	YYDEBUG(161, YYPEEK());
#line 268 "../wisitoken_grammar.re2c"
	{*id = 16; continue;}
#line 4754 "../wisitoken_grammar_re2c.c"
yy162:
	YYDEBUG(162, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '_':	goto yy168;
	default:	goto yy43;
	}
yy163:
	YYDEBUG(163, YYPEEK());
	yyaccept = 14;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy164;
	}
yy164:
	YYDEBUG(164, YYPEEK());
#line 266 "../wisitoken_grammar.re2c"
	{*id = 14; continue;}
#line 4893 "../wisitoken_grammar_re2c.c"
yy165:
	YYDEBUG(165, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'c':	goto yy169;
	default:	goto yy43;
	}
yy166:
	YYDEBUG(166, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'd':	goto yy170;
	default:	goto yy43;
	}
yy167:
	YYDEBUG(167, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'a':	goto yy172;
	default:	goto yy43;
	}
yy168:
	YYDEBUG(168, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'I':
	case 'i':	goto yy173;
	default:	goto yy43;
	}
yy169:
	YYDEBUG(169, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 't':	goto yy174;
	default:	goto yy43;
	}
yy170:
	YYDEBUG(170, YYPEEK());
	yyaccept = 15;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy171;
	}
yy171:
	YYDEBUG(171, YYPEEK());
#line 263 "../wisitoken_grammar.re2c"
	{*id = 11; continue;}
#line 5073 "../wisitoken_grammar_re2c.c"
yy172:
	YYDEBUG(172, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'm':	goto yy176;
	default:	goto yy43;
	}
yy173:
	YYDEBUG(173, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'T':
	case 't':	goto yy177;
	default:	goto yy43;
	}
yy174:
	YYDEBUG(174, YYPEEK());
	yyaccept = 16;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	case '_':	goto yy179;
	default:	goto yy175;
	}
yy175:
	YYDEBUG(175, YYPEEK());
#line 257 "../wisitoken_grammar.re2c"
	{*id = 5; continue;}
#line 5223 "../wisitoken_grammar_re2c.c"
yy176:
	YYDEBUG(176, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'm':	goto yy180;
	default:	goto yy43;
	}
yy177:
	YYDEBUG(177, YYPEEK());
	yyaccept = 17;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy178;
	}
yy178:
	YYDEBUG(178, YYPEEK());
#line 255 "../wisitoken_grammar.re2c"
	{*id = 3; continue;}
#line 5362 "../wisitoken_grammar_re2c.c"
yy179:
	YYDEBUG(179, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'r':	goto yy181;
	default:	goto yy43;
	}
yy180:
	YYDEBUG(180, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'a':	goto yy182;
	default:	goto yy43;
	}
yy181:
	YYDEBUG(181, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'e':	goto yy183;
	default:	goto yy43;
	}
yy182:
	YYDEBUG(182, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'r':	goto yy184;
	default:	goto yy43;
	}
yy183:
	YYDEBUG(183, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 's':	goto yy186;
	default:	goto yy43;
	}
yy184:
	YYDEBUG(184, YYPEEK());
	yyaccept = 18;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy185;
	}
yy185:
	YYDEBUG(185, YYPEEK());
#line 264 "../wisitoken_grammar.re2c"
	{*id = 12; continue;}
#line 5541 "../wisitoken_grammar_re2c.c"
yy186:
	YYDEBUG(186, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'o':	goto yy187;
	default:	goto yy43;
	}
yy187:
	YYDEBUG(187, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'l':	goto yy188;
	default:	goto yy43;
	}
yy188:
	YYDEBUG(188, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'u':	goto yy189;
	default:	goto yy43;
	}
yy189:
	YYDEBUG(189, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 't':	goto yy190;
	default:	goto yy43;
	}
yy190:
	YYDEBUG(190, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'i':	goto yy191;
	default:	goto yy43;
	}
yy191:
	YYDEBUG(191, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'o':	goto yy192;
	default:	goto yy43;
	}
yy192:
	YYDEBUG(192, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case 'n':	goto yy193;
	default:	goto yy43;
	}
yy193:
	YYDEBUG(193, YYPEEK());
	yyaccept = 19;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':
	case 0xC2:
	case 0xC3:
	case 0xC4:
	case 0xC5:
	case 0xC6:
	case 0xC7:
	case 0xC8:
	case 0xC9:
	case 0xCA:
	case 0xCB:
	case 0xCC:
	case 0xCD:
	case 0xCE:
	case 0xCF:
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
	case 0xD4:
	case 0xD5:
	case 0xD6:
	case 0xD7:
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xE8:
	case 0xE9:
	case 0xEA:
	case 0xEB:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
	case 0xF0:
	case 0xF1:
	case 0xF2:
	case 0xF3:
	case 0xF4:	goto yy43;
	default:	goto yy194;
	}
yy194:
	YYDEBUG(194, YYPEEK());
#line 258 "../wisitoken_grammar.re2c"
	{*id = 6; continue;}
#line 5740 "../wisitoken_grammar_re2c.c"
}
#line 297 "../wisitoken_grammar.re2c"

   }
   /* lexer->cursor and lexer ->char_pos are one char past end of token */
   *byte_position = lexer->byte_token_start - lexer->buffer + 1;
   *byte_length   = lexer->cursor - lexer->byte_token_start;
   *char_position = lexer->char_token_start;
   *char_length   = lexer->char_pos - lexer->char_token_start;
   *line_start    = lexer->line_token_start;
   *line_length   = lexer->line - lexer->line_token_start;
   return status;
   }
