/* Generated by re2c 3.0 */
#line 1 "../wisitoken_grammar.re2c"
//  generated parser support file. -*- buffer-read-only:t mode: C -*-
//  command line: wisitoken-bnf-generate.exe  --generate LALR Ada re2c wisitoken_grammar.wy
//

//  Copyright (C) 2017 - 2022 Free Software Foundation, Inc.
//
//  Author: Stephen Leake <stephe-leake@stephe-leake.org>
//
//  This file is part of GNU Emacs.
//
//  GNU Emacs is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  GNU Emacs is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with GNU Emacs.  If not, see <http://www.gnu.org/licenses/>.

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>

typedef struct wisi_lexer
{
   unsigned char* buffer;           // input text, in utf-8 encoding
   unsigned char* buffer_last;      // last byte in buffer
   unsigned char* cursor;           // current byte
   unsigned char* byte_token_start; // byte position at start of current token
   size_t         char_pos;         // character position of current character
   size_t         char_token_start; // character position at start of current token
   int            line;             // 1 indexed
   int            line_token_start; // line at start of current token
   unsigned char* marker;           // saved cursor
   size_t         marker_pos;       // saved character position
   size_t         marker_line;      // saved line
   unsigned char* context;          // saved cursor
   size_t         context_pos;      // saved character position
   int            context_line;     // saved line
   int            verbosity;

} wisi_lexer;

#define YYCTYPE unsigned char

#define NO_ERROR 0
#define ERROR_unrecognized_character 1
wisi_lexer* wisitoken_grammar_new_lexer
   (unsigned char* input, size_t length, int verbosity)
{
   wisi_lexer* result        = malloc (sizeof (wisi_lexer));
   result->buffer            = input;
   result->buffer_last       = input + length - 1;
   result->cursor            = input;
   result->byte_token_start  = input;
   result->char_pos          = 1; /* match WisiToken.Buffer_Region */
   result->char_token_start  = 1;
   result->line              = 1;
   result->line_token_start  = result->line;
   result->verbosity         = 0;
   return result;
}

void
wisitoken_grammar_free_lexer(wisi_lexer** lexer)
{
   free(*lexer);
   *lexer = 0;
}

void
wisitoken_grammar_reset_lexer(wisi_lexer* lexer)
{
   lexer->cursor   = lexer->buffer;
   lexer->char_pos = 1;
   lexer->line     = 1;
}

void
wisitoken_grammar_set_verbosity
   (wisi_lexer* lexer, int verbosity)
{
   lexer->verbosity = verbosity;
}

void
wisitoken_grammar_set_position
   (wisi_lexer* lexer, size_t byte_position, size_t char_position, int line)
{
   lexer->cursor   = lexer->buffer + byte_position - 1;
   lexer->char_pos = char_position;
   lexer->line     = line;
}

static void debug(wisi_lexer* lexer, int state, unsigned char ch)
{
   if (lexer->verbosity > 0)
      {
      if (ch < ' ')
         printf ("lexer: %d, 0x%x\n", state, ch);
      else
         printf ("lexer: %d, '%c' 0x%x\n", state, ch, ch);
      }
}
#define YYDEBUG(state, ch) debug(lexer, state, ch)
#define YYCURSOR lexer->cursor

#define YYPEEK() (lexer->cursor <= lexer->buffer_last) ? *lexer->cursor : 4

static void skip(wisi_lexer* lexer)
{
   if (lexer->cursor <= lexer->buffer_last)
   {
      ++lexer->cursor;
      if (lexer->cursor <= lexer->buffer_last)
      {
         /* UFT-8 encoding: https://en.wikipedia.org/wiki/UTF-8#Description */
         if (*lexer->cursor == 0x0A && lexer->cursor > lexer->buffer && *(lexer->cursor - 1) == 0x0D)
           {/* second byte of DOS line ending */
           }
         else if ((*lexer->cursor & 0x80) == 0x80 && (*lexer->cursor & 0xC0) != 0xC0)
           {/* byte 2, 3 or 4 of multi-byte UTF-8 char */
           }
         else
           lexer->char_pos++;
      } else 
         lexer->char_pos++;
   }
}
#define YYSKIP() skip(lexer)
#define YYBACKUP() lexer->marker = lexer->cursor; lexer->marker_pos = lexer->char_pos;lexer->marker_line = lexer->line
#define YYRESTORE() lexer->cursor = lexer->marker; lexer->char_pos = lexer->marker_pos;lexer->line = lexer->marker_line
#define YYBACKUPCTX() lexer->context = lexer->cursor; lexer->context_pos = lexer->char_pos;lexer->context_line = lexer->line
#define YYRESTORECTX() lexer->cursor = lexer->context; lexer->char_pos = lexer->context_pos;lexer->line = lexer->context_line

static void skip_to(wisi_lexer* lexer, char* target)
{
  int i, j;

  // Count all new-lines contained in the skip region. Caller has 
  // skipped the start delimiter; if lexer->cursor is a new-line it
  // has not yet been counted. Start and end delimiters do not contain new-line.
  while (lexer->cursor <= lexer->buffer_last)
    {
      if (*lexer->cursor == 0x0A)
      {
        lexer->line++;
      }
      if (*lexer->cursor == target[0])
      {
        i = 0;
        do
          i++;
        while (0 != target[i] &&
               lexer->cursor + i <= lexer->buffer_last &&
               *(lexer->cursor + i) == target[i]);

        if (0 == target[i])
          {
            for (j = 0; j < i; j++)
               skip(lexer);
            break;
          }
      }
      skip(lexer);
    };
}

int wisitoken_grammar_next_token
  (wisi_lexer* lexer,
   int* id,
   size_t* byte_position,
   size_t* byte_length,
   size_t* char_position,
   size_t* char_length,
   int*    line_start,
   int*    line_length)
{
   int status = NO_ERROR;
   *id = -1;
   if (lexer->cursor > lexer->buffer_last)
   {
      *id            = 42;
      *byte_position = lexer->buffer_last - lexer->buffer + 2;
      *byte_length   = 0;
      *char_position = lexer->char_pos;
      *char_length   = 0;
      *line_start    = lexer->line;
      *line_length   = 0;
      return status;
   }

   lexer->byte_token_start = lexer->cursor;
   lexer->char_token_start = lexer->char_pos;
   lexer->line_token_start = lexer->line;

   while (*id == -1 && status == 0)
   {

#line 207 "../wisitoken_grammar_re2c.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	YYDEBUG(0, YYPEEK());
	yych = YYPEEK();
	switch (yych) {
		case 0x04: goto yy3;
		case '\t':
		case ' ': goto yy4;
		case '\n': goto yy5;
		case '\r': goto yy6;
		case '"': goto yy7;
		case '%': goto yy8;
		case '\'': goto yy10;
		case '(': goto yy11;
		case ')': goto yy12;
		case '*': goto yy13;
		case '+': goto yy14;
		case '-': goto yy15;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy17;
		case ':': goto yy19;
		case ';': goto yy21;
		case '<': goto yy23;
		case '=': goto yy24;
		case '>': goto yy25;
		case '?': goto yy26;
		case 'A':
		case 'a': goto yy27;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'b':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy29;
		case 'R':
		case 'r': goto yy31;
		case 'S':
		case 's': goto yy32;
		case '[': goto yy33;
		case ']': goto yy34;
		case 'c': goto yy35;
		case 'e': goto yy36;
		case 'i': goto yy37;
		case 'k': goto yy38;
		case 'n': goto yy39;
		case 'o': goto yy40;
		case 't': goto yy41;
		case '{': goto yy42;
		case '|': goto yy43;
		case '}': goto yy44;
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF: goto yy45;
		case 0xE0: goto yy46;
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF: goto yy47;
		case 0xF0: goto yy48;
		case 0xF1:
		case 0xF2:
		case 0xF3: goto yy49;
		case 0xF4: goto yy50;
		default: goto yy1;
	}
yy1:
	YYDEBUG(1, YYPEEK());
	YYSKIP();
yy2:
	YYDEBUG(2, YYPEEK());
#line 296 "../wisitoken_grammar.re2c"
	{status = ERROR_unrecognized_character; continue;}
#line 360 "../wisitoken_grammar_re2c.c"
yy3:
	YYDEBUG(3, YYPEEK());
	YYSKIP();
#line 294 "../wisitoken_grammar.re2c"
	{*id = 42; continue;}
#line 366 "../wisitoken_grammar_re2c.c"
yy4:
	YYDEBUG(4, YYPEEK());
	YYSKIP();
#line 249 "../wisitoken_grammar.re2c"
	{ lexer->byte_token_start = lexer->cursor;
          lexer->char_token_start = lexer->char_pos;
          lexer->line_token_start = lexer->line;
          continue; }
#line 375 "../wisitoken_grammar_re2c.c"
yy5:
	YYDEBUG(5, YYPEEK());
	YYSKIP();
#line 253 "../wisitoken_grammar.re2c"
	{*id = 1; lexer->line++; continue;}
#line 381 "../wisitoken_grammar_re2c.c"
yy6:
	YYDEBUG(6, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case '\n': goto yy5;
		default: goto yy2;
	}
yy7:
	YYDEBUG(7, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case ';':
		case '<':
		case '=':
		case '>':
		case '?':
		case '@':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '[':
		case '\\':
		case ']':
		case '^':
		case '_':
		case '`':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case '{':
		case '|':
		case '}':
		case '~':
		case 0x7F:
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy52;
		default: goto yy2;
	}
yy8:
	YYDEBUG(8, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case '(': goto yy62;
		case '[': goto yy63;
		case '{': goto yy64;
		default: goto yy9;
	}
yy9:
	YYDEBUG(9, YYPEEK());
#line 282 "../wisitoken_grammar.re2c"
	{*id = 30; continue;}
#line 560 "../wisitoken_grammar_re2c.c"
yy10:
	YYDEBUG(10, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case ';':
		case '<':
		case '=':
		case '>':
		case '?':
		case '@':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '[':
		case '\\':
		case ']':
		case '^':
		case '_':
		case '`':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case '{':
		case '|':
		case '}':
		case '~':
		case 0x7F:
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy66;
		default: goto yy2;
	}
yy11:
	YYDEBUG(11, YYPEEK());
	YYSKIP();
#line 279 "../wisitoken_grammar.re2c"
	{*id = 27; continue;}
#line 722 "../wisitoken_grammar_re2c.c"
yy12:
	YYDEBUG(12, YYPEEK());
	YYSKIP();
#line 287 "../wisitoken_grammar.re2c"
	{*id = 35; continue;}
#line 728 "../wisitoken_grammar_re2c.c"
yy13:
	YYDEBUG(13, YYPEEK());
	YYSKIP();
#line 289 "../wisitoken_grammar.re2c"
	{*id = 37; continue;}
#line 734 "../wisitoken_grammar_re2c.c"
yy14:
	YYDEBUG(14, YYPEEK());
	YYSKIP();
#line 283 "../wisitoken_grammar.re2c"
	{*id = 31; continue;}
#line 740 "../wisitoken_grammar_re2c.c"
yy15:
	YYDEBUG(15, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case '_': goto yy17;
		default: goto yy16;
	}
yy16:
	YYDEBUG(16, YYPEEK());
#line 281 "../wisitoken_grammar.re2c"
	{*id = 29; continue;}
#line 763 "../wisitoken_grammar_re2c.c"
yy17:
	YYDEBUG(17, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case '_': goto yy17;
		default: goto yy18;
	}
yy18:
	YYDEBUG(18, YYPEEK());
#line 290 "../wisitoken_grammar.re2c"
	{*id = 38; continue;}
#line 786 "../wisitoken_grammar_re2c.c"
yy19:
	YYDEBUG(19, YYPEEK());
	yyaccept = 1;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case ':': goto yy75;
		default: goto yy20;
	}
yy20:
	YYDEBUG(20, YYPEEK());
#line 273 "../wisitoken_grammar.re2c"
	{*id = 21; continue;}
#line 801 "../wisitoken_grammar_re2c.c"
yy21:
	YYDEBUG(21, YYPEEK());
	yyaccept = 2;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case ';': goto yy76;
		default: goto yy22;
	}
yy22:
	YYDEBUG(22, YYPEEK());
#line 288 "../wisitoken_grammar.re2c"
	{*id = 36; continue;}
#line 816 "../wisitoken_grammar_re2c.c"
yy23:
	YYDEBUG(23, YYPEEK());
	YYSKIP();
#line 280 "../wisitoken_grammar.re2c"
	{*id = 28; continue;}
#line 822 "../wisitoken_grammar_re2c.c"
yy24:
	YYDEBUG(24, YYPEEK());
	YYSKIP();
#line 275 "../wisitoken_grammar.re2c"
	{*id = 23; continue;}
#line 828 "../wisitoken_grammar_re2c.c"
yy25:
	YYDEBUG(25, YYPEEK());
	YYSKIP();
#line 276 "../wisitoken_grammar.re2c"
	{*id = 24; continue;}
#line 834 "../wisitoken_grammar_re2c.c"
yy26:
	YYDEBUG(26, YYPEEK());
	YYSKIP();
#line 284 "../wisitoken_grammar.re2c"
	{*id = 32; continue;}
#line 840 "../wisitoken_grammar_re2c.c"
yy27:
	YYDEBUG(27, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'C':
		case 'c': goto yy77;
		default: goto yy30;
	}
yy28:
	YYDEBUG(28, YYPEEK());
#line 291 "../wisitoken_grammar.re2c"
	{*id = 39; continue;}
#line 856 "../wisitoken_grammar_re2c.c"
yy29:
	YYDEBUG(29, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
yy30:
	YYDEBUG(30, YYPEEK());
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy29;
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF: goto yy78;
		case 0xE0: goto yy79;
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF: goto yy80;
		case 0xF0: goto yy81;
		case 0xF1:
		case 0xF2:
		case 0xF3: goto yy82;
		case 0xF4: goto yy83;
		default: goto yy28;
	}
yy31:
	YYDEBUG(31, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'E':
		case 'e': goto yy84;
		default: goto yy30;
	}
yy32:
	YYDEBUG(32, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'H':
		case 'h': goto yy85;
		default: goto yy30;
	}
yy33:
	YYDEBUG(33, YYPEEK());
	YYSKIP();
#line 278 "../wisitoken_grammar.re2c"
	{*id = 26; continue;}
#line 1010 "../wisitoken_grammar_re2c.c"
yy34:
	YYDEBUG(34, YYPEEK());
	YYSKIP();
#line 286 "../wisitoken_grammar.re2c"
	{*id = 34; continue;}
#line 1016 "../wisitoken_grammar_re2c.c"
yy35:
	YYDEBUG(35, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'o': goto yy86;
		default: goto yy30;
	}
yy36:
	YYDEBUG(36, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'l': goto yy87;
		case 'n': goto yy88;
		default: goto yy30;
	}
yy37:
	YYDEBUG(37, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'f': goto yy89;
		case 'n': goto yy91;
		default: goto yy30;
	}
yy38:
	YYDEBUG(38, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'e': goto yy93;
		default: goto yy30;
	}
yy39:
	YYDEBUG(39, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'o': goto yy94;
		default: goto yy30;
	}
yy40:
	YYDEBUG(40, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'n': goto yy95;
		default: goto yy30;
	}
yy41:
	YYDEBUG(41, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'o': goto yy97;
		default: goto yy30;
	}
yy42:
	YYDEBUG(42, YYPEEK());
	YYSKIP();
#line 277 "../wisitoken_grammar.re2c"
	{*id = 25; continue;}
#line 1094 "../wisitoken_grammar_re2c.c"
yy43:
	YYDEBUG(43, YYPEEK());
	YYSKIP();
#line 272 "../wisitoken_grammar.re2c"
	{*id = 20; continue;}
#line 1100 "../wisitoken_grammar_re2c.c"
yy44:
	YYDEBUG(44, YYPEEK());
	YYSKIP();
#line 285 "../wisitoken_grammar.re2c"
	{*id = 33; continue;}
#line 1106 "../wisitoken_grammar_re2c.c"
yy45:
	YYDEBUG(45, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy29;
		default: goto yy2;
	}
yy46:
	YYDEBUG(46, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy78;
		default: goto yy2;
	}
yy47:
	YYDEBUG(47, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy78;
		default: goto yy2;
	}
yy48:
	YYDEBUG(48, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy80;
		default: goto yy2;
	}
yy49:
	YYDEBUG(49, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy80;
		default: goto yy2;
	}
yy50:
	YYDEBUG(50, YYPEEK());
	yyaccept = 0;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F: goto yy80;
		default: goto yy2;
	}
yy51:
	YYDEBUG(51, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
yy52:
	YYDEBUG(52, YYPEEK());
	switch (yych) {
		case ' ':
		case '!':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case ';':
		case '<':
		case '=':
		case '>':
		case '?':
		case '@':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '[':
		case '\\':
		case ']':
		case '^':
		case '_':
		case '`':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case '{':
		case '|':
		case '}':
		case '~':
		case 0x7F: goto yy51;
		case '"': goto yy54;
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF: goto yy56;
		case 0xE0: goto yy57;
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF: goto yy58;
		case 0xF0: goto yy59;
		case 0xF1:
		case 0xF2:
		case 0xF3: goto yy60;
		case 0xF4: goto yy61;
		default: goto yy53;
	}
yy53:
	YYDEBUG(53, YYPEEK());
	YYRESTORE();
	switch (yyaccept) {
		case 0: goto yy2;
		case 1: goto yy20;
		case 2: goto yy22;
		case 3: goto yy28;
		case 4: goto yy55;
		case 5: goto yy68;
		case 6: goto yy90;
		case 7: goto yy92;
		case 8: goto yy96;
		case 9: goto yy113;
		case 10: goto yy121;
		case 11: goto yy130;
		case 12: goto yy133;
		case 13: goto yy137;
		case 14: goto yy140;
		case 15: goto yy147;
		case 16: goto yy151;
		case 17: goto yy154;
		case 18: goto yy161;
		default: goto yy170;
	}
yy54:
	YYDEBUG(54, YYPEEK());
	yyaccept = 4;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '"': goto yy51;
		default: goto yy55;
	}
yy55:
	YYDEBUG(55, YYPEEK());
#line 292 "../wisitoken_grammar.re2c"
	{*id = 40; continue;}
#line 1642 "../wisitoken_grammar_re2c.c"
yy56:
	YYDEBUG(56, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy51;
		default: goto yy53;
	}
yy57:
	YYDEBUG(57, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy56;
		default: goto yy53;
	}
yy58:
	YYDEBUG(58, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy56;
		default: goto yy53;
	}
yy59:
	YYDEBUG(59, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy58;
		default: goto yy53;
	}
yy60:
	YYDEBUG(60, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy58;
		default: goto yy53;
	}
yy61:
	YYDEBUG(61, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F: goto yy58;
		default: goto yy53;
	}
yy62:
	YYDEBUG(62, YYPEEK());
	YYSKIP();
#line 271 "../wisitoken_grammar.re2c"
	{*id = 19; skip_to(lexer, ")%"); continue;}
#line 1978 "../wisitoken_grammar_re2c.c"
yy63:
	YYDEBUG(63, YYPEEK());
	YYSKIP();
#line 270 "../wisitoken_grammar.re2c"
	{*id = 18; skip_to(lexer, "]%"); continue;}
#line 1984 "../wisitoken_grammar_re2c.c"
yy64:
	YYDEBUG(64, YYPEEK());
	YYSKIP();
#line 269 "../wisitoken_grammar.re2c"
	{*id = 17; skip_to(lexer, "}%"); continue;}
#line 1990 "../wisitoken_grammar_re2c.c"
yy65:
	YYDEBUG(65, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
yy66:
	YYDEBUG(66, YYPEEK());
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case ';':
		case '<':
		case '=':
		case '>':
		case '?':
		case '@':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '[':
		case '\\':
		case ']':
		case '^':
		case '_':
		case '`':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case '{':
		case '|':
		case '}':
		case '~':
		case 0x7F: goto yy65;
		case '\'': goto yy67;
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF: goto yy69;
		case 0xE0: goto yy70;
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF: goto yy71;
		case 0xF0: goto yy72;
		case 0xF1:
		case 0xF2:
		case 0xF3: goto yy73;
		case 0xF4: goto yy74;
		default: goto yy53;
	}
yy67:
	YYDEBUG(67, YYPEEK());
	yyaccept = 5;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '\'': goto yy65;
		default: goto yy68;
	}
yy68:
	YYDEBUG(68, YYPEEK());
#line 293 "../wisitoken_grammar.re2c"
	{*id = 41; continue;}
#line 2161 "../wisitoken_grammar_re2c.c"
yy69:
	YYDEBUG(69, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy65;
		default: goto yy53;
	}
yy70:
	YYDEBUG(70, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy69;
		default: goto yy53;
	}
yy71:
	YYDEBUG(71, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy69;
		default: goto yy53;
	}
yy72:
	YYDEBUG(72, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy71;
		default: goto yy53;
	}
yy73:
	YYDEBUG(73, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy71;
		default: goto yy53;
	}
yy74:
	YYDEBUG(74, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F: goto yy71;
		default: goto yy53;
	}
yy75:
	YYDEBUG(75, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case '=': goto yy98;
		default: goto yy53;
	}
yy76:
	YYDEBUG(76, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case ';':
		case '<':
		case '=':
		case '>':
		case '?':
		case '@':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '[':
		case '\\':
		case ']':
		case '^':
		case '_':
		case '`':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case '{':
		case '|':
		case '}':
		case '~':
		case 0x7F: goto yy76;
		case 0x04:
		case '\n': goto yy99;
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF: goto yy100;
		case 0xE0: goto yy101;
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF: goto yy102;
		case 0xF0: goto yy103;
		case 0xF1:
		case 0xF2:
		case 0xF3: goto yy104;
		case 0xF4: goto yy105;
		default: goto yy53;
	}
yy77:
	YYDEBUG(77, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'C':
		case 'c': goto yy106;
		default: goto yy30;
	}
yy78:
	YYDEBUG(78, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy29;
		default: goto yy53;
	}
yy79:
	YYDEBUG(79, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy78;
		default: goto yy53;
	}
yy80:
	YYDEBUG(80, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy78;
		default: goto yy53;
	}
yy81:
	YYDEBUG(81, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy80;
		default: goto yy53;
	}
yy82:
	YYDEBUG(82, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy80;
		default: goto yy53;
	}
yy83:
	YYDEBUG(83, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F: goto yy80;
		default: goto yy53;
	}
yy84:
	YYDEBUG(84, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'D':
		case 'd': goto yy107;
		default: goto yy30;
	}
yy85:
	YYDEBUG(85, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'I':
		case 'i': goto yy108;
		default: goto yy30;
	}
yy86:
	YYDEBUG(86, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'd': goto yy109;
		case 'n': goto yy110;
		default: goto yy30;
	}
yy87:
	YYDEBUG(87, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 's': goto yy111;
		default: goto yy30;
	}
yy88:
	YYDEBUG(88, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'd': goto yy112;
		default: goto yy30;
	}
yy89:
	YYDEBUG(89, YYPEEK());
	yyaccept = 6;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy90;
	}
yy90:
	YYDEBUG(90, YYPEEK());
#line 261 "../wisitoken_grammar.re2c"
	{*id = 9; continue;}
#line 3208 "../wisitoken_grammar_re2c.c"
yy91:
	YYDEBUG(91, YYPEEK());
	yyaccept = 7;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy92;
	}
yy92:
	YYDEBUG(92, YYPEEK());
#line 262 "../wisitoken_grammar.re2c"
	{*id = 10; continue;}
#line 3337 "../wisitoken_grammar_re2c.c"
yy93:
	YYDEBUG(93, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'y': goto yy114;
		default: goto yy30;
	}
yy94:
	YYDEBUG(94, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'n': goto yy115;
		default: goto yy30;
	}
yy95:
	YYDEBUG(95, YYPEEK());
	yyaccept = 8;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy96;
	}
yy96:
	YYDEBUG(96, YYPEEK());
#line 265 "../wisitoken_grammar.re2c"
	{*id = 13; continue;}
#line 3486 "../wisitoken_grammar_re2c.c"
yy97:
	YYDEBUG(97, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'k': goto yy116;
		default: goto yy30;
	}
yy98:
	YYDEBUG(98, YYPEEK());
	YYSKIP();
#line 274 "../wisitoken_grammar.re2c"
	{*id = 22; continue;}
#line 3502 "../wisitoken_grammar_re2c.c"
yy99:
	YYDEBUG(99, YYPEEK());
	YYSKIP();
#line 254 "../wisitoken_grammar.re2c"
	{*id = 2; if (lexer->cursor[-1] == 0x0a || (lexer->cursor[-1] == 0x0d && lexer->cursor[-2] == 0x0a)) lexer->line++; continue;}
#line 3508 "../wisitoken_grammar_re2c.c"
yy100:
	YYDEBUG(100, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy76;
		default: goto yy53;
	}
yy101:
	YYDEBUG(101, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy100;
		default: goto yy53;
	}
yy102:
	YYDEBUG(102, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy100;
		default: goto yy53;
	}
yy103:
	YYDEBUG(103, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy102;
		default: goto yy53;
	}
yy104:
	YYDEBUG(104, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F:
		case 0x90:
		case 0x91:
		case 0x92:
		case 0x93:
		case 0x94:
		case 0x95:
		case 0x96:
		case 0x97:
		case 0x98:
		case 0x99:
		case 0x9A:
		case 0x9B:
		case 0x9C:
		case 0x9D:
		case 0x9E:
		case 0x9F:
		case 0xA0:
		case 0xA1:
		case 0xA2:
		case 0xA3:
		case 0xA4:
		case 0xA5:
		case 0xA6:
		case 0xA7:
		case 0xA8:
		case 0xA9:
		case 0xAA:
		case 0xAB:
		case 0xAC:
		case 0xAD:
		case 0xAE:
		case 0xAF:
		case 0xB0:
		case 0xB1:
		case 0xB2:
		case 0xB3:
		case 0xB4:
		case 0xB5:
		case 0xB6:
		case 0xB7:
		case 0xB8:
		case 0xB9:
		case 0xBA:
		case 0xBB:
		case 0xBC:
		case 0xBD:
		case 0xBE:
		case 0xBF: goto yy102;
		default: goto yy53;
	}
yy105:
	YYDEBUG(105, YYPEEK());
	YYSKIP();
	yych = YYPEEK();
	switch (yych) {
		case 0x80:
		case 0x81:
		case 0x82:
		case 0x83:
		case 0x84:
		case 0x85:
		case 0x86:
		case 0x87:
		case 0x88:
		case 0x89:
		case 0x8A:
		case 0x8B:
		case 0x8C:
		case 0x8D:
		case 0x8E:
		case 0x8F: goto yy102;
		default: goto yy53;
	}
yy106:
	YYDEBUG(106, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'E':
		case 'e': goto yy117;
		default: goto yy30;
	}
yy107:
	YYDEBUG(107, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'U':
		case 'u': goto yy118;
		default: goto yy30;
	}
yy108:
	YYDEBUG(108, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'F':
		case 'f': goto yy119;
		default: goto yy30;
	}
yy109:
	YYDEBUG(109, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'e': goto yy120;
		default: goto yy30;
	}
yy110:
	YYDEBUG(110, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'f': goto yy122;
		default: goto yy30;
	}
yy111:
	YYDEBUG(111, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'i': goto yy123;
		default: goto yy30;
	}
yy112:
	YYDEBUG(112, YYPEEK());
	yyaccept = 9;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy113;
	}
yy113:
	YYDEBUG(113, YYPEEK());
#line 259 "../wisitoken_grammar.re2c"
	{*id = 7; continue;}
#line 4030 "../wisitoken_grammar_re2c.c"
yy114:
	YYDEBUG(114, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'w': goto yy124;
		default: goto yy30;
	}
yy115:
	YYDEBUG(115, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '_': goto yy125;
		default: goto yy30;
	}
yy116:
	YYDEBUG(116, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'e': goto yy126;
		default: goto yy30;
	}
yy117:
	YYDEBUG(117, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'P':
		case 'p': goto yy127;
		default: goto yy30;
	}
yy118:
	YYDEBUG(118, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'C':
		case 'c': goto yy128;
		default: goto yy30;
	}
yy119:
	YYDEBUG(119, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'T':
		case 't': goto yy129;
		default: goto yy30;
	}
yy120:
	YYDEBUG(120, YYPEEK());
	yyaccept = 10;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy121;
	}
yy121:
	YYDEBUG(121, YYPEEK());
#line 256 "../wisitoken_grammar.re2c"
	{*id = 4; continue;}
#line 4222 "../wisitoken_grammar_re2c.c"
yy122:
	YYDEBUG(122, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'l': goto yy131;
		default: goto yy30;
	}
yy123:
	YYDEBUG(123, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'f': goto yy132;
		default: goto yy30;
	}
yy124:
	YYDEBUG(124, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'o': goto yy134;
		default: goto yy30;
	}
yy125:
	YYDEBUG(125, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'g': goto yy135;
		default: goto yy30;
	}
yy126:
	YYDEBUG(126, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'n': goto yy136;
		default: goto yy30;
	}
yy127:
	YYDEBUG(127, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'T':
		case 't': goto yy138;
		default: goto yy30;
	}
yy128:
	YYDEBUG(128, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'E':
		case 'e': goto yy139;
		default: goto yy30;
	}
yy129:
	YYDEBUG(129, YYPEEK());
	yyaccept = 11;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy130;
	}
yy130:
	YYDEBUG(130, YYPEEK());
#line 267 "../wisitoken_grammar.re2c"
	{*id = 15; continue;}
#line 4423 "../wisitoken_grammar_re2c.c"
yy131:
	YYDEBUG(131, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'i': goto yy141;
		default: goto yy30;
	}
yy132:
	YYDEBUG(132, YYPEEK());
	yyaccept = 12;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy133;
	}
yy133:
	YYDEBUG(133, YYPEEK());
#line 260 "../wisitoken_grammar.re2c"
	{*id = 8; continue;}
#line 4562 "../wisitoken_grammar_re2c.c"
yy134:
	YYDEBUG(134, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'r': goto yy142;
		default: goto yy30;
	}
yy135:
	YYDEBUG(135, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'r': goto yy143;
		default: goto yy30;
	}
yy136:
	YYDEBUG(136, YYPEEK());
	yyaccept = 13;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy137;
	}
yy137:
	YYDEBUG(137, YYPEEK());
#line 268 "../wisitoken_grammar.re2c"
	{*id = 16; continue;}
#line 4711 "../wisitoken_grammar_re2c.c"
yy138:
	YYDEBUG(138, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '_': goto yy144;
		default: goto yy30;
	}
yy139:
	YYDEBUG(139, YYPEEK());
	yyaccept = 14;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy140;
	}
yy140:
	YYDEBUG(140, YYPEEK());
#line 266 "../wisitoken_grammar.re2c"
	{*id = 14; continue;}
#line 4850 "../wisitoken_grammar_re2c.c"
yy141:
	YYDEBUG(141, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'c': goto yy145;
		default: goto yy30;
	}
yy142:
	YYDEBUG(142, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'd': goto yy146;
		default: goto yy30;
	}
yy143:
	YYDEBUG(143, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'a': goto yy148;
		default: goto yy30;
	}
yy144:
	YYDEBUG(144, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'I':
		case 'i': goto yy149;
		default: goto yy30;
	}
yy145:
	YYDEBUG(145, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 't': goto yy150;
		default: goto yy30;
	}
yy146:
	YYDEBUG(146, YYPEEK());
	yyaccept = 15;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy147;
	}
yy147:
	YYDEBUG(147, YYPEEK());
#line 263 "../wisitoken_grammar.re2c"
	{*id = 11; continue;}
#line 5030 "../wisitoken_grammar_re2c.c"
yy148:
	YYDEBUG(148, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'm': goto yy152;
		default: goto yy30;
	}
yy149:
	YYDEBUG(149, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'T':
		case 't': goto yy153;
		default: goto yy30;
	}
yy150:
	YYDEBUG(150, YYPEEK());
	yyaccept = 16;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		case '_': goto yy155;
		default: goto yy151;
	}
yy151:
	YYDEBUG(151, YYPEEK());
#line 257 "../wisitoken_grammar.re2c"
	{*id = 5; continue;}
#line 5180 "../wisitoken_grammar_re2c.c"
yy152:
	YYDEBUG(152, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'm': goto yy156;
		default: goto yy30;
	}
yy153:
	YYDEBUG(153, YYPEEK());
	yyaccept = 17;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy154;
	}
yy154:
	YYDEBUG(154, YYPEEK());
#line 255 "../wisitoken_grammar.re2c"
	{*id = 3; continue;}
#line 5319 "../wisitoken_grammar_re2c.c"
yy155:
	YYDEBUG(155, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'r': goto yy157;
		default: goto yy30;
	}
yy156:
	YYDEBUG(156, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'a': goto yy158;
		default: goto yy30;
	}
yy157:
	YYDEBUG(157, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'e': goto yy159;
		default: goto yy30;
	}
yy158:
	YYDEBUG(158, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'r': goto yy160;
		default: goto yy30;
	}
yy159:
	YYDEBUG(159, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 's': goto yy162;
		default: goto yy30;
	}
yy160:
	YYDEBUG(160, YYPEEK());
	yyaccept = 18;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy161;
	}
yy161:
	YYDEBUG(161, YYPEEK());
#line 264 "../wisitoken_grammar.re2c"
	{*id = 12; continue;}
#line 5498 "../wisitoken_grammar_re2c.c"
yy162:
	YYDEBUG(162, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'o': goto yy163;
		default: goto yy30;
	}
yy163:
	YYDEBUG(163, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'l': goto yy164;
		default: goto yy30;
	}
yy164:
	YYDEBUG(164, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'u': goto yy165;
		default: goto yy30;
	}
yy165:
	YYDEBUG(165, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 't': goto yy166;
		default: goto yy30;
	}
yy166:
	YYDEBUG(166, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'i': goto yy167;
		default: goto yy30;
	}
yy167:
	YYDEBUG(167, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'o': goto yy168;
		default: goto yy30;
	}
yy168:
	YYDEBUG(168, YYPEEK());
	yyaccept = 3;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case 'n': goto yy169;
		default: goto yy30;
	}
yy169:
	YYDEBUG(169, YYPEEK());
	yyaccept = 19;
	YYSKIP();
	YYBACKUP();
	yych = YYPEEK();
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
		case 0xC2:
		case 0xC3:
		case 0xC4:
		case 0xC5:
		case 0xC6:
		case 0xC7:
		case 0xC8:
		case 0xC9:
		case 0xCA:
		case 0xCB:
		case 0xCC:
		case 0xCD:
		case 0xCE:
		case 0xCF:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD4:
		case 0xD5:
		case 0xD6:
		case 0xD7:
		case 0xD8:
		case 0xD9:
		case 0xDA:
		case 0xDB:
		case 0xDC:
		case 0xDD:
		case 0xDE:
		case 0xDF:
		case 0xE0:
		case 0xE1:
		case 0xE2:
		case 0xE3:
		case 0xE4:
		case 0xE5:
		case 0xE6:
		case 0xE7:
		case 0xE8:
		case 0xE9:
		case 0xEA:
		case 0xEB:
		case 0xEC:
		case 0xED:
		case 0xEE:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xF2:
		case 0xF3:
		case 0xF4: goto yy30;
		default: goto yy170;
	}
yy170:
	YYDEBUG(170, YYPEEK());
#line 258 "../wisitoken_grammar.re2c"
	{*id = 6; continue;}
#line 5697 "../wisitoken_grammar_re2c.c"
}
#line 297 "../wisitoken_grammar.re2c"

   }
   /* lexer->cursor and lexer ->char_pos are one char past end of token */
   *byte_position = lexer->byte_token_start - lexer->buffer + 1;
   *byte_length   = lexer->cursor - lexer->byte_token_start;
   *char_position = lexer->char_token_start;
   *char_length   = lexer->char_pos - lexer->char_token_start;
   *line_start    = lexer->line_token_start;
   *line_length   = lexer->line - lexer->line_token_start;
   return status;
   }
