<?php
# Copy configuration (for group admins).
#
# Copyright (C) 1999, 2000 The SourceForge Crew
# Copyright (C) 2000-2006 Mathieu Roy <yeupou--gnu.org>
# Copyright (C) 2014, 2016, 2017 Assaf Gordon
# Copyright (C) 2001-2011, 2013, 2017 Sylvain Beucler
# Copyright (C) 2013, 2014, 2017-2023 Ineiev
#
# This file is part of Savane.
#
# Code written before 2008-03-30 (commit 8b757b2565ff) is distributed
# under the terms of the GNU General Public license version 3 or (at your
# option) any later version; further contributions are covered by
# the GNU Affero General Public license version 3 or (at your option)
# any later version.  The license notices for the AGPL and the GPL follow.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

require_once('../../include/init.php');
require_directory("trackers");

extract (sane_import ('post',
  [
    'true' => 'update',
    'digits' => 'from_group_id',
    'artifact' => 'artifact',
  ]
));

if (!$group_id)
  exit_no_group ();

if (!user_ismember ($group_id, 'A'))
  exit_permission_denied ();

if ($update && $from_group_id != 100)
  trackers_conf_copy ($group_id, $artifact, $from_group_id);

site_project_header (
  [
    'context' => 'ahome', 'group' => $group_id,
    'title' => _("Copy Configuration"),
  ]
);

$print_h2 = function ($x)
{
  print '<h2>' . $x . "</h2>\n";
};

$print_h2 (_("Support Tracker Configuration Copy"));
conf_form ($group_id, "support");
$print_h2 (_("Bug Tracker Configuration Copy"));
conf_form ($group_id, "bugs");
$print_h2 (_("Task Tracker Configuration Copy"));
conf_form ($group_id, "task");
$print_h2 (_("Patch Tracker Configuration Copy"));
conf_form ($group_id, "patch");

site_project_footer ([]);
?>
