<?php
# Enable and configure a group's available services
#
# Copyright (C) 1999, 2000 The SourceForge Crew
# Copyright (C) 2000-2006 Mathieu Roy <yeupou--gnu.org>
# Copyright (C) 2008 Aleix Conchillo Flaque
# Copyright (C) 2014, 2016, 2017 Assaf Gordon
# Copyright (C) 2001-2011, 2013, 2017 Sylvain Beucler
# Copyright (C) 2013, 2014, 2017-2024 Ineiev
#
# This file is part of Savane.
#
# Code written before 2008-03-30 (commit 8b757b2565ff) is distributed
# under the terms of the GNU General Public license version 3 or (at your
# option) any later version; further contributions are covered by
# the GNU Affero General Public license version 3 or (at your option)
# any later version.  The license notices for the AGPL and the GPL follow.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

require_once ('../../include/init.php');
require_once ('../../include/sane.php');
session_require (['group' => $group_id, 'admin_flags' => 'A']);

$post_names = function ()
{
  $vcs = ['cvs', 'arch', 'svn', 'git', 'hg', 'bzr'];
  $use_url = [
    'bugs', 'support', 'patch', 'task', 'mail', 'download', 'homepage',
    'forum', 'extralink_documentation',
  ];
  $use_ = array_merge ($vcs, $use_url, ['news']);
  $names = ['true' => ['update'], 'specialchars' => ['dir_download']];
  foreach ($use_ as $u)
    $names['true'][] = 'use_' . $u;
  $viewvcs = [];
  foreach ($vcs as $v)
    $viewvcs[] = $v . '_viewcvs';
  $urls = array_merge ($vcs, $viewvcs, $use_url);
  foreach ($urls as $u)
    $names['specialchars'][] = 'url_' . $u;
  $names['specialchars'][] = 'url_cvs_viewcvs_homepage';
  return $names;
};

$get_cases = function ($names)
{
  $n = $names['true'];
  unset ($n[0]);
  return array_merge ($n, $names['specialchars']);
};

function str_match ($needle, $haystack)
{
  return strpos ($haystack, $needle) !== false;
}

function field_usable ($group, $field, $field_name)
{
  if ($group->CanUse ($field_name))
    return true;
  if ($field_name == "extralink_documentation")
    return true;
  if ($field == "url_cvs_viewcvs_homepage" && $group->CanUse ("homepage"))
    return true;
  foreach (['cvs', 'arch', 'svn', 'git', 'hg', 'bzr'] as $vcs)
    if ($field == "url_{$vcs}_viewcvs" && $group->CanUse ($vcs))
      return true;
  return false;
}

function type_usable ($group, $type, $field_name, $field)
{
  if ($type == "use")
    return 1;
  if ($type == "url")
    return $group->CanModifyUrl ($field_name);
  return
    $type == "dir" && $field == "dir_download" && $group->CanUse ("download")
    && $group->CanModifyDir ("download_dir");
}

$names = $post_names ();
extract (sane_import ('post', $names));
form_check ('update');

$query = sane_import ('get',
  ['specialchars' => 'feedback', 'digits' => 'error']
);

if ($query['feedback'])
  fb ($query['feedback'], $query['error']);

$project = project_get_object ($group_id);
if ($update)
  {
    #FIXME: feeds the database with default values... instead of checkbox,
    # it should be select boxes "default/activated/deactivated".
    group_add_history ('Changed Activated Features', '', $group_id);
    # In the database, these all default to '1',
    # so we have to explicity set 0 (this is ugly).
    foreach (
      [
        'bugs', 'mail', 'homepage', 'download', 'patch', 'forum', 'task',
        'cvs', 'arch', 'svn', 'git', 'hg', 'bzr', 'news', 'support',
        'extralink_documentation'
      ] as $u
    )
      {
        $var = 'use_' . $u;
        if (!$$var)
          $$var = 0;
      }

    $cases = $get_cases ($names);
    $upd_list = [];

    foreach ($cases as $field)
      {
        $field_name = substr ($field, 4);
        if (!field_usable ($project, $field, $field_name))
          continue;
        $type = substr ($field, 0, 3);
        if (type_usable ($project, $type, $field_name, $field))
          $upd_list[$field] = $$field;
      }

    if ($upd_list)
      {
        $result = db_autoexecute (
         'groups', $upd_list, DB_AUTOQUERY_UPDATE, "group_id=?", [$group_id]
        );
        $error = intval(!$result);
        $fb = _("Update failed.");
        if ($result)
          $fb = _("Update successful.");
        $fb = rawurlencode ($fb);
        $fb = "&feedback=$fb&error=$error";
        session_redirect ("{$_SERVER['PHP_SELF']}?group=$group$fb");
      }
    else
      fb(_("Nothing to update."));
  }

site_project_header (
  ['title' => _("Select Features"),'group' => $group_id, 'context' => 'ahome']
);

$i = 0;

$next_td = function ($i)
{
  print ' <td class="' . utils_altrow ($i) . '">';
};
$close_td = function () { print "</td>\n"; };

function specific_line ($artifact, $explanation, $use, $increment=1)
{
  global $next_td, $close_td;
  # Just a little function to clean that part of the code, no
  # interest to generalize it.
  global $i, $project;
  if ($increment)
    $i++;
  print "<tr>\n";
  $next_td ($i);
  print html_label ("use_$artifact", $explanation) . "</td>\n";
  $next_td ($i);
  # Print the checkbox to de/activate it
  # (viewcvs cannot be activated or deactivated, they are not in the menu).
  if (str_match ("viewcvs", $artifact))
    print "---";
  else
    print form_checkbox ("use_$artifact", $use);
  $close_td ();
  # Print the default setting
  # (extralink_* does not have any default).
  $next_td ($i);
  if (!str_match ("extralink", $artifact))
    {
      $art_url = group_get_artifact_url ($artifact);
      print "<a href=\"$art_url\">$art_url</a>";
    }
  $close_td ();
  # If allowed from the group type, add a text field to put a non-standard
  # url (news cannot be activated and using a non-standard url, it would
  # broke the news system).
  $next_td ($i);

  $tail = "</td>\n</tr>\n";
  if (!$project->CanModifyUrl ($artifact))
    {
      print "---" . $tail;
      return;
    }
  if ($artifact == "homepage" || $artifact == "download"
      || str_match ("viewcvs", $artifact) || str_match ("extralink", $artifact))
    $url = $project->getUrl($artifact);
  else
    $url = $project->getArtifactUrl ($artifact);
  $url = utils_specialchars_decode ($url, ENT_QUOTES);
  $extra = 'size="20" title="' . _("Alternative Address") . '"';
  print form_input ("text", "url_$artifact", $url, $extra) . $tail;
}

print '<p>';
print
  _("You can activate or deactivate feature for your group. In some cases, "
    . "depending on the system administrator's choices, you can "
    . "even use change the URL for a feature. If the field "
    . "&ldquo;alternative address&rdquo; is empty, the standard is used.");
print "</p>\n";

print form_header () . form_hidden (["group_id" => $group_id]);

print html_build_list_table_top (
  [
    _("Feature, Artifact"), _("Activated"),
    _("Standard Address"), _("Alternative Address")
  ]
);

if ($project->CanUse ("homepage"))
  {
    specific_line ("homepage", _("Homepage"), $project->Uses("homepage"));
    specific_line ("cvs_viewcvs_homepage",
      _("Homepage Source Code Web Browsing"), 0, 0
    );
  }

if ($project->CanModifyUrl ("extralink_documentation"))
  specific_line ("extralink_documentation", _("Documentation"),
    $project->Uses("extralink_documentation")
  );

function specific_can_use ($project, $artifact, $explanation)
{
  if ($project->CanUse ($artifact))
    specific_line ($artifact, $explanation, $project->Uses ($artifact));
}
specific_can_use ($project, "download", _("Download Area"));

if ($project->CanUse ("download") && $project->CanModifyDir("download_dir"))
  {
    $i++; print '<tr>';
    $next_td ($i);
    print _("Download Area Directory");
    $close_td ();
    $next_td ($i);
    print "---";
    $close_td ();
    $next_td ($i);
    print $project->getTypeDir("download");
    $close_td ();
    $next_td ($i);
    print ' '
      . form_input (
          "text", "dir_download", $project->getDir ("download"), 'size="20"'
        );
    print "</td>\n</tr>\n";
  }

if ($project->CanUse ("cvs") || $project->CanUse ("homepage"))
  {
    specific_line ("cvs", _("CVS"), $project->Uses ("cvs"));
    specific_line ("cvs_viewcvs", _("CVS Web Browsing"), 0, 0);
  }
foreach (
  [
    'arch' => [_("GNU Arch"), _("Arch Web Browsing")],
    'svn' => [_("Subversion"), _("Subversion Web Browsing")],
    'git' => [_("Git"), _("Git Web Browsing")],
    'hg' => [_("Mercurial"), _("Mercurial Web Browsing")],
    'bzr' => [_("Bazaar"), _("Bazaar Web Browsing")]
  ] as $vcs => $labels
)
  if ($project->CanUse ($vcs))
    {
      specific_line ($vcs, $labels[0], $project->Uses ($vcs));
      specific_line ("{$vcs}_viewcvs", $labels[1], 0, 0);
    }

foreach (
  [
    "mail" => _("Mailing Lists"), "forum" => _("Forum"), "news" => _("News"),
    "support" => _("Support Tracker"), "bugs" => _("Bug Tracker"),
    "task" => _("Task Tracker"), "patch" => _("Patch Tracker"),
  ] as $k => $v
)
  specific_can_use ($project, $k, $v);

print "</table>\n";
print form_footer ();
site_project_footer ();
?>
