<?php
# Markup reminder and test.
#
# Copyright (C) 1999, 2000 The SourceForge Crew
# Copyright (C) 2000-2006 Mathieu Roy
# Copyright (C) 2014, 2016, 2017 Assaf Gordon
# Copyright (C) 2001-2011, 2013, 2017 Sylvain Beucler
# Copyright (C) 2013, 2014, 2017-2024 Ineiev
#
# This file is part of Savane.
#
# Code written before 2008-03-30 (commit 8b757b2565ff) is distributed
# under the terms of the GNU General Public license version 3 or (at your
# option) any later version; further contributions are covered by
# the GNU Affero General Public license version 3 or (at your option)
# any later version.  The license notices for the AGPL and the GPL follow.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
require_once('include/init.php');
require_once('include/markup.php');
require_once('include/trackers/general.php');

$submit_buttons = ['basic', 'rich', 'full'];
extract (sane_import ('post',
  ['specialchars' => 'comment', 'true' => $submit_buttons]
));
$text = $comment;
# The request doesn't commit any changes in the database, so we could
# use GET rather than POST, without checking form_id; however,
# the user may submit a longer text than GET can pass.
form_check ($submit_buttons);

$HTML->header (['title' => _("Test Markup"), 'notopmenu' => 1]);
html_feedback_top ();

print markup_full ("= " . _('Markup Reminder and Test') . " =\n");
print "<p>"
. _('This page describes Savane markup language for formatting text you post
in items or item comments. You can <a href="#test">test it below</a>.')
. "</p>\n";

print markup_full (markup_get_reminder ());

print '<h3 id="test">' . _('Test Markup') . "</h3>\n";
print form_header (
  "$php_self#test", "post", 'enctype="multipart/form-data" name="test_form"'
);

print trackers_field_textarea('comment', $text, 0, 0, _("Text to test"));
$GLOBALS['int_trapisset'] = true;
print '<div class="noprint">'
  . form_submit (_("Basic Markup"), "basic", 'class="bold"')
  . form_submit (_("Rich Markup"), "rich", 'class="bold"')
  . form_submit (_("Full Markup"), "full", 'class="bold"')
  . "</div>\n</form>\n";

if (!$comment)
  {
    $HTML->footer ([]);
    exit;
  }
$comment_number = 0;
if ($rich)
  {
    print '<table cellpadding="0" width="100%">' . "\n";
    print '<tr class="boxlight"><td valign="top">';
    print '<a id="comment' . $comment_number . '" href="#comment'
      . $comment_number . '" class="preinput">';
    print utils_format_date(time ()) . ', '
      . sprintf(_("comment #%s:"), $comment_number) . "</a><br />\n";
    print '<div class="tracker_comment">' . "\n";
  }
if ($full)
  print markup_full ($text);
elseif ($rich)
  print markup_rich ($text);
else
  print markup_basic ($text);
if ($rich)
  {
    print "</div>\n</td>\n";
    print '<td class="boxlightextra">'
      . utils_user_link (user_getname (), user_getrealname ());
    print "</td>\n</tr>\n";
    print "</table>\n";
  }
$HTML->footer ([]);
?>
