package AFP::PowerTools::Objects;

use warnings;
use strict;
use AFP::PowerTools;
use AFP::PowerTools::Parser;
use AFP::PowerTools::Generator;
use Exporter 'import';
our @EXPORT = qw(make_object object2AFP add_structs_to_object make_PTX $cc_encoders make_control_codes_pt_object);  
our ($cc_encoders);


sub make_object {
	my ($object_type, $parameters, $structs)  = @_;
	my $object = [];
	ITEM: for (@{$grammar->{object}->{$object_type}}){
		$_ =~ /([^\$\*\?]*)([\$\*\?])?/; 
		my ($name, $quantifier) = ($1, $2);
		if ($structs && $structs->[0] &&  ($structs->[0]->{id} eq $sf_acronym2id{$name})){
			push @{$object}, shift @{$structs};
			if (! $quantifier || ($quantifier eq "?")){ next ITEM }
			if ($quantifier eq "*"){ redo ITEM }
		}
		if ( ! $quantifier || ($quantifier eq "+")){
			if ($grammar->{object}->{$name}){ # if ITEM is itself an object inside the object
				push @{$object}, @{ make_object($name) };
			} else {
				push @{$object}, make_struct("structured_field", $sf_acronym2id{$name}, $parameters);
			}
		}
		if ($quantifier){
			push @{$object}, $_;
		}
	}
	return $object; 
}

sub object2AFP {
	my $object = shift;
	my $bytestring = "";
	for (@{$object}){
		if (ref $_){ $bytestring .= struct2AFP($_); }
	}
	return $bytestring;
}


sub add_structs_to_object {
	# todo: write a variant whereby the object is placed where there is the object name
	my ($container, $structs, $condition) = @_;
	my $p = AFP::PowerTools::Parser->new();
	$p->set_rule($condition, sub {splice @{$container}, $p->{array_offset} +1 , 0, @{$structs}; $p->{array_offset} += $#{$structs}});
	$p->parse_AFP_array($container);
	return $container;
}

sub make_PTX {
	my $data_in = shift;
	my @cs_order = qw(d2 c6 f0); 
	my %cs_id2option = (
		d2 => "posY",
		c6 => "posX",
		f0 => "font_lid"
	);
	my %orientation_code = (
		0 => "0000",
		90 => "2d00",
		180 => "5a00",
		270 => "8700"
	);
	my $ptxparameters = [];
	for (@cs_order){
		if (exists $data_in->{$cs_id2option{$_}}){
			push @{$ptxparameters}, { 
				id => $_, 
				$grammar->{ptx_cs}->{$_}->{parameters}->[0]->{name} => $data_in->{$cs_id2option{$_}}
			}
		}
	}
	if ($data_in->{iorientation} || $data_in->{borientation}){
		push @{$ptxparameters}, { id => "f6", 
			IORNTION => $orientation_code{$data_in->{iorientation}} || "0000" , 
			BORNTION => $orientation_code{$data_in->{borientation}} || "0000"
		};
	}
	push @{$ptxparameters}, { id => "da", TRNDATA => $data_in->{text}, ptx_encoding => $data_in->{ptx_encoding} }; 
	return make_struct("structured_field", $sf_acronym2id{"PTX"}, { members => $ptxparameters });
}

# encoders for control codes

my $lot_piece_page = sub {
	my ($lot, $piece, $page) = @_;
	return sprintf "LOT: %s -- MAILPIECE: %s -- PAGE NUMBER: %s", $lot, $piece, $page;
};

$cc_encoders = {
	"lot_piece_page" => $lot_piece_page
};



sub make_control_codes_pt_object {
        my ($parser, $control_codes) = @_;
        my $ptx_structs = [];
        for my $cc (@{$control_codes}){
                # add tests to see if this cc is needed on this page; tests done on values in $parser: recto, verso, first..
		my @pt_args = ();
		for my $pt_arg (@{$config->{control_codes}->{$cc}->{arguments}}){
			if ($pt_arg =~ /^_/) {
				push @pt_args, $parser->{$pt_arg} 
			} else { 
				push @pt_args, $parser->{tabline}->{$pt_arg};
			}
		}
                my $ptx_text = $cc_encoders->{$config->{control_codes}->{$cc}->{cc_encoder}}->(@pt_args);
                push @{$ptx_structs}, make_PTX({
                        text => $ptx_text,
                        posX => $config->{control_codes}->{$cc}->{position}->{X},
                        posY => $config->{control_codes}->{$cc}->{position}->{Y},
                        font_lid => $parser->{controlcode_lid}->{$cc},
                        iorientation => $config->{control_codes}->{$cc}->{iorientation}  || 0,
                        borientation => $config->{control_codes}->{$cc}->{borientation}  || 0,
                        text_encoding => $config->{codepage_encodings}->{$config->{control_codes}->{$cc}->{resources}->{codepage}}
                } );
        }
        return make_object("presentation_text", {}, $ptx_structs);
}

=head1 NAME

AFP::PowerTools::Objects - Create some AFP objects: pages, environment groups, presentation text...

=head1 VERSION

Version 0.02

=cut

our $VERSION = '0.02';

=head1 AUTHOR

Roland Rodrigus, C<< <roland.rodrigus at skynet.be> >>




=head1 LICENSE AND COPYRIGHT

   Copyright (C) 2010 Roland Rodrigus

   This file is part of afppowertools.

   afppowertools is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   afppowertools is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.

=cut

1; # End of AFP::PowerTools::Parser
