package AFP::PowerTools::Parser;
use AFP::PowerTools;
use AFP::PowerTools::Generator;
use warnings;
use strict;
use Exporter 'import';
our @EXPORT = qw($grammar get_fixed_parameter  get_triplet_parameter
	is_SF is_not_SF $always_true $always_false struct2pretty $last_sf $breakpoint
	$copy_sf $hexdump add_resource AFP2struct); 


our ($MCF1_mapping, $MCF2_mapping, $BRS_set, $ERS_unset, $CFI_mapping, $PTX_set_encodings, $reset_lids );
our ($always_true, $always_false, $last_sf, $breakpoint, $copy_sf, $hexdump);

use Encode;
use Encode::EBCDIC;
use constant DEFAULT_CHAR_ENCODING => "cp500";
use constant DEFAULT_PTXCHAR_ENCODING => "iso-8859-1";


sub new {
        # creates a parser resource
        my $class = shift;
        my $parser = { @_ };
	if ( $parser->{apply_mapping}){
		$parser->{mappers} = {
			"BRS" => $BRS_set,
			"ERS" => $ERS_unset,
			"CFI" => $CFI_mapping,
			"BPG" => $reset_lids,
			"MCF1" => $MCF1_mapping,
			"MCF2" => $MCF2_mapping,
			"PTX" => $PTX_set_encodings
			# MCF1 => map_lids_to_codepages
			# MCF2 => map_lids_to_codepages
			# PTX => set encoding for each TRNDATA
			# where RGLength supposed to be read from another SF, set in the $parser
			# ??? IMM => set mode in the parser	
			# other Mapping SF's: rarely used?
		}; 
	}
        bless $parser, $class;
}


sub set_rule {
        # A rule has two part: a condition, and an action to be executed if the condition is met.
        # Each rule is evaluated after processing each Structured Field.
        # Conditions and actions are references to subs. These handlers are called back by parse_afpfile(), parse_afparray(),...
        my $parser = shift;
        my ($condition, $action) = @_;
        push @{$parser->{handlers}}, { condition=> $condition, action => $action };
        return $parser;
}

sub reset_rules {
	my $parser = shift;
	undef $parser->{handlers};
	return $parser;
}

sub parse_AFP_file {
        my ($parser, $afpfile, $start_at_offset) = @_;
        $parser->{state} = [];
	$parser->{last_sfi} = "";
        open $parser->{AFP_IN}, $afpfile or die "cant open $afpfile";
	binmode($parser->{AFP_IN});
	if ($start_at_offset){ seek $parser->{AFP_IN}, $start_at_offset, 0};
        STRUCTURED_FIELD: while (my $structured_field = AFP2struct($parser, "structured_field")){
		for ( keys %{$parser->{mappers}} ){
			if ($structured_field->{is_parsed} && $_ eq $sf_id2acronym{$structured_field->{id}}){
				$parser->{mappers}->{$_}->($structured_field, $parser);
			}
		}
                for ( @{$parser->{handlers}} ){ if ($_->{condition}->($structured_field, $parser)) { $_->{action}->($structured_field, $parser) } }
                if ($structured_field->{sf_type} eq "a9"){ pop @{$parser->{state}} }
		$parser->{last_sfi} = $structured_field->{id};
        }
        close $parser->{AFP_IN};
}



sub parse_AFP_array {
        my ($parser, $afparray) = @_;
	$parser->{last_sfi} = "";
        $parser->{array_offset} = 0;
        STRUCTURED_FIELD: for my $item (@{$afparray}){
		if (ref $item){
                	for ( @{$parser->{handlers}} ){ 
				if ($_->{condition}->($item, $parser)) { $_->{action}->($item, $parser) } 
			}
			$parser->{last_sfi} = $item->{id};
		}
                $parser->{array_offset}++;
        }
}

sub AFP2struct {
        my ($parser, $kind) = @_;
	$parser->{offset} = tell $parser->{AFP_IN};
        my $bytes_left;
        my $struct = {};
        $struct->{kind} = $kind;
        $struct->{parameters_order} = [];
        if ( (exists $grammar->{meta}->{$kind}->{prefix}) && ! $parser->{ptxchaining}){
                read $parser->{AFP_IN}, $struct->{prefix}, $grammar->{meta}->{$kind}->{prefix}->{size} or return 0;
                if (unpack ("H*", $struct->{prefix}) ne $grammar->{meta}->{$kind}->{prefix}->{value}){ die "Malformed AFP at offset", tell;}
        }
        read $parser->{AFP_IN}, $struct->{header}, $grammar->{meta}->{$kind}->{header}->{size} or die;
        @{$struct}{@{$grammar->{meta}->{$kind}->{header}->{fields}}} = unpack $grammar->{meta}->{$kind}->{header}->{format}, $struct->{header};
        if ($kind eq "structured_field") {@{$struct}{qw(sf_class sf_type sf_category)} = unpack "(a2)*", $struct->{id}}
        if ($struct->{kind} eq "structured_field" && $struct->{sf_type} eq "a8"){ push @{$parser->{state}}, $struct->{sf_category} }
	$struct->{in_state} = join "@", @{$parser->{state}};
        $bytes_left = $struct->{size} - $grammar->{meta}->{$kind}->{header}->{size};
        if (($kind eq "structured_field") && ($struct->{flags} ne "00")) {die "Flag bits unsupported"}
        if ($kind eq "ptx_cs"){
                $parser->{ptxchaining} = (unpack ("C", substr ($struct->{header}, 1, 1))) % 2;
                $struct->{ptxchaining} = $parser->{ptxchaining};
                if ($struct->{ptxchaining}) {
                        $struct->{id} = unpack "H2", pack ( "C", ( ( unpack ( "C", substr ($struct->{header}, 1, 1 ) ) ) - 1 ) );
                }
        }
        $struct->{is_parsed} = 0;
        if ((!exists $grammar->{$kind}->{$struct->{id}}) ||
                (($kind eq "structured_field")
                && (exists $parser->{parse_only})
                &&  ! exists $parser->{parse_only}->{$sf_id2acronym{$struct->{id}}}  ) ){
                read $parser->{AFP_IN}, $struct->{unparsed_data}, $bytes_left;
                return $struct;
        }
        $struct->{name} = $grammar->{$kind}->{$struct->{id}}->{name};
        FIXED_PARAMETER: for(@{$grammar->{$kind}->{$struct->{id}}->{parameters}}){
                last FIXED_PARAMETER if (! $bytes_left);
                my $parameter = { %{$_} };
                $parameter->{size} = ( !(defined $_->{size}) || ( $bytes_left < $_->{size}) ) ? $bytes_left : $_->{size};
                read $parser->{AFP_IN}, $parameter->{encoded_value}, $parameter->{size};
                $struct->{$_->{name}} = $parameter;
                push @{$struct->{parameters_order}}, $_->{name};
                $bytes_left -= $parameter->{size};
        }
        if (exists $grammar->{$kind}->{$struct->{id}}->{rgs}){
                my $rgi = 0; # n'th Repeating Groups
                my $rg_offset; # offset from the beginning of the repeating group
                if (exists $struct->{RGLength}){ $struct->{rglength} = get_fixed_parameter($struct->{RGLength}) }
                RG: while ($bytes_left){
                        $rg_offset = 0;
                        RG_FIXED_PARAMETER: for (@{$grammar->{$kind}->{$struct->{id}}->{rgs}->{parameters}}) {
                                my $parameter = { %{$_} };
                                read $parser->{AFP_IN}, $parameter->{encoded_value}, $parameter->{size};
                                $struct->{rgs}->[$rgi]->{$_->{name}} = $parameter;
                                push @{$struct->{rgs}->[$rgi]->{parameters_order}}, $_->{name};
                                if ($_->{name} eq "RGLength"){ $struct->{rglength} = get_fixed_parameter($parameter)  }
                                $rg_offset += $_->{size};
                                last RG_FIXED_PARAMETER if ( ( exists $struct->{rglength}) && ($rg_offset>= $struct->{rglength}) );
                        }
                        if (exists $struct->{rglength}){
                                RG_TRIPLET: while ($rg_offset < $struct->{rglength}) {
                                        my $member = AFP2struct($parser, "triplet");
                                        push @{$struct->{rgs}->[$rgi]->{members}}, $member;
                                        $rg_offset += $member->{size};
                                }
                        }
                        $bytes_left -= $rg_offset;
                        $rgi++;
                }
        }
        TRIPLET: while ($bytes_left){
                my $member = AFP2struct($parser, ($struct->{id} eq "d3ee9b") ? "ptx_cs" : "triplet");
                push @{$struct->{members}}, $member;
                $bytes_left -= $member->{size};
                if (exists $member->{prefix}){  $bytes_left -= $grammar->{meta}->{ptx_cs}->{prefix}->{size} }
        }
        $struct->{is_parsed} = 1;
        return ($struct) ;
}


sub get_fixed_parameter {
        my $parameter = shift;
        if ($parameter->{type} eq "CODE") {
                return unpack "H*", $parameter->{encoded_value};
        }
        if ($parameter->{type} eq "CHAR") {
                my $encoding = $parameter->{char_encoding} || DEFAULT_CHAR_ENCODING;
                #if (substr($parameter->{encoded_value}, 0, 2) eq pack ("H4", "FFFF")){ return "FFFF"};
                return decode $encoding, $parameter->{encoded_value};
        }
        if ($parameter->{type} eq "BITS") {
                return unpack "B*", $parameter->{encoded_value},
        }
        if ($parameter->{type} eq "UBIN") {
                return unpack ("N", substr ("\0\0\0". $parameter->{encoded_value}, -4));
        }
        if ($parameter->{type} eq "SBIN") {
                if ( unpack ("C", substr ($parameter->{encoded_value}, 0, 1)) & 0x80){
                        return  unpack ("N", substr ("\xff\xff\xff" . $parameter->{encoded_value}, -4)) - 256**4;
                } else {
                        return unpack ("N", substr ("\0\0\0". $parameter->{encoded_value}, -4));
                }
        }
	if ($parameter->{type} eq "KEYWORDS") {
		return  { unpack "(H2)*",  $parameter->{encoded_value} } ;
	}
        die "unkonwn type $parameter->{type}";
}


sub get_triplet_parameter {
        my ($members, $wantedField, $wantedId, $wantedFQNType) = @_;
        TRIPLET: for (@{$members}){
                if ($_ eq "unparsed"){next TRIPLET}
                if ($_->{id} eq $wantedId){
                        if (($wantedId eq "02") && ($wantedFQNType ne unpack "H2", $_->{FQNType}->{encoded_value})){ next }
                        if (exists $_->{$wantedField}) {return get_fixed_parameter($_->{$wantedField})};
                }
        }
}


$BRS_set = sub {
	my ($struct, $parser) = @_;
	my $RSName = get_fixed_parameter($struct->{RSName});
	$parser->{resource_list}->{$RSName} = 1; 
	$parser->{in_resource}->{name} = $RSName;
};

$ERS_unset = sub {
	my ($struct, $parser) = @_;
	undef $parser->{in_resource};
};

$CFI_mapping = sub {
	my ($struct, $parser) = @_;
	$parser->{codedfont2codepage}->{$parser->{in_resource}->{name}} = get_fixed_parameter($struct->{CPName});
	$parser->{codedfont2fontcs}->{$parser->{in_resource}->{name}} = get_fixed_parameter($struct->{FCSName}); 
};

$reset_lids = sub {
	my ($struct, $parser) = @_;
	$parser->{lid2font} = [];
};

$MCF1_mapping = sub {
	my ($struct, $parser) = @_;
	for (@{$struct->{rgs}}){
		my $lid = get_fixed_parameter($_->{CFLid});
		$parser->{lid2font}->[$lid]->{CFName} = get_fixed_parameter($_->{CFName}); 
		$parser->{lid2font}->[$lid]->{CPName} = get_fixed_parameter($_->{CPName}); 
		$parser->{lid2font}->[$lid]->{FCSName} = get_fixed_parameter($_->{FCSName}); 
		$parser->{lid2font}->[$lid]->{actual_codepage} = ($parser->{lid2font}->[$lid]->{CPName} ne "X'FFFF'") ? 
			$parser->{lid2font}->[$lid]->{CPName} :
			$parser->{codedfont2codepage}->{$parser->{lid2font}->[$lid]->{CFName}};
		$parser->{lid2font}->[$lid]->{actual_fontcs} = ($parser->{lid2font}->[$lid]->{FCSName} ne "X'FFFF'") ? 
			$parser->{lid2font}->[$lid]->{FCSName} :
			$parser->{codedfont2fontcs}->{$parser->{lid2font}->[$lid]->{CFName}};
		if(exists $_->{CharRot}){ $parser->{lid2font}->[$lid]->{CharRot} = get_fixed_parameter($_->{CharRot}); }
	}
};

$MCF2_mapping = sub {
	my ($struct, $parser) = @_;
	for (@{$struct->{rgs}}){
		my $lid = get_triplet_parameter($_->{members}, "ResLID", "24");
		$parser->{lid2font}->[$lid]->{CFName} = get_triplet_parameter($_->{members}, "FQName" , "02", "8e");
		$parser->{lid2font}->[$lid]->{CPName} = get_triplet_parameter($_->{members}, "FQName" , "02", "85");
		$parser->{lid2font}->[$lid]->{FCSName} = get_triplet_parameter($_->{members}, "FQName" , "02", "86");
		$parser->{lid2font}->[$lid]->{actual_codepage} = 
			$parser->{lid2font}->[$lid]->{CPName} ||
			$parser->{codedfont2codepage}->{$parser->{lid2font}->[$lid]->{CFName}};
		$parser->{lid2font}->[$lid]->{actual_fontcs} =  
			$parser->{lid2font}->[$lid]->{FCSName} || 
			$parser->{codedfont2fontcs}->{$parser->{lid2font}->[$lid]->{CFName}};
		$parser->{lid2font}->[$lid]->{CharRot} = get_triplet_parameter($_->{members}, "CharRot", "26");
	}
};

$PTX_set_encodings = sub {
	my ($struct, $parser) = @_;
	for (@{$struct->{members}}){
		if ($ptxcs_id2acronym{$_->{id}} eq "SCFL"){
			$parser->{active_lid} =  get_fixed_parameter($_->{LID});
		} 
		if ($ptxcs_id2acronym{$_->{id}} eq "TRN"){
			$_->{TRNDATA}->{char_encoding} = 
				(exists ($parser->{lid2font}->[$parser->{active_lid}]) && 
				exists ($config->{codepage_encodings}->{$parser->{lid2font}->[$parser->{active_lid}]->{actual_codepage}}) ) ?
				$config->{codepage_encodings}->{$parser->{lid2font}->[$parser->{active_lid}]->{actual_codepage}} : 
				DEFAULT_PTXCHAR_ENCODING ;
		}
	}
};


sub struct2pretty {
        my $struct = shift;
        my $pretty = [];
        my $name = $struct->{name};
        for (qw(id name size)){
                push @{$pretty}, { $_ => $struct->{$_} };
        }
        for (@{$struct->{parameters_order}}){
                push @{$pretty}, { $_ => get_fixed_parameter($struct->{$_})};
        }
        if ($struct->{rgs}){
                my $rgs = [] ;
                my $rgi = 0;
                for (@{$struct->{rgs}}){
                        for ( @{$_->{parameters_order}}){
                                push @{$rgs->[$rgi]}, { $_ => get_fixed_parameter($struct->{rgs}->[$rgi]->{$_})};
                        }
                        if ($_->{members}){
                                my $members = [];
                                for (@{$_->{members}}){
                                        push @{$members}, struct2pretty($_);
                                }
                                push @{$rgs->[$rgi]}, { "triplets" => $members};
                        }
                        $rgi++;
                }
                push @{$pretty}, { rgs => $rgs };
        }
        if ($struct->{members}){
                my $members = [];
                for (@{$struct->{members}}){
                        push @{$members}, struct2pretty($_);
                }
                push @{$pretty}, {($struct->{id} eq "d3ee9b") ? "ptx_sequences" : "triplets" => $members};
        }
        return  $pretty ;
}



sub is_SF {
        # takes a list of SF Names, returns true if the SF belongs in the list
        my @sfnames = @_;
        return sub { my $sf = shift; return grep $sf->{id} eq $_,  @sf_acronym2id{@sfnames} };
}


sub is_not_SF {
        # takes a list of SF Names, returns true if the SF does not belongs to the list
        my @sfnames = @_;
        return sub { my $sf = shift; return 0 if (grep $sf->{id} eq $_,  @sf_acronym2id{@sfnames}); return 1; };
}


$always_true = sub { return 1 };
$always_false = sub { return 0 };

$last_sf = sub {
	no warnings;
	last STRUCTURED_FIELD;
};

$breakpoint = sub {
	$DB::single = 1;
};

$hexdump = sub {
        my $sf = shift;
        my $bytestring = struct2AFP($sf);
        printf "%s\n\n", join (" ", unpack ("(H2)*", $bytestring));
};

$copy_sf = sub {
        my ($sf, $parser) = @_;
        my $bytestring = struct2AFP($sf);
        print { $parser->{OUTPUT_AFP} } $bytestring;
};

sub add_sf {
        my ($parser, $sf_id) = @_;
        print { $parser->{OUTPUT_AFP} } struct2AFP(make_struct("structured_field", $sf_acronym2id{$sf_id}));
}

sub add_resource {
	my ($parser, $ObjType, $RSName) = @_;
	if (exists $parser->{resource_list}->{$RSName}) { return };
	my %objtypes = reverse %{$grammar->{triplet}->{"21"}->{parameters}->[0]->{codes}};
	my $resource_basepath = $yamls_dir . "/resources";
	print { $parser->{OUTPUT_AFP} } struct2AFP(make_struct(
		"structured_field",
		$sf_acronym2id{BRS}, 
		{
			RSName => $RSName,
			members => [
				{ id => "21", ObjType => $objtypes{$ObjType}}
			]
		}
	));
	open RES, $resource_basepath . "/" . $ObjType . "s/" . $RSName or die;
	binmode RES;
	local $/ ;
	print { $parser->{OUTPUT_AFP} } <RES>;
	close RES;
	$parser->add_sf("ERS");
}


=head1 NAME

AFP::PowerTools::Parser - A parser for AFP streams and files. 

=head1 VERSION

Version 0.02

=cut

our $VERSION = '0.02';


=head1 AUTHOR

Roland Rodrigus, C<< <roland.rodrigus at skynet.be> >>



=head1 LICENSE AND COPYRIGHT

   Copyright (C) 2010 Roland Rodrigus

   This file is part of afppowertools.

   afppowertools is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   afppowertools is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.

=cut

1; # End of AFP::PowerTools::Parser


