#! /usr/bin/perl -w
use strict;
use AFP::PowerTools;
use AFP::PowerTools::Parser;
use AFP::PowerTools::Generator;

####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################




my $afpfile = shift or die "give an afp file as argument";

my $print_sfi = sub {
	my $sf = shift;
	printf "%s (%s)\n", $sf_id2acronym{$sf->{id}}, $sf->{id};
};

my $parser = AFP::PowerTools::Parser->new();
$parser->set_rule($always_true, $print_sfi);
$parser->parse_AFP_file($afpfile);



