#! /usr/bin/perl -w
use strict;

####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################

use AFP::PowerTools::Parser;

my %counters;

my $dump_TLE = sub {
	my $sf = shift;
	my $tle_name = get_triplet_parameter ($sf->{members}, "FQName", "02", "0b") ;
	my $tle_value = get_triplet_parameter ($sf->{members}, "AttVal", "36") ;
	
	printf "%s\t%s\n", $tle_name, $tle_value;
};

my $mark = sub {
	my $sf = shift;
	printf "\n===== %s % 6d =====\n", $sf->{name}, ++$counters{$sf->{id}} ;
};


my $afpfile = shift or die "give an afp file as argument";

my $parser = AFP::PowerTools::Parser->new();
$parser->set_rule(is_SF(qw(IEL BDT BNG BPG)), $mark);
$parser->set_rule(is_SF("TLE"),$dump_TLE);
$parser->parse_AFP_file($afpfile);



