#! /usr/bin/perl -w
use strict;
use AFP::PowerTools;
use AFP::PowerTools::Parser;
####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################




my %sf_counters;
my $sf_counter = 0;
my $triplets_stats = {};
my %ptx_stats;
my %objects_stats;

my $make_stats_triplets = sub {
	my $sf = shift;
	for (@{$sf->{members}}){
		$triplets_stats->{$_->{id}}->{total} ++;
		$triplets_stats->{$_->{id}}->{sfs}->{$sf->{id}} ++;
	}
};

my $increase_sf_counter =  sub {
	my $sf = shift;
	$sf_counters{$sf_id2acronym{$sf->{id}}}++;
	$sf_counter++;
};

my $make_stats_ptx = sub {
	my $sf = shift;
	for (@{$sf->{members}}){
		$ptx_stats{$_->{id}}++;
	}
};

my $is_opening_object = sub {
	my $sf = shift;
	return ($sf->{sf_type} eq "a8");
};


my $make_stats_objects = sub {
	my $sf = shift;
	my $object_string = $sf->{in_state};
	$objects_stats{$object_string}++;
};

my $afpfile = shift or die "give an afp file as argument";
my $parser = AFP::PowerTools::Parser->new();
$parser->set_rule($always_true, $increase_sf_counter);
$parser->set_rule(is_not_SF("PTX"),$make_stats_triplets);
$parser->set_rule(is_SF("PTX"),$make_stats_ptx);
$parser->set_rule($is_opening_object,$make_stats_objects);
$parser->parse_AFP_file($afpfile);

printf "\nStatistics for %s:\n\n", $afpfile;
printf "------------------------------------------------------------------------------\n";

printf "NAMED GROUPS AND PAGES:\n";
printf "Number of named groups: %d\n", $sf_counters{BNG} || 0;
printf "Number of pages: %d\n", $sf_counters{BPG};
printf "------------------------------------------------------------------------------\n";

printf "STRUCTURED FIELDS:\n";
for (sort keys %sf_counters){
	printf "\t% 8d %s\n", $sf_counters{$_}, $_;
}
printf "\tTotal: %d\n", $sf_counter;
printf "------------------------------------------------------------------------------\n";


printf "TRIPLETS:\n";
for my $tid (sort keys %{$triplets_stats}){
	printf "\t% 6d %s (Triplet ID %s) of which:\n",
		$triplets_stats->{$tid}->{total},
		$grammar->{triplet}->{$tid}->{name} || "unparsed",
		$tid
	;
	for my $sfid (sort keys %{$triplets_stats->{$tid}->{sfs}}){
		printf "\t\t% 6d in SF %s\n", 
			$triplets_stats->{$tid}->{sfs}->{$sfid},
			$sf_id2acronym{$sfid}; 
	}
}
printf "------------------------------------------------------------------------------\n";

printf "PRESENTATION TEXT: \n";
for my $csid (sort keys %ptx_stats){
	printf "\t% 6d %s (Controling Sequence ID %s)\n",
		$ptx_stats{$csid},
		$grammar->{ptx_cs}->{$csid}->{name} || "unparsed",
		$csid
	;
}
printf "------------------------------------------------------------------------------\n";

printf "AFP OBJECTS:\n";
for (sort keys %objects_stats){
	printf "% 10d %s\n", $objects_stats{$_}, join " ==> ", @{$grammar->{state}}{split ("@", $_)};
}
printf "------------------------------------------------------------------------------\n";



