#! /usr/bin/perl -w
use strict;


####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################



use AFP::PowerTools;
use AFP::PowerTools::Parser;
use AFP::PowerTools::Generator;
use AFP::PowerTools::Objects;

sub usage {
my $usage = <<EOF;
Usage:
  ./tab2afp 
	-t tabfile	# a <TAB> separated file with the filename, offset, media, id's... of the documents
	-o out.afp	# name of the output file
	-c config	# output config; must be defined in /usr/share/afppowertools/config/output_lines.yml
	-d dir		# directory of the input spool
EOF
print $usage;
exit 1;
}


use Getopt::Std;
my $opts = {};
getopts 't:o:c:d:', $opts;
my $tabfile = $opts->{t} or usage(); 
my $outputafp = $opts->{o} or usage();
my $output_line = $config->{output_lines}->{$opts->{c}} or usage();
my $input_dir = $opts->{d} or usage();


my %medium_maps; 
my $formdef = $config->{formdefs}->{$output_line->{formdef}};
my %duplex_control = (simplex => "01", duplex => "02"); # for the duplex control keyword
my %short_plex = (simplex => "SI", duplex => "DU"); # for the name of the medium map
my $last_destid = "";
my $front_page = $yamls_dir . "/templates/whitepage.afp";
my $parser = AFP::PowerTools::Parser->new(
	apply_mapping => 1,
	parse_only => {
		BRS => 1,
		MCF1 => 1,
		MCF2 => 1
	}
);
$parser->{tabline} = {}; # fields read from TAB
$parser->{_lot_name} = $tabfile;
open $parser->{OUTPUT_AFP}, "> " .  $outputafp or die;
$parser->{_page_nr} = 0; 
$parser->{_mailpiece_nr} = 0;
open TAB, $tabfile or die "cant open $tabfile";



# RESOURCES
$parser->{to_copy} = 0;
my %resource_list;
my $to_copy = sub {
	my ($sf, $parser) = @_;
	return ($parser->{to_copy} == 1);
};

my $set_to_copy = sub{
	my ($sf, $parser) = @_;
	$parser->{to_copy} = 1;
};

my $unset_to_copy = sub {
	my ($sf, $parser) = @_;
	$parser->{to_copy} = 0;
};

my $is_BRS_and_is_new_resource = sub {
	my ($sf, $parser) = @_;
	if ($sf->{id} eq $sf_acronym2id{"BRS"}){
		my $RSName = get_fixed_parameter($sf->{RSName});
		if (! exists $resource_list{$RSName}){
			$resource_list{$RSName} = 1;
			return 1;
		}
	}
	return 0;
};

# RULES FOR RESOURCES
$parser->set_rule($is_BRS_and_is_new_resource, $set_to_copy);
$parser->set_rule($to_copy, $copy_sf);
$parser->set_rule(is_SF("ERS"), $unset_to_copy);
$parser->set_rule(is_SF("ERG"), $last_sf);
$parser->add_sf("BRG");
my $mediummap_structs = [];

RESOURCE: while (<TAB>){
	chomp;
	@{$parser->{tabline}}{@{$config->{tabfile}->{field_order}}} = split /\t/; 
	my @media =  split ":", $parser->{tabline}{media_in} ;
	MEDIA: for (@media){
		$_ =~ /([RV])([0-9])/;
		if ($1 eq "V") { next MEDIA }
		if (($parser->{tabline}{destid} ne $last_destid) && ($formdef->{with_jog})){
			$parser->{must_jog} = "01";
		}	
		my $tray_nr = sprintf "%02d", $2;
		# Medium Map names have the form "MaabbcPd", where  aa = plex ("SI" or "DU"), bb = tray_nr, c = n-UP, d = jog (N or J)
		my $medium_map_name = sprintf "M%s%02d%dP%s",
			$short_plex{$formdef->{plex}}, 
			$tray_nr, 
			$formdef->{n_up}, 
			($parser->{must_jog} eq "01") ? "J" : "N";
		if ($parser->{must_jog} eq "01"){$parser->{must_jog} = "00"}
		if (! exists $medium_maps{$medium_map_name}){
			push @{$mediummap_structs}, make_struct("structured_field", $sf_acronym2id{BMM}, { MMName => $medium_map_name } );
			if (($formdef->{plex} eq "duplex") && ($formdef->{n_up} == 1)){ $formdef->{SHsides} ||= "00 01"}
			my $pgp_rgs = [];
			for (split / /, $formdef->{SHsides}){
				push @{$pgp_rgs}, { RGLength => 10, SHside => $_ }
			}
			push @{$mediummap_structs}, make_struct("structured_field", $sf_acronym2id{PGP2}, { rgs => $pgp_rgs  });
			push @{$mediummap_structs}, make_struct("structured_field", $sf_acronym2id{MDD} );
			my $mcc_rgs = [ { Startnum => 1, Stopnum => 1, MMCid => "01" } ];
			if ($formdef->{plex} eq "duplex"){
				push @{$mcc_rgs}, { Startnum => 2, Stopnum => 2, MMCid => "02" };
			} 
			push @{$mediummap_structs}, make_struct("structured_field", $sf_acronym2id{MCC}, { rgs => $mcc_rgs  });
			my $mmc_keywords = { 
				d1 => $parser->{must_jog} || "00",
				e1 => $tray_nr , 
				f4 => $duplex_control{$formdef->{plex}}, 
				fc => sprintf "%02d", $formdef->{n_up}
			};
			push @{$mediummap_structs}, make_struct("structured_field", $sf_acronym2id{MMC}, { MMCid => "01", MMC_KEYWORDS => $mmc_keywords });
			if ($formdef->{plex} eq "duplex"){
				push @{$mediummap_structs}, make_struct("structured_field", $sf_acronym2id{MMC}, { MMCid => "02", MMC_KEYWORDS => $mmc_keywords });
			}
			push @{$mediummap_structs}, make_struct("structured_field", $sf_acronym2id{EMM}, { MMName => $medium_map_name });
			$medium_maps{$medium_map_name} = 1;
		}
	}
	$parser->parse_AFP_file($input_dir . "/" . $parser->{tabline}{filename});
}

# add resources for control codes 
for my $cc (@{$output_line->{control_codes}}){
	for  (keys %{$config->{control_codes}->{$cc}->{resources}}){
			$parser->add_resource($_, $config->{control_codes}->{$cc}->{resources}->{$_});
	}
}

my $formdef_structs = make_object("formdef")   ;
add_structs_to_object($formdef_structs, $mediummap_structs, is_SF("EDG"));

print { $parser->{OUTPUT_AFP} } struct2AFP(make_struct("structured_field", $sf_acronym2id{BRS}, {RSName => "FORMDEF0", members => [{id => "21", ObjType => "fe"  } ]  } )  );
print { $parser->{OUTPUT_AFP} } object2AFP($formdef_structs);
print { $parser->{OUTPUT_AFP} } struct2AFP(make_struct("structured_field", $sf_acronym2id{ERS}, {RSName => "FORMDEF0"}  ) );
 


# end of resources
$parser->add_sf("ERG");
$parser->add_sf("BDT");

# DOCUMENTS
seek TAB, 0, 0;

my $at_BPG = sub {
	my ($sf, $parser) = @_;
	$parser->{media_in}->[$parser->{media_stack_offset}] =~ /([RV])([0-9])/;
	my $tray_nr = $2;
	if(defined $parser->{must_jog}) {
		print { $parser->{OUTPUT_AFP} } struct2AFP(make_struct(
			"structured_field", 
			$sf_acronym2id{IMM}, 
			{ MMPName => sprintf "M%s%02d%dP%s", 
				$short_plex{$formdef->{plex}}, 
				$tray_nr, 
				$formdef->{n_up}, 
				($parser->{must_jog} eq "01") ? "J" : "N"  
			}  
		)); 
		if ($parser->{must_jog} eq "01"){
			$parser->{must_jog} = "00";
		} else {
			undef $parser->{must_jog}
		}
	}
	print { $parser->{OUTPUT_AFP} } struct2AFP($sf);
	$parser->{_page_nr}++;
};

my $at_EPG = sub {
	my ($sf, $parser) = @_;
	print { $parser->{OUTPUT_AFP} } object2AFP(make_control_codes_pt_object($parser, $output_line->{control_codes}));
	print { $parser->{OUTPUT_AFP} } struct2AFP($sf);

	if ( 	($formdef->{plex} eq "duplex") &&  
		($parser->{media_in}->[$parser->{media_stack_offset}] =~ /^R/) && 
		(	($parser->{media_stack_offset} >= $#{$parser->{media_in}}  )  || 
			( $parser->{media_in}->[$parser->{media_stack_offset} + 1] =~ /^R/)
		)
	){
		my $save_media_in = $parser->{media_in};
		my $save_media_offset = $parser->{media_stack_offset};
		$parser->{media_in} = [ "V1" ];
		$parser->{media_stack_offset} = 0;
		$parser->parse_AFP_array(make_object("page"));
		$parser->{media_in} = $save_media_in;
		$parser->{media_stack_offset} = $save_media_offset;
	}
	$parser->{media_stack_offset}++;
};

my $last_page_in_doc = sub {
	my ($sf, $parser) = @_;
	return ($parser->{media_stack_offset} > $#{$parser->{media_in}});
};

my $at_legitimate_place_for_our_MCF = sub {
	my ($sf, $parser) = @_;
	if ($parser->{last_sfi} eq ""){ return 0;}
	my $last_acronym = $sf_id2acronym{$parser->{last_sfi}};
	return (
		(($last_acronym =~ /MCF/) || ($last_acronym eq "PEC") || ($last_acronym eq "BAG")) &&
		(($sf_id2acronym{$sf->{id}} !~ /MCF/) && ($sf_id2acronym{$sf->{id}} ne "PEC"))
	);
};


# MCF2
my $add_our_MCF = sub {
	my ($sf, $parser) = @_;
	my $lid = $#{$parser->{lid2font}} + 1;
	my $rgs = [];
	for my $cc (@{$output_line->{control_codes}}){
		if ($lid > 127){ die "maximum number of LID's exceeded" }
		$parser->{controlcode_lid}->{$cc} = $lid;
		$parser->{lid2font}->[$lid]->{FCSName} = $parser->{lid2font}->[$lid]->{actual_fontcs} =
			$config->{control_codes}->{$cc}->{resources}->{font};
		$parser->{lid2font}->[$lid]->{CPName} = $parser->{lid2font}->[$lid]->{actual_codepage} =
			$config->{control_codes}->{$cc}->{resources}->{codepage};
		my $mcf2_repeating_group = { RGLength => 37, members => [
				{ id => "02", FQNType => "86", FQName => $config->{control_codes}->{$cc}->{resources}->{font} },
				{ id => "02", FQNType => "85", FQName => $config->{control_codes}->{$cc}->{resources}->{codepage} },
				{ id => "24", ResTyp => "05", ResLID => $lid },
				{ id => "25" },
				{ id => "26", CharRot => "0000"}
		]};
		push @{$rgs}, $mcf2_repeating_group;
		$lid++;
	}
	print { $parser->{OUTPUT_AFP} } struct2AFP(make_struct("structured_field", $sf_acronym2id{MCF2}, { rgs => $rgs   }  ));
};




# RULES FOR DOCUMENTS
$parser->reset_rules();
$parser->set_rule( is_SF("BPG"), $at_BPG);
$parser->set_rule( is_SF("EPG"), $at_EPG);
$parser->set_rule($at_legitimate_place_for_our_MCF, $add_our_MCF);
$parser->set_rule(is_not_SF(qw(BNG ENG IMM TLE BPG EPG)), $copy_sf);
$parser->set_rule( $last_page_in_doc, $last_sf);
DOCUMENT: while (<TAB>){
	chomp;
	@{$parser->{tabline}}{@{$config->{tabfile}->{field_order}}} = split /\t/; 
	if ($last_destid ne $parser->{tabline}{destid}){
		if ($formdef->{with_jog}){$parser->{must_jog} = "01"}
		$parser->{_mailpiece_nr} ++;
		if ($output_line->{with_front_page}){
			$parser->{media_in} = [ "R1" ];
			$parser->{media_stack_offset} = 0;
			$parser->parse_AFP_array(make_object("page"));
		} 
		$last_destid = $parser->{tabline}{destid};
	}
	$parser->{media_in} = [ split ":", $parser->{tabline}{media_in} ];
	$parser->{media_stack_offset} = 0;
	$parser->parse_AFP_file($input_dir . "/" .  $parser->{tabline}{filename}, $parser->{tabline}{offset});
}


$parser->add_sf("EDT");



