/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "globalobject.h"


GlobalObject::GlobalObject(QObject *parent) : QObject(parent)
{
    this->userConnected = false;

    // Load settings
    QSettings settings;
    settings.beginGroup("Configuration");

    this->syncGeneralSettings(settings.value("adminJids").toStringList(),
                              settings.value("commandPrefix",
                                             "!").toString(),
                              settings.value("keepAliveTimeout",
                                             60).toInt());


    this->syncNotificationSettings(settings.value("notifyNewChats",
                                                  false).toBool(),
                                   settings.value("notifyDisconnection",
                                                  false).toBool());


    this->syncSystraySettings();



    qDebug() << "GlobalObject created";
}


GlobalObject::~GlobalObject()
{
    qDebug() << "GlobalObject destroyed";
}


void GlobalObject::syncGeneralSettings(QStringList newAdminJids,
                                       QString newCommandPrefix,
                                       int newKeepAliveTimeout)
{
    this->adminJids = newAdminJids;
    this->commandPrefix = newCommandPrefix;
    this->keepAliveTimeout = newKeepAliveTimeout;
}


QStringList GlobalObject::getAdminJids()
{
    return this->adminJids;
}


QString GlobalObject::getCommandPrefix()
{
    return this->commandPrefix;
}

int GlobalObject::getKeepAliveTimeout()
{
    return this->keepAliveTimeout;
}



void GlobalObject::syncNotificationSettings(bool forNewChats,
                                            bool forDisconnection)
{
    this->notifyNewChats = forNewChats;
    this->notifyDisconnection = forDisconnection;
}

bool GlobalObject::getNotifyNewChats()
{
    return this->notifyNewChats;
}

bool GlobalObject::getNotifyDisconnection()
{
    return this->notifyDisconnection;
}


void GlobalObject::syncSystraySettings()
{

}




void GlobalObject::setXmppClient(QXmppClient *client)
{
    this->xmppClient = client;
}

QXmppClient *GlobalObject::getXmppClient()
{
    return this->xmppClient;
}


void GlobalObject::setMucManager(QXmppMucManager *mucManager)
{
    this->xmppMucManager = mucManager;
}

QXmppMucManager *GlobalObject::getMucManager()
{
    return this->xmppMucManager;
}


void GlobalObject::setVariableParser(VariableParser *varParser)
{
    this->variableParser = varParser;
}

VariableParser *GlobalObject::getVariableParser()
{
    return this->variableParser;
}



void GlobalObject::setDataDirectory(QString path)
{
    this->dataDirectory = path;
}

QString GlobalObject::getDataDirectory()
{
    return this->dataDirectory;
}



void GlobalObject::addToLog(QString message, bool inStatusBar)
{
    emit logMessage(message);

    if (inStatusBar)
    {
        emit showInStatusBar(message);
    }
}


void GlobalObject::showNotification(QString title, QString message)
{
    emit showNotificationPopup(title, message);
}


void GlobalObject::setConnected(bool state)
{
    this->userConnected = state;
}


bool GlobalObject::connectedToServer()
{
    return this->userConnected;
}



void GlobalObject::addJoinedRoom(QString roomJid)
{
    if (!joinedRooms.contains(roomJid))
    {
        this->joinedRooms.append(roomJid);
    }
}

void GlobalObject::removeJoinedRoom(QString roomJid)
{
    this->joinedRooms.removeAll(roomJid);
}

QStringList GlobalObject::getJoinedRooms()
{
    return this->joinedRooms;
}


QXmppMucRoom *GlobalObject::roomFromJid(QString roomJid)
{
    foreach (QXmppMucRoom *room, this->xmppMucManager->rooms())
    {
        if (room->jid() == roomJid)
        {
            return room;
        }
    }

    return 0;
}


void GlobalObject::notifyActivityChange(QString name, QString timeRange)
{
    QString text = name;
    if (!timeRange.isEmpty())
    {
        text.append(QString::fromUtf8("   \342\217\260 ") // Alarm clock symbol
                    + timeRange);
    }

    emit activityChanged(text);
}

void GlobalObject::notifyStatusMessageChange(QString text)
{
    emit statusMessageChanged(text);
}



void GlobalObject::sendMessageToJid(QString jid, QString message)
{
    if (!jid.isEmpty() && !message.isEmpty())
    {
        if (this->getJoinedRooms().contains(jid))
        {
            QXmppMucRoom *room = this->roomFromJid(jid);
            if (room)
            {
                room->sendMessage(message);
            }
        }
        else
        {
            this->xmppClient->sendMessage(jid, message);
        }
    }
}

