/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */


#include "identitymodule.h"


IdentityModule::IdentityModule(GlobalObject *globalObject,
                               QWidget *parent) : QWidget(parent)
{
    this->globalObj = globalObject;

    this->dataFile = new DataFile(globalObj->getDataDirectory()
                                  + "/identity.axb",
                                  this);


    this->nickLineEdit = new QLineEdit(this); // Multinicks? FIXME

    // Add formal name field? Last name fields?


    this->updateButton = new QPushButton(QIcon::fromTheme("document-save",
                                                          QIcon(":/images/button-save.png")),
                                         tr("&Update"),
                                         this);
    connect(updateButton, SIGNAL(clicked()),
            this, SLOT(updateData()));


    this->formLayout = new QFormLayout();
    formLayout->addRow(tr("Nickname"), nickLineEdit);

    this->mainLayout = new QVBoxLayout();
    mainLayout->addLayout(formLayout);
    mainLayout->addStretch(1);
    mainLayout->addWidget(new QLabel("Formal name,\n"
                                     "likes and dislikes, etc.", this),
                          0, Qt::AlignCenter); // TMP-------------------------------
    mainLayout->addStretch(2);
    mainLayout->addWidget(updateButton, 0, Qt::AlignRight);
    this->setLayout(mainLayout);

    this->loadIdentity();

    qDebug() << "IdentityModule created";
}

IdentityModule::~IdentityModule()
{
    qDebug() << "IdentityModule destroyed";
}



void IdentityModule::loadIdentity()
{
    QVariantList identityDataList = this->dataFile->loadData();

    QVariantMap identityMap;
    if (!identityDataList.isEmpty())
    {
        identityMap = identityDataList.first().toMap();
    }

    QString nickname = identityMap.value("nickname").toString();
    if (nickname.isEmpty())
    {
        nickname = "AkariXB"; // Default
    }
    this->nickLineEdit->setText(nickname);
    this->globalObj->getVariableParser()->setOwnNickname(nickname);


    // Load other values, likes list, dislikes list, etc


    if (!identityDataList.isEmpty())
    {
        this->globalObj->addToLog(tr("Loaded identity data for %1.",
                                     "%1 is a nickname").arg(nickname));
    }
}


//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// SLOTS //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


void IdentityModule::updateData()
{
    QString nickname = nickLineEdit->text().trimmed();
    if (nickname.isEmpty())
    {
        nickname = "AkariXB";  // Default
        nickLineEdit->setText(nickname);
    }

    this->globalObj->getVariableParser()->setOwnNickname(nickname);


    QVariantMap identityMap;
    identityMap.insert("nickname", nickname);
    // TODO: Insert other key:value pairs


    QVariantList identityDataList;
    identityDataList.append(identityMap);
    this->dataFile->saveData(identityDataList);

    this->globalObj->addToLog(tr("Saved identity data for %1.",
                                 "%1 is a nickname").arg(nickname));
}

