/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef ROOMMODULE_H
#define ROOMMODULE_H

#include <QWidget>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QListWidget>
#include <QGroupBox>
#include <QLineEdit>
#include <QCheckBox>
#include <QPushButton>
#include <QMessageBox>
#include <QLabel>
#include <QStackedWidget>

#include <QDebug>

#include <QXmppMucManager.h>
#include <QXmppClient.h>

#include "globalobject.h"
#include "helpers.h"
#include "chatwidget.h"
#include "datafile.h"


class RoomModule : public QWidget
{
    Q_OBJECT

public:
    explicit RoomModule(GlobalObject *globalObject, QWidget *parent = 0);
    ~RoomModule();

    void loadRoomInfo();
    void saveRoomInfo();

    QString roomDescriptionLine(QString roomJid, QString nickname,
                                bool hasPassword, bool autojoin);

    QListWidgetItem *listItemFromJid(QString roomJid);
    int stackIndexFromJid(QString roomJid);

    void joinRoom(QString roomJid, QString nickname, QString password);
    void leaveRoom(QString roomJid, QString reason);
    void autojoinRooms();

    bool newRoomIsValid(bool showErrors=false);

    void toggleJoinLeaveButtons(QListWidgetItem *item);


signals:


public slots:
    void addRoom();
    void editRoom();
    void updateRoom();
    void removeRoom();

    void joinSelectedRoom();
    void leaveSelectedRoom();
    void changeNick();

    void showRoomDetails(QListWidgetItem *item);
    void toggleRoomDetails(bool state);

    void onRoomJoined(QString jid);
    void onRoomLeft(QString jid);


private:
    QVBoxLayout *mainLayout;
    QListWidget *roomListWidget;

    QHBoxLayout *buttonsLayout;
    QPushButton *addRoomButton;
    QPushButton *removeRoomButton;

    QGroupBox *detailsGroupbox;
    QVBoxLayout *detailsLayout;
    QHBoxLayout *detailsUpperLayout;
    QLineEdit *roomJidLineEdit;
    QLineEdit *nickLineEdit;
    QLineEdit *roomPasswordLineEdit;
    QCheckBox *autojoinCheckbox;
    QPushButton *editRoomButton;
    QPushButton *updateRoomButton;
    QPushButton *joinButton;
    QPushButton *leaveButton;


    QStackedWidget *chatStackedWidget;
    QList<ChatWidget *> openedRooms;

    QLabel *firstPageLabel;


    DataFile *dataFile;

    QXmppMucManager *mucManager;
    QXmppClient *xmppClient;
    GlobalObject *globalObj;
};

#endif // ROOMMODULE_H
