/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "messagehandler.h"


MessageHandler::MessageHandler(GlobalObject *globalObject,
                               QObject *parent) : QObject(parent)
{
    m_globalObject = globalObject;
    m_variableParser = m_globalObject->getVariableParser();

    m_xmppClient = m_globalObject->getXmppClient();
    m_mucManager = m_globalObject->getMucManager();


    qDebug() << "MessageHandler created";
}


MessageHandler::~MessageHandler()
{
    qDebug() << "MessageHandler destroyed";
}



void MessageHandler::processMessage(QXmppMessage message)
{
    QStringList from = message.from().split("/");
    QString bareFrom = from.first();
    from.removeFirst();

    if (message.type() == QXmppMessage::GroupChat)
    {
        // Find the matching room object
        QXmppMucRoom *room = m_globalObject->roomFromJid(bareFrom);
        if (room)
        {
            const QString fromNick = from.join("/");

            // tmp greeting thing
            if (message.body().startsWith(room->nickName(), Qt::CaseInsensitive)
             && fromNick != room->nickName())
            {
                if (message.body().contains("bye"))
                {
                    room->sendMessage(QString("Bye, %1! o/").arg(fromNick));
                }
                else
                {
                    room->sendMessage(QString("Hey %1! o/").arg(fromNick));
                }
            }
        }
    }
    else if (message.type() == QXmppMessage::Normal
          || message.type() == QXmppMessage::Chat)
    {
        if (!message.body().isEmpty())
        {
            m_globalObject->sendPrivateMessage(message.from(),
                                               m_variableParser
                                               ->getParsed("Hi{!|!!|!!!} "
                                                           "%smiley%")); // tmp FIXME
        }
    }
    else
    {
        const QString errorMessage = tr("Error %1 from %2: %3")
                                     .arg(message.error().code())
                                     .arg(message.from())
                                     .arg(message.error().text());

        m_globalObject->addToLog(errorMessage);

        qDebug() << "Message type is Error or Headline:";
        qDebug() << "Subject:" << message.subject();
        qDebug() << message.body();
        qDebug() << "Error:" << message.error().text();
        qDebug() << "Code:" << message.error().code();
        qDebug() << "------";
    }
}

