.\" Process this file with
.\" groff -man -Tutf8 akfavatar-graphic.en.man
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "akfavatar-graphic" 3 2013-08-09 AKFAvatar
.
.SH NAME
akfavatar-graphic \- module to display graphics in Lua-AKFAvatar
.
.SH SYNOPSIS
.PP
local graphic = require "akfavatar-graphic"
.PP
.SH DESCRIPTION
.PP
Module for Lua-AKFAvatar to display graphics.
.PP
.BR Notes :
.IP \(en 2
Coordinates start with 1, 1 in the upper left corner.
.IP \(en
It can also be used in the style of turtle graphic.
.IP \(en
The pen size, position, heading, pen color and background color are set for
each graphic.
.IP \(en
The code is not optimized for speed.
You can do animations, but they won't be smooth.
.PP
.SS Functions / Methods
.TP
.BI "graphic.new(" "[width, height] [, background-color]" )
Creates a new graphic (a canvas).
.IP
When 
.IR width " and " height
are not given it uses the whole window/screen.
.br
A thin black pen is chosen and the position is centered, heading to
the top.
.br
If the
.I "background-color"
is not given, it is imported from AKFAvatar.
.IP
Retuns the graphic, the width and the height (ie. three values).
.IP
Use it like this:
.EX
local gr, width, height = graphic.new()
.EE
.PP
.TP
.B "graphic.fullsize()"
Returns the width and height for a graphic so that it fills the whole window.
.PP
.TP
.BI "graphic.set_resize_key(" key )
Sets a key-code (as number) which should be returned when the window gets resized.
Returns the previous key-code.
.IP
.B Hint:
Use something between 0xE000 and 0xE9FF to avoid conflicting
with real key-codes.
.PP
.TP
.BI "graphic.set_pointer_buttons_key(" key )
Sets a key-code (as number) which should be returned when any mouse button is
pressed.
Returns the previous key-code.
.IP
.B Hint:
Use something between 0xE000 and 0xE9FF to avoid conflicting
with real key-codes.
.PP
.TP
.BI "graphic.set_pointer_motion_key(" key )
Sets a key-code (as number) which should be returned when the mouse is moved.
Returns the previous key-code.
.PP
.TP
.B "graphic.get_pointer_position()"
Returns the x and y coordinates of the current mouse position,
relative to the last shown graphic.
.PP
.TP
.IB gr :show()
Shows the graphic as image after drawing.
.IP
.BR Hint :
You can show intermediate images, continue drawing, wait a while
and then show the next step and so on.
This makes a nice animation.
But don't make the steps too small, or it will be painful on slow devices.
.PP
.TP
.IB gr :size()
Returns the width and the height of the graphic
.IR gr .
.PP
.TP
.IB gr :width()
Returns the width of the graphic
.IR gr .
.PP
.TP
.IB gr :height()
Returns the height of the graphic
.IR gr .
.PP
.TP
.IB gr :color( color )
Sets the drawing
.IR color .
.br
The color can be either a defined color name,
or a hexadecimal representation, like for example
.IR  0xFFFF00 " or " "\[dq]#FFFF00\[dq]" .
.PP
.TP
.IB gr :rgb( "red, green, blue" )
Sets the drawing color from RGB values.
.br
The values must be in the range from 0 to 255 inclusive.
.br
This method is faster than using
.BR gr:color() .
.PP
.TP
.IB gr :eraser()
Sets the drawing color to the background color.
.PP
.TP
.IB gr :thickness( value )
Sets the thickness of the pen.
.br
The
.I value
1 is the thinnest.
.PP
.TP
.IB gr :clear( [color] )
Clears the graphic.
.br
If a
.I color
is given, then that becomes the new background color.
.br
The pen position is not changed.
.PP
.TP
.IB gr :border3d( "[pressed]" )
Draws 3d border around the graphic.
The color is based on the background color.
The setting for thickness is ignored, it is always the 3 pixels.
.IP
if
.I pressed
is
.B true
the border is presented as being pressed.
.IP
The pen position is not changed.
.PP
.TP
.IB gr :putpixel( "[x, y]" )
Puts a pixel at the given coordinates or at the current pen position.
.br
The pen position is not changed.
.PP
.TP
.IB gr :getpixel( "[x, y]" )
Gets the pixel color at the given coordinates or at the current pen position.
.br
The color is returned as string in the hexadecimal RGB notation.
.br
On error it returns
.I nil
and an error message.
.br
The pen position is not changed.
.PP
.TP
.IB gr :getpixelrgb( "[x, y]" )
Gets the pixel color at the given coordinates or at the current pen position.
.br
Returns three integers for red, green and blue, in the range of 0-255.
.br
On error it returns
.I nil
and an error message.
.br
The pen position is not changed.
.PP
.TP
.IB gr :putdot( "[x, y]" )
Puts a dot at the given coordinates or at the current pen position.
.br
If the pen is thin, it's the same as
.BR gr:putpixel .
.br
The pen position is not changed.
.PP
.TP
.IB gr :pen_position()
Returns the x and y position of the pen
(ie. returns two values).
.PP
.TP
.IB gr :center()
.TQ
.IB gr :home()
Sets the pen to the center of the graphic, heading to the top.
.PP
.TP
.IB gr :moveto( "x, y" )
Move the pen to
.I "x, y"
without drawing.
.PP
.TP
.IB gr :moverel( "x, y" )
Move the pen without drawing relative to its current position.
.br
A positive
.I x
value moves it to the right,
.br
a negative
.I x
value moves it to the left.
.br
A positive
.I y
value moves it down,
.br
a negative
.I y
value moves it up.
.PP
.TP
.IB gr :lineto( "x, y" )
Draws a line from the current pen position to these absolute coordinates.
.br
The pen is moved to the new coordinates.
.PP
.TP
.IB gr :linerel( "x, y" )
Draws a line relative to its current pen position.
.br
A positive
.I x
value draws to the right,
.br
a negative
.I x
value draws to the left.
.br
A positive
.I y
value draws down,
.br
a negative
.I y
value draws up.
.br
The pen is moved to the new position.
.PP
.TP
.IB gr :line( "x1, y1, x2, y2" )
Draws a line from
.IR "x1, y1" " to " "x2, y2" .
.br
The pen is set to
.IR "x2, y2" .
.PP
.TP
.IB gr :bar( "x1, y1, x2, y2" )
Draws a solid bar with
.I "x1, y1"
as the upper left corner and
.I "x2, y2"
as the lower right corner.
.br
The pen position is not changed.
.PP
.TP
.IB gr :rectangle( "x1, y1, x2, y2" )
Draws rectangle with
.I "x1, y1"
as the upper left corner and
.I "x2, y2"
as the lower right corner.
.br
The pen position is not changed.
.PP
.TP
.IB gr :arc( "radius [, angle1] [, angle2]" )
.TQ
.IB gr :circle( "radius [, angle1] [, angle2]" )
Draws a circle or an arc with the given
.IR radius .
.br
The pen position is the center.
.IP
You can draw a part of the circle (an arc) by giving one or two angles
in degree.
If two angles are given, then it draws clockwise from the first
angle to the second.
If just one angle is given, it uses the heading as
start-angle (see below under
.BR "turtle graphics" ).
.PP
.TP
.IB gr :disc( "radius [, x, y]" )
Draws a disc, ie. a filled circle with the given
.I radius
with the given coordinates as center.
If no coordinates are given, the current pen position is used as center.
.br
The pen position is not changed.
.PP
.TP
.IB gr :text( "text [, x, y]" )
Prints a text aligned to the given position or the pen position.
.IP
By default the text is centered to the position.
But you can change this with 
.BR "gr:textalign()" .
.IP
The encoding is used from the AKFAvatar settings.
However no other of those settings are taken into account.
The color is the drawing color for the graphic.
There is currently no easy way to make boldface, underlined or
inverted text.
.IP
You can use all printable characters, but control characters are not
supported, not even a newline.
.br
The pen position is not changed.
.PP
.TP
.IB gr :textalign( "[horizontal] [, vertical]" )
Sets the textalignment for
.BR "gr:text()" .
.IP
The horizontal alignment can be one of "left", "center" or "right".
The default is "center".
.IP
The vertical alignment can be one of "top", "center" or "bottom".
The default is "center".
.IP
The alignment means, where the given point is, eg. when you tell it to be
"left"-aligned, the fixed point is on the left, but the text runs to the
right.
.PP
.TP
.B graphic.font_size()
.TQ
.IB gr :font_size()
Returns the width, height and the baseline of the font, ie. one character.
It is a fixed-width font, each character has the same width.
.PP
.TP
.IB gr :put( "graphic [, x, y]" )
Puts a graphic onto graphic
.I gr
at the given position (upper-left corner).
If no position is given it puts it at the upper-left corner.
The previous content is overwritten (no transparency supported).
.IP
Copying a graphic with the same size and no position is highly efficient.
The same is true for a graphic with the same width and
.I x
set to 1.
.PP
.TP
.IB gr :put_transparency( "graphic [, x, y]" )
Puts a graphic onto graphic
.I gr
at the given position (upper-left corner).
.br
If no position is given it puts it at the upper-left corner.
.br
Pixels with the background color are not copied, they are transparent.
.br
This is much slower than
.BR "gr:put()" .
.PP
.TP
.IB gr :put_file( "filename [, x, y]" )
Puts a graphic from a file onto graphic
.I gr
at the given position (upper-left corner).
.br
If no position is given it puts it at the upper-left corner.
.PP
.TP
.IB gr :put_image( "data [, x, y]" )
Puts a graphic from
.I data
onto graphic
.I gr
at the given position (upper-left corner).
The
.I data
can be a string with image-data
or a table with strings from XPM data.
.br
If no position is given it puts it at the upper-left corner.
.PP
.TP
.IB gr :get( "x1, y1, x2, y2" )
Returns an area of the graphic
.I gr
as a new graphic.
.br
Most settings are copied, except the size and the pen settings.
.br
The pen is put in the center, heading to the top.
.br
All values must be in range.
.PP
.TP
.IB gr :duplicate()
Returns an exact duplicate (a copy) of the graphic
.IR gr .
.br
The graphic-specific settings are copied, too.
.br
This is faster than using
.BR gr:get() .
.IP
You can use this for example to create a fixed background and then make a
duplicate and draw the foreground on it.
Then you can
.B gr:put()
the background graphic back to the duplicate and draw another foreground.
.PP
.TP
.IB gr :shift_vertically( lines )
Shifts the graphic vertically.
.br
A positive value for
.I lines
shifts it down.
.br
A negative value for
.I lines
shifts it up.
.br
The pen gets also moved.
.PP
.TP
.IB gr :shift_horizontally( columns )
Shifts the graphic horizontally.
.br
A positive value for
.I columns
shifts it right.
.br
A negative value for
.I columns
shifts it left.
.br
The pen gets also moved.
.PP
.TP
.IB gr :export_ppm( filename )
Exports the graphic as Portable Pixmap (PPM) file.
.IP
The PPM format is simple to implement, but not very efficient.
You might want to use the "netpbm" tools or "ImageMagick" to convert
it to another format.
.IP
The following example shows how to do this:
.IP
.EX
function export(graphic, name)
  graphic:export_ppm(name..".ppm")
  if os.execute("pnmtopng "..name..".ppm > "..name..".png")
     or os.execute("convert "..name..".ppm "..name..".png") then
    os.remove(name..".ppm")
  end
end
.EE
.IP
First it exports the graphic in the PPM format.
Then it tries to convert it to the PNG format.
If that succeeds, it deletes the PPM file.
If the user doesn't have "netpbm" or "ImageMagick" installed, he still ends
up with the PPM file.
.PP
.SS Turtle graphics
.PP
To understand turtle graphics think of a turtle that carries a pen.
You can control the turtle by telling her in which direction to turn
and how far to move.
.PP
.TP
.IB gr :heading( heading )
Sets the heading for the turtle.
The value must be given in degree and the turtle turns clockwise.
The value 0 means, it's heading to the top,
90 means it heads to the right.
.PP
.TP
.IB gr :get_heading()
Returns the heading of the turtle
(see
.BR "gr:heading()" ).
.PP
.TP
.IB gr :right( angle )
Turn the turtle clockwise by the specified
.I angle
in degree.
.PP
.TP
.IB gr :left( angle )
Turn the turtle counterclockwise by the specified
.I angle
in degree.
.PP
.TP
.IB gr :draw( steps )
Draw a line in the direction the turtle is heading.
.PP
.TP
.IB gr :move( steps )
Move the turtle in the direction it is heading without drawing.
.PP
.TP
.IB gr :home()
Sets the pen to the center of the graphic, heading to the top.
.PP
.SH "SEE ALSO"
.BR lua-akfavatar (1)
.BR lua (1)
.BR lua-akfavatar-ref (3)
.BR akfavatar-term (3)
.BR akfavatar.utf8 (3)
