/***************************************************************************
                                Aldo
                          --------------------
    begin                : Sun May 6 2001
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *                                                                         *
 ***************************************************************************/

#include "resources.h"

#include "classic.h"
#include "keyer.h"
#include "datafile.h"
#include "dialog.h"

#include <iostream>
#include <string>
#include <unistd.h>

using namespace std;

unsigned int check(const libexercises::Classic &);
string skillname(unsigned int);

void OnKoch()
{
    string fileconf_name(getenv("HOME"));
    fileconf_name += "/.aldorc";
    
    libdatafile::Datafile fileconf(fileconf_name, libdatafile::Read);  //read config from datafile ~/.aldorc
    
    libdatafile::sec_it main_sec = fileconf.section("Main");
    string device = main_sec->option("Device")->getstr();
    unsigned int samplerate = main_sec->option("SampleRate")->get();
    unsigned int samplesize = main_sec->option("SampleSize")->get();
    
    libdatafile::sec_it keyer_sec = fileconf.section("Keyer");
    unsigned int beginpause = keyer_sec->option("BeginPause")->get();
    unsigned int charpause = keyer_sec->option("CharPause")->get();	
    unsigned int strpause = keyer_sec->option("StringPause")->get();
    unsigned int dotlen = keyer_sec->option("DotLength")->get();
    unsigned int linelen = keyer_sec->option("LineLength")->get();
    unsigned int tone = keyer_sec->option("Tone")->get();
    
    libdatafile::sec_it koch_sec = fileconf.section("Koch");
    unsigned int startspeed = koch_sec->option("StartSpeed")->get();
    
    unsigned int str_length = 2;
    unsigned int skill = libexercises::skill1;
    unsigned int num_strings = 15;
    
    Dialog<bool> ask_exit_koch(dlg_koch_title, main_menu_prompt);
    ask_exit_koch.add_choice(dlg_koch_exit, false);
    ask_exit_koch.add_choice(dlg_koch_continue, true);
    
    do
    {
	cout<<msg_skill<<skillname(skill)<<endl;
	cout<<msg_speed<<startspeed<<" wpm"<<endl;
	cout<<msg_start<<endl;	
	
	libaudiostream::oastream audio(device, samplerate, samplesize);

	libkeyer::Keyer current_keyer(audio, startspeed, charpause, strpause, dotlen, linelen);
	current_keyer.set_tone(tone);

	libexercises::Classic current_classic(num_strings, skill, str_length);
		
	sleep(beginpause);
	
	current_keyer<<current_classic;
	
	sleep(beginpause);

	if( check(current_classic) >= 90)
	    if(skill & 0x1F)
	    {
		skill = (skill<<1) + 1;
		str_length++;
	    }
	    else
		startspeed++;
    }
    while(ask_exit_koch.show());
}
