/***************************************************************************
                                Aldo
                          --------------------
    begin                : Sun May 6 2001
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *                                                                         *
 ***************************************************************************/

#include "resources.h"

#include "menu.h"
#include "dialog.h"
#include "datafile.h"
#include "skill.h"

#include <iostream>
#include <string>
#include <cstdlib>

using namespace std;
using namespace libmenu;

void OnScConf() // Soundcard config
{
    std::string device;
    unsigned int samplerate;
    unsigned int samplesize;

    std::cout<<insert_device;
    std::cin>>device;
    
    std::cout<<insert_samplerate;
    std::cin>>samplerate;

    std::cout<<insert_samplesize;
    std::cin>>samplesize;

    std::string fileconf_name(getenv("HOME"));
    fileconf_name += "/.aldorc";
    
    libdatafile::Datafile fileconf(fileconf_name, libdatafile::Update);
    
    libdatafile::sec_it main_sec = fileconf.section("Main");
    
    main_sec->option("Device")->set(device);
    main_sec->option("SampleRate")->set(samplerate);
    main_sec->option("SampleSize")->set(samplesize);
}    

void OnKeyerConf()
{
    std::string fileconf_name(getenv("HOME"));
    fileconf_name += "/.aldorc";

    libdatafile::Datafile fileconf(fileconf_name, libdatafile::Update);
	
    libdatafile::sec_it keyer_sec = fileconf.section("Keyer");

    unsigned int tmp;

    std::cout<<insert_beginpause;
    std::cin>>tmp;
    keyer_sec->option("BeginPause")->set(tmp);

    std::cout<<insert_charpause;
    std::cin>>tmp;
    keyer_sec->option("CharPause")->set(tmp);

    std::cout<<insert_strpause;
    std::cin>>tmp;
    keyer_sec->option("StringPause")->set(tmp);

    std::cout<<insert_wpm;
    std::cin >> tmp; 
    keyer_sec->option("Speed")->set(tmp);    

    std::cout<<insert_dotlen;
    std::cin>>tmp;
    keyer_sec->option("DotLength")->set(tmp);

    std::cout<<insert_linelen;
    std::cin>>tmp;
    keyer_sec->option("LineLength")->set(tmp);
    
    std::cout<<insert_tone;
    std::cin>>tmp;
    keyer_sec->option("Tone")->set(tmp);     
}

void OnClassicConf()
{
    std::string fileconf_name(getenv("HOME"));
    fileconf_name += "/.aldorc";
    
    libdatafile::Datafile fileconf(fileconf_name, libdatafile::Update);
    
    libdatafile::sec_it classic_sec = fileconf.section("Classic");
	
    unsigned int tmp;

    std::cout<< insert_strlen;
    std::cin >> tmp;
    classic_sec->option("StringLength")->set(tmp);

    std::cout << insert_strnum;
    std::cin >> tmp;
    classic_sec->option("StringsNumber")->set(tmp);

    Dialog<unsigned int> ask_skill(dlg_skill_title, main_menu_prompt);
    ask_skill.add_choice(dlg_skill_choice1,libexercises::skill1);
    ask_skill.add_choice(dlg_skill_choice2,libexercises::skill2);
    ask_skill.add_choice(dlg_skill_choice3,libexercises::skill3);
    ask_skill.add_choice(dlg_skill_choice4,libexercises::skill4);
    ask_skill.add_choice(dlg_skill_choice5,libexercises::skill5);
    ask_skill.add_choice(dlg_skill_choice6,libexercises::skill6);
    ask_skill.add_choice(dlg_skill_choice7,0);

    unsigned int skill = ask_skill.show();

    if(skill == 0)
	while(true)
	{
	    Dialog<unsigned int> ask_skill2(dlg_skill2_title, main_menu_prompt);

	    ask_skill2.add_choice(dlg_skill2_choice1,libexercises::chars1);
	    ask_skill2.add_choice(dlg_skill2_choice2,libexercises::chars2);
	    ask_skill2.add_choice(dlg_skill2_choice3,libexercises::chars3);
	    ask_skill2.add_choice(dlg_skill2_choice4,libexercises::chars4);
	    ask_skill2.add_choice(dlg_skill2_choice5,libexercises::chars5);
	    ask_skill2.add_choice(dlg_skill2_choice6,libexercises::numbrs);
	    ask_skill2.add_choice(dlg_skill2_choice7,0x1000);
	    ask_skill2.add_choice(dlg_skill2_choice8,libexercises::submixed);
	    ask_skill2.add_choice(dlg_skill2_choice9,libexercises::mixed);
	    ask_skill2.add_choice(dlg_skill2_choice10,0);
	    
	    unsigned int skill2 = ask_skill2.show();
	    
	    if(skill2 != 0 && skill2 != 0x1000)
		skill |= skill2;

	    if(skill2 == 0)
		break;
	}
      
    classic_sec->option("Skill")->set(skill);
} 

void OnResetDefault()
{
    std::string home(getenv("HOME"));

    std::string fileconf_name(getenv("HOME"));
    fileconf_name += "/.aldorc";
    
    libdatafile::Datafile fileconf(fileconf_name, libdatafile::Create);
    
    fileconf.add_section("Main");
    libdatafile::sec_it main_sec = fileconf.section("Main");

    main_sec->add_option("Device");
    main_sec->option("Device")->set("/dev/dsp");

    main_sec->add_option("SampleRate");
    main_sec->option("SampleRate")->set(8000);
    
    main_sec->add_option("SampleSize");
    main_sec->option("SampleSize")->set(8);

    fileconf.add_section("Keyer");
    libdatafile::sec_it keyer_sec = fileconf.section("Keyer");
    
    keyer_sec->add_option("BeginPause");
    keyer_sec->option("BeginPause")->set(2);
	
    keyer_sec->add_option("Speed");
    keyer_sec->option("Speed")->set(10);

    keyer_sec->add_option("CharPause");
    keyer_sec->option("CharPause") ->set(3);
	
    keyer_sec->add_option("StringPause");
    keyer_sec->option("StringPause")->set(7);

    keyer_sec->add_option("DotLength");
    keyer_sec->option("DotLength")->set(1);
	
    keyer_sec->add_option("LineLength");
    keyer_sec->option("LineLength")->set(3);

    keyer_sec->add_option("Tone");
    keyer_sec->option("Tone")->set(900);

    fileconf.add_section("Classic");
    libdatafile::sec_it classic_sec = fileconf.section("Classic");
    
    classic_sec->add_option("StringLength");
    classic_sec->option("StringLength")->set(5);
	
    classic_sec->add_option("StringsNumber");
    classic_sec->option("StringsNumber")->set(3);

    classic_sec->add_option("Skill");
    classic_sec->option("Skill")->set(libexercises::skill1);
	
    fileconf.add_section("Koch");
    libdatafile::sec_it koch_sec = fileconf.section("Koch");
	
    koch_sec->add_option("StartSpeed");
    koch_sec->option("StartSpeed")->set(20);

    fileconf.add_section("Qrz");
    libdatafile::sec_it qrz_sec = fileconf.section("Qrz");
    
    qrz_sec->add_option("CallFormat");
    qrz_sec->option("CallFormat")->set("@@@@@");
    qrz_sec->add_option("StringsNumber");
    qrz_sec->option("StringsNumber")->set(3);
}

void OnKochConf()
{
    unsigned int startspeed;
    std::cout<<insert_wpm;
    std::cin>>startspeed;

    std::string fileconf_name(getenv("HOME"));
    fileconf_name += "/.aldorc";
    
    libdatafile::Datafile fileconf(fileconf_name, libdatafile::Update);
    
    libdatafile::sec_it koch_sec = fileconf.section("Koch");

    koch_sec->option("StartSpeed")->set(startspeed);
}

void OnQrzConf()
{
    std::string callformat;
    std::cout<<insert_callformat;
    std::cin>>callformat;

    unsigned int strnum;
    std::cout<<insert_strnum;
    std::cin>>strnum;

    std::string fileconf_name(getenv("HOME"));
    fileconf_name += "/.aldorc";
    
    libdatafile::Datafile fileconf(fileconf_name, libdatafile::Update);
    
    libdatafile::sec_it qrz_sec = fileconf.section("Qrz");
    
    qrz_sec->option("CallFormat")->set(callformat);
    qrz_sec->option("StringsNumber")->set(strnum);
}

void OnExitSetup(Menu& main)
{
    main.close();
}

void OnSetup()
{

    Menu setup_menu(conf_menu_title, main_menu_prompt);
   
    const id_type scconf_id = 1;
    const id_type keyconf_id  = 2;
    const id_type clasconf_id = 3;
    const id_type kochconf_id = 4;
    const id_type qrzconf_id = 5;
    const id_type rstdfl_id = 6;
    const id_type exit_id = 7;
    
    setup_menu.add_item(scconf_id,    conf_menu_item1, OnScConf);
    setup_menu.add_item(keyconf_id,   conf_menu_item2, OnKeyerConf);
    setup_menu.add_item(clasconf_id,  conf_menu_item3, OnClassicConf);
    setup_menu.add_item(kochconf_id,  conf_menu_item4, OnKochConf);
    setup_menu.add_item(qrzconf_id,   conf_menu_item5, OnQrzConf);
    setup_menu.add_item(rstdfl_id,    conf_menu_item6, OnResetDefault);
    setup_menu.add_item(exit_id,      conf_menu_item7, OnExitSetup);

    while( setup_menu.running() )
    {
	try
	{
	    setup_menu.show();
	}
	catch(libdatafile::Not_datafile_format e)
	{
	    cerr<<errmsg_noformat<<endl;
	    cerr<<errmsg_conf<<endl;
	    return;
	}
	catch(libdatafile::Over_write_file e)
	{
	    cerr<<errmsg_overwrite<<endl;
	    cerr<<errmsg_conf<<endl;
	    return;
	}
	catch(libdatafile::Option_not_found e)
	{
	    cerr<<errmsg_nooption<<endl;
	    cerr<<errmsg_conf<<endl;
	    return;
	}
	catch(libdatafile::Section_not_found e)
	{
	    cerr<<errmsg_nosection<<endl;
	    cerr<<errmsg_conf<<endl;
	    return;
	}
	catch(libdatafile::File_not_opened e)
	{
	    cerr<<errmsg_noopenfile<<endl;
	    cerr<<errmsg_conf<<endl;
	    return;
	}
	catch(libdatafile::File_not_exist e)
	{
	    cerr<<errmsg_nofile<<endl;
	    cerr<<errmsg_conf<<endl;
	    return;
	}
    }
}
