/***************************************************************************
                          libexercises part of Aldo
                          ---------------------
    begin                : Sun May 6 2001
    copyright             : Giuseppe "denever" Martino
    improved             : Bob Harrington
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,             *
 *  MA 02110-1301 USA                                                      *
 *                                                                         *
 ***************************************************************************/

#include "koch.hh"
#include "random.hh"

#include <iostream>

using namespace std;
using namespace libexercises;

// give a random string from input
string Koch::randstring(string input, unsigned int num)
{
    unsigned int size = input.size();

    librandom::Random RND;

    string output;
    output.clear();

    while(num!=0)
    {
	unsigned int pos = RND.integer(0, size-1);
        output += input[pos];
        num--;
    }

    return output;
}

Koch::Koch(string str, unsigned int num, unsigned int numch, unsigned int s): 
    m_chars(str), m_num_chars(numch), m_num_strings(num), m_skill(s)
{
    m_strings = randstring(m_chars.substr(0, m_skill), m_num_chars * m_num_strings);
}

Koch::Koch(const Koch& cpy)
{
    m_strings = cpy.m_strings;
}

Koch::~Koch()
{
    m_strings.clear();
}

libkeyer::Keyer& libexercises::operator<<(libkeyer::Keyer& out, const Koch& exc)
{
    unsigned int strlen = exc.string_len();

    for(unsigned int i=0; i< exc.len(); i++)
	out << exc.get_string().substr(i* strlen, strlen);

    return out;		
}

unsigned int Koch::verify(const std::string& catched) const
{
    double wrong_letters=0.0;
    
    if(catched.size() == m_strings.size())
    {
      	if(catched != m_strings)
	    for(unsigned int i=0; i<m_num_chars*m_num_strings; i++)
	    {
		if(catched[i] != m_strings[i])
		    wrong_letters++;
	    }
    }
    else
	return 0;
    
    double total = m_num_chars * m_num_strings;
    double catched_tax = wrong_letters/total;
    
    return int(100 - 100 * catched_tax); // return percentual of catched letters
}

void Koch::next()
{
    m_num_chars++;
    m_num_strings++;
    m_skill++;
    
    m_strings = randstring(m_chars.substr(0, m_skill), m_num_chars * m_num_strings);
}
