/*
 * definitions for runtime session specific data handling
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

#ifndef _ANT_RUNTIME_H
#define _ANT_RUNTIME_H

/* regular GNU system includes */
#include <termios.h>

/* GTK */
#include <gtk/gtk.h>

enum state_t {
  STATE_READY,
  STATE_RINGING,
  STATE_DIALING,
  STATE_CONVERSATION
};

extern char *state_data[];

/*
 * session data
 */
struct session_t {
  /* audio device data */
  char *audio_device_name_in; /* allocated memory! */
  char *audio_device_name_out; /* allocated memory! */
  int audio_fd_in;        /* audio device file descriptors */
  int audio_fd_out;
  int audio_speed_in;     /* sound device recording speed */
  int audio_speed_out;    /* sound device playback speed */
  int fragment_size_in;   /* sound device buffer fragment sizes */
  int fragment_size_out;
  int *format_priorities; /* 0-terminated sorted list of preferenced formats */
  int audio_format_in;    /* the actual formats */
  int audio_format_out;
  int audio_sample_size_in; /* number of bytes of a sample */
  int audio_sample_size_out;
  unsigned char *audio_inbuf;
  unsigned char *audio_outbuf;
  int audio_outbuf_index;   /* needed for conversation mode output memory */

  /* isdn data */
  char* isdn_device_name; /* "/dev/ttyIxx", xx == 0 .. 63 */
  int isdn_fd;
  char* isdn_lockfile_name;
  int isdn_inbuf_size;
  int isdn_outbuf_size;
  unsigned char *isdn_inbuf;   /* 8 bit ulaw */
  unsigned char *isdn_outbuf;
  int isdn_inbuf_len;      /* index of '\0' in audio_inbuf in command mode,
			       if char at this index != 0 -> reading line */
  int isdn_outbuf_index;   /* needed for conversation mode output memory */
  int escape; /* escape mode/state RECEIVING isdn data */
  int no_input; /* after this many select calls without isdn input
                   get back from blockmode */
  struct termios isdn_backup; /* saved state to restore on exit */

  /* mediation data */
  /* Look-up-tables for audio <-> isdn conversion: */
  unsigned char *audio_LUT_in;  /* isdn -> audio */
  unsigned char *audio_LUT_out; /* audio -> isdn */
  double ratio_in;        /* ratio: audio output rate / isdn input rate */
  double ratio_out;       /* ratio: isdn output rate / audio input rate */
  unsigned int samples_in;     /* ring counter of samples: from isdn */
  unsigned int samples_out;    /* ...                ... : from sound device */

  /* GUI elements in this session (GTK specific) */
  GtkWidget *pick_up_button; /* the pick up button to enable / disable */
  GtkWidget *pick_up_label;  /* the label on the pick up button */
  GtkWidget *hang_up_button; /* the hang up button to enable / disable */
  GtkWidget *hang_up_label;  /* the label on the hang up button */
  GtkWidget *dial_number_entry; /* the dial number entry */
  GtkWidget *status_bar; /* the status bar */
  gint phone_context_id; /* a context for the status bar */

  gint gdk_isdn_input_tag; /* these tags are saved to later remove handlers */
  gint gdk_audio_input_tag;
  
  /* phone specific */
  enum state_t state; /* which state we are currently in */
  int hangup; /* remote hangup */
  int aborted; /* i/o error (isdn or audio) */

  char* msn;  /* originating msn, allocated memory! */
  char* msns; /* comma-separated list of msns to listen on, allocated memory!*/
};

extern struct session_t session;

void session_set_state(struct session_t *session, enum state_t state);

void session_io_handlers_start(struct session_t *session);
void session_io_handlers_stop(struct session_t *session);
int init_session(struct session_t *session,
		 char *audio_device_name_in,
		 char *audio_device_name_out,
		 char *msn, char *msns);
int deinit_session(struct session_t *session);

void gdk_handle_isdn_input(gpointer data, gint fd,
			   GdkInputCondition condition);
void gdk_handle_audio_input(gpointer data, gint fd,
			   GdkInputCondition condition);
void gtk_handle_pick_up_button(GtkWidget *widget, gpointer data);
void gtk_handle_hang_up_button(GtkWidget *widget, gpointer data);

#endif /* runtime.h */
