/*
 * OSS sound handling functions
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

#include <sys/soundcard.h>

#define DEFAULT_FRAGMENT_SIZE 1024
#define DEFAULT_AUDIO_DEVICE_NAME_IN "/dev/dsp"
#define DEFAULT_AUDIO_DEVICE_NAME_OUT "/dev/dsp"
extern int default_audio_priorities[];

int init_audio_device(int audio_fd, int format, int channels, int *speed,
		      int *fragment_size);
int open_audio_devices(char *in_audio_device_name,
		       char *out_audio_device_name,
		       int channels, int *format_priorities,
		       int *audio_fd_in, int *audio_fd_out,
		       int *fragment_size_in, int *fragment_size_out,
		       int *format_in, int *format_out,
		       int *speed_in, int *speed_out);
int close_audio_devices(int audio_fd_in, int audio_fd_out);
int audio_stop(int audio_fd_in, int audio_fd_out);
int sample_size_from_format(int format);
