/*
 * miscellaneous glibc extending functions
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

#include <sys/time.h>
#include <time.h>

#include "util.h"

/* util.h will be included everywhere needed so the right place is here */
int debug = 0;

/* Subtract the `struct timeval' values X and Y,
 *    storing the result in RESULT.
 *    Return 1 if the difference is negative, otherwise 0.
 */
int timeval_subtract (struct timeval *result,
		      struct timeval *x,
		      struct timeval *y) {
    /* Perform the carry for the later subtraction by updating y. */
    if (x->tv_usec < y->tv_usec) {
      int nsec = (y->tv_usec - x->tv_usec) / 1000000 + 1;
      y->tv_usec -= 1000000 * nsec;
      y->tv_sec += nsec;
    }
    if (x->tv_usec - y->tv_usec > 1000000) {
      int nsec = (x->tv_usec - y->tv_usec) / 1000000;
      y->tv_usec += 1000000 * nsec;
      y->tv_sec -= nsec;
    }

    /* Compute the time remaining to wait.
       tv_usec is certainly positive. */
    result->tv_sec = x->tv_sec - y->tv_sec;
    result->tv_usec = x->tv_usec - y->tv_usec;

    /* Return 1 if result is negative. */
    return x->tv_sec < y->tv_sec;
}

/* sleeps usecs microseconds (will be interrupted by signals) */
void ant_sleep(int usecs) {
  struct timespec requested;
  struct timespec remaining;

  requested.tv_sec = 0;
  requested.tv_nsec = usecs * 1000;
  nanosleep(&requested, &remaining);
}

/*
 * convert vanity number (case insensitive: 'b','B' -> '2') in-place
 */
char *un_vanity(char *s) {
  char *temp = s;

  while (*temp) {
    switch (*temp) {
    case 'a': case 'b': case 'c': case 'A': case 'B': case 'C':
      *temp = '2';
      break;
    case 'd': case 'e': case 'f': case 'D': case 'E': case 'F':
      *temp = '3';
      break;
    case 'g': case 'h': case 'i': case 'G': case 'H': case 'I':
      *temp = '4';
      break;
    case 'j': case 'k': case 'l': case 'J': case 'K': case 'L':
      *temp = '5';
      break;
    case 'm': case 'n': case 'o': case 'M': case 'N': case 'O':
      *temp = '6';
      break;
    case 'p': case 'q': case 'r': case 's':
    case 'P': case 'Q': case 'R': case 'S':
      *temp = '7';
      break;
    case 't': case 'u': case 'v': case 'T': case 'U': case 'V':
      *temp = '8';
      break;
    case 'w': case 'x': case 'y': case 'z':
    case 'W': case 'X': case 'Y': case 'Z':
      *temp = '9';
      break;
    }
    temp++;
  }

  return s;
}
