/*
 *
 *  ANT (ANT is Not a Telephone)
 *  Copyright 2002 Roland Stigge
 *
 *  ISDN Telephone application for Linux and OSS
 *  (full duplex or multiple sound devices needed)
 *
 *  Author: Roland Stigge, stigge@epost.de
 *  Created: 2002-09-04  (got the idea already around christmas 2000)
 *
 *  Tested with: Debian GNU/Linux (kernel 2.4.18)
 *
 *
 *  Some basic ideas for this program are based on:
 *    * IVCALL, Copyright 2000 Lennart Poettering <lennart@poettering.de> (GPL)
 *
 *  This program uses sources from:
 *    * g711.c (by Sun Microsystems, BSD like license) from SoX
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "config.h"

/* regular GNU system includes */
#include <stdio.h>
#ifdef HAVE_STDLIB_H
  #include <stdlib.h>
#endif
#ifdef HAVE_STDDEF_H
  #include <stddef.h>
#endif
#include <string.h>
#include <math.h>
#include <errno.h>
#ifdef HAVE_UNISTD_H
  #include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
  #include <sys/types.h>
#endif
#ifdef HAVE_TERMIOS_H
  #include <termios.h>
#endif
#ifdef HAVE_FCNTL_H
  #include <fcntl.h>
#endif
#include <sys/ioctl.h>
#ifdef HAVE_LIMITS_H
  #include <limits.h>
#endif
#include <sys/time.h>
#include <getopt.h> /* GNU extension: long options */

/* For debugging purposes */
#include <mcheck.h>

/* own header files */
#include "isdn.h"
#include "sound.h"
#include "mediation.h"
#include "gtk.h"
#include "session.h"
#include "util.h"

int main(int argc, char *argv[]) {
  struct option long_options[] = {
    {"help",     no_argument,       0, 'h'},
    {"usage",    no_argument,       0, 'h'},
    {"version",  no_argument,       0, 'v'},
    {"debug",    optional_argument, 0, 'd'},
    {"soundin",  required_argument, 0, 'i'},
    {"soundout", required_argument, 0, 'o'},
    {"msn",      required_argument, 0, 'm'},
    {"msns",     required_argument, 0, 'l'},
    {0, 0, 0, 0}
  };
  char *short_options = "hvd::i:o:m:l:";
  int option_index = 0;
  int c;

  /* temporary default values = "", will be changed by command line options
     and options in options file */
  char *audio_device_name_in = "";
  char *audio_device_name_out = "";
  char *msn = "";
  char *msns = "";

  int gtk_result;

#ifdef DEBUG
  mtrace();
  debug = DEBUG;
#endif

  /* first: GTK+ internal parsing of command line arguments */
  gtk_init(&argc, &argv);

  /* parse command line options */
  while ((c = getopt_long(argc, argv, short_options, long_options,
			  &option_index)) != -1) {
    switch(c) {
    case 'h': /* help */
      printf("Usage: %s [OPTION...]\n\
\n\
Options:\n\
  -h, --help              Show this help message\n\
  -v, --version           Print version information\n\
  -d, --debug[=level]     Print additional runtime debugging data to stdout\n\
                            level = 1..2\n\
  -i, --soundin[=device]  OSS compatible device for input (recording),\n\
                            default: /dev/dsp\n\
  -o, --soundout[=device] OSS compatible device for output (playback),\n\
                            default: /dev/dsp\n\
  -m, --msn               identifying MSN (for outgoing calls), 0 for master\n\
                          MSN of this termination/port\n\
                            default: 0\n\
  -l, --msns              MSNs to listen on, semicolon-separated list or '*'\n\
                            default: *\n\
\n\
Note: If arguments of --soundin and --soundout are equal, a full duplex\n\
      sound device is needed.\n", argv[0]);
      exit(0);
    case 'v': /* version */
      printf("ANT " VERSION "\n");
      exit(0);
    case 'd': /* debug mode */
      if (optarg) {
	debug = strtol(optarg, NULL, 0);
      } else {
	debug = 1;
      }
      break;
    case 'i': /* sound input device */
      audio_device_name_in = optarg;
      break;
    case 'o': /* sound output device */
      audio_device_name_out = optarg;
      break;
    case 'm': /* identifying msn */
      msn = optarg;
      break;
    case 'l': /* msns to listen on, '*' or semicolon-separated list */
      msns = optarg;
      break;
    case '?':
      exit(1);
    }
  }
  /* no further arguments expected, so not handled */
  
  if (session_init(&session, audio_device_name_in, audio_device_name_out,
		   msn, msns)) {
    fprintf(stderr, "Error at session init.\n");
    exit(1);
  } else {
    if (debug)
      fprintf(stderr, "Init OK.\n");
  }
      
  /* gtk stuff, main loop */
  gtk_result = main_gtk(&session);

  if (session_deinit(&session)) {
    fprintf(stderr, "Error at session exit\n");
    exit(1);
  } else {
    if (debug)
      fprintf(stderr, "Quit OK.\n");
  }

  return gtk_result;
}
