%option prefix="callerid_"
%{
/*
 * saved caller id file lexer
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

/* redefine symbols to allow multiple parsers in same executable */
#include "calleridredefines.h"

#define YYSTYPE char *
#define YYLTYPE int

/* suppress warnings */
#define YY_NO_UNPUT

#include <string.h>
#include "calleridparser.h"
extern YYLTYPE yylloc;
%}

LETTER    [a-zA-Z]
DIGIT     [0-9]
NOEM      {LETTER}|{DIGIT}|[-:)(*#]

%%

"|"|!!                         return CID_TOKEN_DELIMITER;
{DIGIT}+-{DIGIT}+-{DIGIT}+" "{DIGIT}+:{DIGIT}+:{DIGIT}+ {
                                 yylval = strdup(yytext);
                                 return CID_TOKEN_DATE;
                               }
IN|OUT                         yylval = strdup(yytext);return CID_TOKEN_TYPE;
({DIGIT}|[*#A-D])+             yylval = strdup(yytext);return CID_TOKEN_NUMBER;
(!?{NOEM}+)+!?                 yylval = strdup(yytext);return CID_TOKEN_MSG;

\n                             ++yylloc; return *yytext;
.                              /* eat up rest (handled as white space) */

%%

/* For portability's sake */
int yywrap() { return 1; }