/*
 * caller id related functions
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002, 2003 Roland Stigge
 *
 */

/* GTK */
#include <gtk/gtk.h>

/* own header files */
#include "session.h"

enum call_type_t {
  CALL_IN,
  CALL_OUT
};

void cid_toggle_cb(GtkWidget *widget, gpointer data, guint action);
GtkWidget *cid_new(struct session_t *session);
void cid_add_line(struct session_t *session,
		  enum call_type_t ct, gchar *from, gchar *to);
void cid_set_date(struct session_t *session, time_t date);
void cid_set_from(struct session_t *session, gchar *from);
void cid_set_duration(struct session_t *session, gchar *message);
void cid_jump_to_end(struct session_t *session);
void cid_normalize(struct session_t *session);
void cid_add_saved_line(struct session_t *session, char *date, char *type,
			char *from, char *to, char *duration);
void cid_calls_merge(struct session_t *session);
void cid_mark_row(struct session_t *session, int row, int state);

