/*
 * ISDN handling functions
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002, 2003 Roland Stigge
 *
 */

#include "config.h"

#ifdef HAVE_TERMIOS_H
  #include <termios.h>
#endif

#define LOCK_PATH "/var/lock"

#define DEFAULT_ISDNBUF_SIZE 255
#define ISDN_COMMAND_TIMEOUT 1
#define ISDN_ISDNLOG_FILE "/var/lib/isdn/calls"

/* 0 (master MSN) or MSN to use as identification on outgoing calls */
#define DEFAULT_MSN "0"

/* "*" (wildcard) or comma-separated list of MSNs */
#define DEFAULT_MSNS "*"

#define ISDN_SPEED 8000

#define ETX 0x03
#define DC4 0x14
#define DLE 0x10

int open_isdn_device(char **isdn_device_name, char **isdn_lockfile_name);
int init_isdn_device(int isdn_fd, struct termios *backup);
int deinit_isdn_device(int isdn_fd, struct termios *backup);
int isdn_setMSN(int isdn_fd, char *msn);
int isdn_setMSNs(int isdn_fd, char *msns);
int isdn_stop_audio(int isdn_fd, int self_hangup);
int isdn_hangup(int isdn_fd);
int isdn_blockmode(int isdn_fd, int flag);
int close_isdn_device(int isdn_fd, char *isdn_device_name,
		      char *isdn_lockfile_name);
int isdn_dial(int isdn_fd, char *number, int timeout);
int isdn_set_full_duplex(int isdn_fd);
int tty_read(int fd, char *s, int timeout, char **got);
int tty_write(int fd, char *s);
int tty_clear(int fd);
