%option prefix="options_"
%{
/*
 * option file lexer
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002, 2003 Roland Stigge
 *
 */

/* redefine symbols to allow multiple parsers in same executable */
#include "optionsredefines.h"

#define YYSTYPE char *
#define YYLTYPE int

/* suppress warnings */
#define YY_NO_UNPUT

#include <string.h>
#include "optionsparser.h"
extern YYLTYPE yylloc;
%}

LETTER    [a-zA-Z]
DIGIT     [0-9]

/* exclusive start condition for C-style comments */
%x CCOMMENT
%%

"#".*                        /* eat up comments */
"//".*
"/*"                         BEGIN(CCOMMENT);
<CCOMMENT>\n                 ++yylloc;
<CCOMMENT>"*/"               BEGIN(INITIAL);
<CCOMMENT>.

{LETTER}({LETTER}|{DIGIT})*  yylval = strdup(yytext); return OPT_TOKEN_WORD;

{DIGIT}+                     yylval = strdup(yytext); return OPT_TOKEN_NUMBER;

"\""[^"]*"\""                { yylval = (char *)malloc(yyleng - 1);
                               strncpy(yylval, &yytext[1], yyleng - 2);
                               yylval[yyleng - 2] = '\0';
                               return OPT_TOKEN_STRING;
                             }

({LETTER}|{DIGIT}|[/+\-*;])+ yylval = strdup(yytext); return OPT_TOKEN_STRING;

"="                          return OPT_TOKEN_EQUALS;

\n                           ++yylloc; return *yytext;
.                            /* eat up rest */

%%

/* For portability's sake */
int yywrap() { return 1; }

