%option prefix="callerid_"
%{
/*
 * saved caller id file lexer
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002, 2003 Roland Stigge
 *
 * ANT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ANT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ANT; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* redefine symbols to allow multiple parsers in same executable */
#include "calleridredefines.h"

#define YYSTYPE char *
#define YYLTYPE int

/* suppress warnings */
#define YY_NO_UNPUT

#include <string.h>
#include "calleridparser.h"
extern YYLTYPE yylloc;
%}

LETTER    [a-zA-Z]
DIGIT     [0-9]
NOEM      {LETTER}|{DIGIT}|[-:)(*#]

%%

"|"|!!                         return CID_TOKEN_DELIMITER;
{DIGIT}+-{DIGIT}+-{DIGIT}+" "{DIGIT}+:{DIGIT}+:{DIGIT}+ {
                                 yylval = strdup(yytext);
                                 return CID_TOKEN_DATE;
                               }
IN|OUT                         yylval = strdup(yytext);return CID_TOKEN_TYPE;
({DIGIT}|[*#+?A-D])+           yylval = strdup(yytext);return CID_TOKEN_NUMBER;
(!?{NOEM}+)+!?                 yylval = strdup(yytext);return CID_TOKEN_MSG;

\n                             ++yylloc; return *yytext;
.                              /* eat up rest (handled as white space) */

%%

/* For portability's sake */
int yywrap() { return 1; }

