%{
/*
 * saved callerid file parser
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002, 2003 Roland Stigge
 *
 */

/* redefine symbols to allow multiple parsers in same executable */
#include "calleridredefines.h"

/* type for semantic values of symbols: malloc'ed strings */
#define YYSTYPE char *

/* location type: line number */
#define YYLTYPE int

/* default action for locations (when grammar rule actions "callback") */
#define YYLLOC_DEFAULT(Current, Rhs, N) ;

/* let yyparse() accept one argument of type void * */
#define YYPARSE_PARAM session

/* regular GNU system includes */
#include <stdio.h>
#include <stdlib.h>

/* own header files */
#include "globals.h"
#include "util.h"
#include "callerid.h"

int yylex (void);
void yyerror(const char *message);

/* line number */
YYLTYPE yylloc = 1;

%}

/* terminal symbols */
%token CID_TOKEN_DATE
%token CID_TOKEN_TYPE
%token CID_TOKEN_NUMBER
%token CID_TOKEN_MSG
%token CID_TOKEN_DELIMITER

%%
settings   :
           | settings line
;

line       : '\n'
           | CID_TOKEN_DATE CID_TOKEN_DELIMITER
             CID_TOKEN_TYPE CID_TOKEN_DELIMITER
             CID_TOKEN_NUMBER CID_TOKEN_DELIMITER
             CID_TOKEN_NUMBER CID_TOKEN_DELIMITER
             CID_TOKEN_MSG '\n'
               { cid_add_saved_line(session, $1, $3, $5, $7, $9);
	         free($1); free($3); free($5); free($7); free($9); }
           | error '\n'
             { if (debug)
	         fprintf(stderr,
		         "Warning: Parsing callerid history file:%d, "
			 "recovering after error.\n", yylloc /* @1 problem XXX: random number!? */);
	     }
;

%%

/*
 * callback for yyparse(), (also) called on errors (hopefully) handled
 * by error token actions in grammar, but not if errors occur to
 * often (bison needs 3 "correct" tokens to recover)
 */
void yyerror(const char *message) {
  if (debug)
    fprintf(stderr,
	    "Warning: Parsing callerid history file:%d: %s.\n",
	    yylloc, message);
}
