/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

extern unsigned int gsh_rows;
extern unsigned int gsh_update_period;
extern gboolean gsh_button_exits;
extern gboolean gsh_updater_defined;

void
gsh_count(int argc, int *counter)
{
 (*counter)++;
 assert((*counter) <= argc);
}
void
gsh_setup_command_entry(char *command)
{
 GtkWidget      *entry;

 entry = gtk_entry_new();
 g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(entry_cb),
		  (gpointer) command);
 gsh_manage(entry);
}

void
gsh_text_area()
{
	GtkWidget *text;
	text=gtk_text_view_new();
	gsh_manage(text);
}

void
gsh_handle_options(int argc, char **argv, unsigned int *counter)
{
	gsh_check_row();
 switch (argv[(*counter)][1])
 {

  case 'E':
   gsh_button_exits = TRUE;
   break;

  case 'g':
   gsh_count(argc, counter);
   gtk_window_parse_geometry(GTK_WINDOW(gsh_window), argv[(*counter)]);
   break;

	case 'i':
		gsh_count(argc, counter);
		gsh_image_button(argv[(*counter)], argv[(*counter)+1]);
		gsh_count(argc, counter);
		break;

  case 'r':
   gsh_count(argc, counter);
   gsh_rows = (unsigned int)atoi(argv[(*counter)]);
#ifdef DEBUG
	printf("gsh_rows: %d\n", gsh_rows);
#endif
   break;

  case 'l':
   gsh_count(argc, counter);
   gsh_add_label(argv[(*counter)]);
   break;

	case 'I':
		gsh_count(argc, counter);
		gsh_image_button(argv[*counter], argv[*counter+1]);
		gsh_count(argc, counter);
		gtk_button_set_label(GTK_BUTTON(gsh_button), "");
		break;

  case 't':
   gsh_count(argc, counter);
   gsh_setup_command_entry(argv[(*counter)]);
   break;

	case 'T':
		gsh_text_area();
		break;

  case 'u':
   gsh_count(argc, counter);
   gsh_dynamic_label(argv[*counter]);
   break;

  case 'U':
   gsh_count(argc, counter);
   gsh_update_period=atoi(argv[*counter]);
   break; 
 }
}
