/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com
 
  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

int 
antiright_system(char *field_string)
{
  /* Ensure that FIELD_STRING is not empty.  */
  if((field_string != NULL) & (strlen(field_string)>0))
    {
      int system_return_value=0;
      if(field_string[strlen(field_string)-1] != '&') /* Do the
							 following if
							 there is no
							 ampersand at
							 the end of
							 FIELD_STRING.  */
	{
	  char *system_string;
	  /* Append an ampersand to FIELD_STRING.  Place the resulting
	     string in SYSTEM_STRING.  */
	  asprintf(&system_string, "%s &", field_string);
	  /* Ensure that SYSTEM_STRING was correctly allocated.  */
	  assert(system_string != NULL);
	  /* Execute SYSTEM_STRING.  */
	  system_return_value=system(system_string);
	  /* Clean up.  */
	  free(system_string);
	}
      else /* The input command already includes an ampersand and will
	      become a background operation.  */
	{
	  /* Execute raw FIELD_STRING.  */
	  system_return_value=system(field_string);
	}
      /* Return result of system call.  */
      return(system_return_value);
    }
  else /*  The user input is empty.  */
    {
      /* Generate an error.  */
      perror("FIELD_STRING is empty.");
      return(-1);
    }  
}

