/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

gboolean gsh_updater_defined=FALSE;
unsigned int gsh_update_period=1000;
struct gsh_updated_struct *gsh_updates=NULL;
/* #define DEBUG */
void
gsh_check_updates_initialization()
{
#ifdef DEBUG
	puts("gsh_check_updates_initialization()");
#endif
	if(gsh_updates==NULL)
        {
                gsh_updates=(struct gsh_updated_struct*)
                        malloc(sizeof(struct gsh_updated_struct));
                gsh_updates->next=NULL;
        }
}

void
gsh_add_to_updates(struct gsh_updated_struct *update)
{
	struct gsh_updated_struct *iterator;

#ifdef DEBUG
	puts("gsh_add_to_updates()");
#endif
	gsh_check_updates_initialization();
	assert(gsh_updates!=NULL);
	iterator=gsh_updates;

	while(iterator->next!=NULL)
	{
		iterator=iterator->next;
	}

	iterator->next=update;
}

void
gsh_add_update(void (*function)(char*, void*),
	char *command, void *widget)
{
	struct gsh_updated_struct *item;

#ifdef DEBUG
	puts("gsh_add_update()");
#endif

	item=(struct gsh_updated_struct*)malloc(sizeof(struct gsh_updated_struct));

	item->next=NULL;
	/*item->command=command;*/
	asprintf(&item->command, "%s", command);
	item->widget=widget;
	item->function=function;

	gsh_add_to_updates(item);
}

void
gsh_update_label(char *command, void *widget)
{
	char *results;
	char *markup;

#ifdef DEBUG
	puts("gsh_update_label()");
#endif

	results=antiright_pipe_read(command);
	markup=g_markup_printf_escaped
		("<span size=\"small\"><tt>%s</tt></span>", results);
	free(results);
	gtk_label_set_markup(GTK_LABEL((GtkWidget*)widget), markup);
	g_free(markup);
}

void
gsh_add_updated_label(char *command)
{
	GtkWidget *widget;

#ifdef DEBUG
	puts("gsh_add_updated_label()");
#endif
	widget=gtk_label_new("");
	gsh_manage(widget);
	gsh_add_update(&gsh_update_label, command, (void*)widget);
}
void
gsh_update_progress(char *command, void *widget)
{
	char *results;
	results=antiright_pipe_read(command);
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR((GtkWidget*) widget),
		strtod(results, NULL));
	free(results);
}
void
gsh_add_updated_progress(char *command)
{
	GtkWidget *widget;
	widget=gtk_progress_bar_new();
	gsh_manage(widget);
	gsh_add_update(&gsh_update_progress, command, (void*)widget);
}
void
gsh_start_updates()
{
#ifdef DEBUG
	puts("gsh_start_updates()");
#endif
	g_timeout_add(gsh_update_period, gsh_perform_updates, NULL);	
}
gint
gsh_perform_updates(gpointer data)
{
#ifdef DEBUG
	puts("gsh_perform_updates()");
#endif
	struct gsh_updated_struct *iterator;
	gsh_check_updates_initialization();
	assert(gsh_updates!=NULL);
	iterator=gsh_updates->next; 
	iterator->function(iterator->command, iterator->widget);
	while(iterator->next!=NULL)
	{
#ifdef DEBUG
	puts("gsh_perform_updates().while");
#endif
		assert(iterator->command);
		assert(iterator->widget);
		iterator=iterator->next;
		iterator->function(iterator->command, iterator->widget);
	}
	return(TRUE);	
}

