/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

unsigned int gsh_rows=8;
unsigned int gsh_row=1;

void
gsh_manage(GtkWidget *widget)
{
 gsh_check_row();
 gtk_container_add(GTK_CONTAINER(gsh_vbox), widget);
 gtk_widget_show(widget);
 gsh_row++;
#ifdef DEBUG
 printf("gsh_row: %d, gsh_rows: %d\n", gsh_row, gsh_rows);
#endif
}


void
gsh_new_row()
{
 gsh_vbox = gtk_vbox_new(FALSE, 2);
 gtk_container_add(GTK_CONTAINER(gsh_hbox), gsh_vbox);
 gtk_widget_show(gsh_vbox);
 gsh_row = 1;
}

void
gsh_check_row()
{
#ifdef DEBUG
 printf("==> gsh_row: %d, gsh_rows: %d\n", gsh_row, gsh_rows);
#endif

 if(gsh_row > gsh_rows)
 {
  gsh_new_row();
 }
}



