/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gshterm.h"

extern char *gshterm_font;

void
gshterm_set_terminal_options(GtkWidget *terminal)
{
	vte_terminal_set_size(VTE_TERMINAL(terminal), 80, 32);
	vte_terminal_set_allow_bold(VTE_TERMINAL(terminal), TRUE);
	vte_terminal_set_backspace_binding(VTE_TERMINAL(terminal),
		VTE_ERASE_ASCII_BACKSPACE);
	if(!gshterm_font)
		asprintf(&gshterm_font, "Mono 18");
	vte_terminal_set_font_from_string(VTE_TERMINAL(terminal), gshterm_font);
	free(gshterm_font);
	vte_terminal_set_background_transparent(
		VTE_TERMINAL(terminal), TRUE);
}

GtkWidget*
gshterm_setup_terminal(struct GSHTerm *term)
{
	GtkWidget *terminal;

#ifdef DEBUG
	assert(term);
	assert(term->gsh);
	assert(term->gsh->window);
#endif /* DEBUG */

	terminal=vte_terminal_new();
	gtk_container_add(GTK_CONTAINER(term->gsh->window), terminal);
	gshterm_set_terminal_options(terminal);
	gtk_widget_show(terminal);
	term->widget=terminal;
	return(terminal);
}


