/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

void
gsh_add_label(struct GSH *gsh, char *text)
{
 GtkWidget      *label;

 label = gtk_label_new(text);
 gsh_manage(gsh, label);
}

void
gsh_set_label(GtkWidget *label, char *text)
{
	gchar *markup;
	
	markup=g_markup_printf_escaped
		("<span size=\"small\"><tt>%s</tt></span>", text);
	gtk_label_set_markup(GTK_LABEL(label), markup);
	g_free(markup);
}

