/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

void
gsh_manage(struct GSH *gsh, GtkWidget *widget)
{
 gsh_check_row(gsh);
 gtk_container_add(GTK_CONTAINER(gsh->rows.v), widget);
 gtk_widget_show(widget);
 gsh->rows.row++;

#ifdef DEBUG
 g_print("gsh_row: %d, gsh_rows: %d\n", gsh->rows.row, gsh->rows.rows);
#endif

}


void
gsh_new_row(struct GSH *gsh)
{
 gsh->rows.v = gtk_vbox_new(FALSE, 2);
 gtk_container_add(GTK_CONTAINER(gsh->rows.h), gsh->rows.v);
 gtk_widget_show(gsh->rows.v);
 gsh->rows.row = 0;
}

void
gsh_check_row(struct GSH *gsh)
{

#ifdef DEBUG
 printf("==> gsh_row: %d, gsh_rows: %d\n", gsh->rows.row, gsh->rows.rows);
#endif

 if(gsh->rows.row == gsh->rows.rows)
 {

#ifdef DEBUG 
	g_print("new row");
#endif

  gsh_new_row(gsh);
 }
}

