/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

/*

TODO: Use hierarchical structures for globals.  
	This was done on the Motif version.
	It will allow the use of a single global entity 
	on the namespace, and further organization can
	be achieved.  

*/

guint gsh_update_period=1000;
GSList *gsh_updater_list;

void
gsh_append_updater(gsh_updater_data *item)
{
	gsh_updater_list=g_slist_append(gsh_updater_list, item);
}

void
gsh_assign_updater(
	gsh_updater_data *item,
	void (*function)(char*, void*),
	char *command, void *widget)
{
	/* Assign the values to ITEM's members.  */

	asprintf(&item->command, "%s", command);

	/* No allocation necessary as these are
	 duplicate pointers.  */

        item->widget=widget;
        item->function=function;
}

void
gsh_add_updater(
	void (*function)(char*, void*),
	char *command, void *widget)
{
	gsh_updater_data *item;

	/* Allocate memory for ITEM cell.  */
	item=(gsh_updater_data*)xmalloc(sizeof(gsh_updater_data));
	/* Initialize.  */
	gsh_assign_updater(item, function, command, widget);
	/* Add to singly linked list.  */
	gsh_append_updater(item);
}

void gsh_update_each(gpointer data, gpointer user_data)
{
	gsh_updater_data *item;


	UNUSED(user_data); /* USER_DATA is unused.  */ 

	/* Ensure that the argument containing 
	the structure is not empty.  */

	assert(data != NULL);

	/* Assign data to structure and call
	 function pointer with parameters.  */

	item=(gsh_updater_data*)data;
	item->function(item->command, item->widget);
}

gint
gsh_perform_updates(gpointer data)
{

#ifdef DEBUG
	g_message("gsh_perform_updates()");
#endif
	
	UNUSED(data); /* DATA is unused.  */

	g_slist_foreach(gsh_updater_list, gsh_update_each, NULL);
	
	return(TRUE);	
}

void
gsh_start_updates()
{
#ifdef DEBUG
	g_message("gsh_start_updates()");
#endif
	gsh_perform_updates(NULL);
	g_timeout_add(gsh_update_period, gsh_perform_updates, NULL);	
}

