/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gshterm.h"

static void
set_font(struct GSHTerm * term)
{
	gchar *final_font;

	ARIFNP(term->font)
		ar_asprintf(&final_font, "Mono 12");
	else
	{
		if (term->font_size == 0)

			/*
			 * If size is unspecified, then either the user
			 * may have specified a font size as part of
			 * the font string, or we will rely on system
			 * defaults.
			 */
			ar_asprintf(&final_font, "%s", term->font);
		else
			ar_asprintf(&final_font, "%s %d", term->font,
				    term->font_size);

		g_free(term->font);
		term->font = NULL;
	}

	vte_terminal_set_font_from_string(VTE_TERMINAL(term->widget),
					  final_font);
	g_free(final_font);
}
void
gshterm_set_terminal_options(struct GSHTerm * term)
{
	vte_terminal_set_size(VTE_TERMINAL(term->widget), 80, 32);
	vte_terminal_set_allow_bold(VTE_TERMINAL(term->widget), TRUE);
	vte_terminal_set_backspace_binding(VTE_TERMINAL(term->widget),
					   VTE_ERASE_ASCII_BACKSPACE);
	set_font(term);

	vte_terminal_set_background_transparent(
				    VTE_TERMINAL(term->widget), TRUE);
}

struct GSHTerm *
gshterm_setup_terminal(struct GSHTerm * term)
{

#ifdef DEBUG
	ARPASSERT(term);
	ARPASSERT(term->gsh);
	ARPASSERT(term->gsh->window);
#endif				/* DEBUG */

	term->widget = vte_terminal_new();
	gtk_container_add(GTK_CONTAINER(term->gsh->window), term->widget);
	gshterm_set_terminal_options(term);
	gtk_widget_show(term->widget);

	return (term);
}

struct GSHTerm *
GSHTerm_new()
{
	struct GSHTerm *term;

	term = (struct GSHTerm *) xmalloc(sizeof(struct GSHTerm));

	ARPASSERT(term);

	term->gsh = NULL;
	term->font = NULL;
	term->font_size = 0;
	term->widget = NULL;

	return term;
}
