/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

GtkWidget *
gsh_setup_command_entry(struct GSH * gsh, char *command)
{
	GtkWidget *entry;
	struct GSH_CBData *cb;

	ARPASSERT(gsh);

	/* Set up callback data.  */
	cb = (struct GSH_CBData *) xmalloc(sizeof(struct GSH_CBData));
	cb->gsh = gsh;

	/*
	 * ARIFP(command) asprintf ((char **) &cb->data, "%s",
	 * command); else asprintf ((char **) &cb->data, "echo");
	 */
	ARIFP(command)
		cb->data = command;	/* Static storage, will not
					 * pass out of scope.  */
	else
		cb->data = (gpointer)"echo";	/* Literal */

	/* Create widget.  */
	entry = gtk_entry_new();

	/* @null */
	(void) g_signal_connect(G_OBJECT(entry), "activate",
				G_CALLBACK(entry_cb), (gpointer) cb);

	/* Do not fill remaining container area.  */
	gsh_manage_unexpanded(gsh, entry);

	return (entry);
}

GtkWidget *
gsh_text_area(struct GSH * gsh)
{
	GtkWidget *text;

	text = gtk_text_view_new();
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text), GTK_WRAP_WORD);
	gsh_manage(gsh, text);
	gsh_widget_set_font_mono(text);

	return text;
}

void
gsh_text_area_set_text(GtkWidget * widget, const gchar * text)
{
	GtkTextBuffer * buffer;

	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
	gtk_text_buffer_set_text(buffer, text,
			strlen(text));
}

/* This is currently just a text file viewer.  */
void
gsh_text_editor(struct GSH * gsh, char *filename)
{
	GtkWidget *widget;
	FILE *file;

	ARPASSERT(gsh);
	
	file=NULL;

	widget = gsh_text_area(gsh);

	ARPASSERT(filename);

	file = fopen(filename, "r");

	ARWIFNP(file)
	{
		char *text;
		text=antiright_read_file(file);
		gsh_text_area_set_text(widget, text);
		(void) fclose(file);
	}

	ARIFNP(gsh->geometry)
		asprintf(&gsh->geometry, "775x700");


}
