/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef LIBAR_LIBRARY_H
#define LIBAR_LIBRARY_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdarg.h>
#include <glib.h>

#include "pipe.h"
#include "string.h"
#include "system.h"
#include "util.h"

#define ARBUGPARAM(message) \
	"%s:%d: %s", __FILE__, __LINE__, message

#define ARBUG(message) \
	g_debug(ARBUGPARAM(message))

#define ARWARN(message) \
	g_warning(ARBUGPARAM(message))

#define ARERR(message) \
	g_error(ARBUGPARAM(message))

#define ARBBOOL(x) (x == TRUE)
#define ARPBOOL(x) (x != NULL)

#define ARASSERT g_assert

#define ARBASSERT(x) \
	ARASSERT(ARBBOOL(x))

#define ARPASSERT(x) \
	ARASSERT(ARPBOOL(x))

#define ARIFB(x) \
	if(ARBBOOL(x))

#define ARIFNB(x) \
	if(!ARBBOOL(x))

#define ARIFP(x) \
	if(ARPBOOL(x))

#define ARIFNP(x) \
	if(!ARPBOOL(x))

#define ARWIFNP(x) \
	ARIFNP(x) \
		ARWARN("NULL data passed, operation not performed"); \
	else
#endif				/* LIBAR_LIBRARY_H */
