%{
#include <stdio.h>
#define YYFILE
#include "gtkshell.h"

void
yyerror(const char *string);

int
yywrap();

void
gsh_append_arg(char * arg);

void
yyerror(const char *string)
{
	g_error("error:  %s\n", string);
}

int
yywrap()
{
	return 1;
}

struct GSH * gsh_gsh;
char **gsh_parsed_argv;
int gsh_parsed_argc=0;

void
gsh_append_arg(char * arg)
{
	gsh_parsed_argc++;
	gsh_parsed_argv=realloc(gsh_parsed_argv, sizeof(char*)*gsh_parsed_argc);
	gsh_parsed_argv[gsh_parsed_argc-1]=strdup(arg);
}

void
gsh_free_parse_memory()
{
	for(;gsh_parsed_argc>0; gsh_parsed_argc--)
		free(gsh_parsed_argv[gsh_parsed_argc-1]);
	free(gsh_parsed_argv);
}

%}
%union
{
	char * string;
	int number;
}
%token IFS SC COMMA OPTION PROMPT VIEWER LABEL
%token BUTTON END ADD UPDATING PROGRESS BUTTONS
%token <string> STRING
%token <number> NUM
%token <string> CHAR
%%
commands:
/* empty */
| 
commands command END
;

command: 
option
|
add
;

option:
OPTION CHAR
{
	char * option_string;

	asprintf(&option_string, "-o%s", $2);
	gsh_append_arg(option_string);
	free(option_string);
}
|
OPTION STRING
{
	char option;

	if(!strcmp($2, "undecorated"))
		option='n';
	else if(!strcmp($2, "frame_labels"))
		option='f';
	else if(!strcmp($2, "exit_on_activate"))
		option='e';
	else if(!strcmp($2, "horizontal_labels"))
		option='h';
	else
		break;

	{
		char * option_string;

		asprintf(&option_string, "-o%c", option);
		gsh_append_arg(option_string);
		free(option_string);
	}
}
|
OPTION CHAR NUM
{
	char * option_string;

	asprintf(&option_string, "-o%s", $2);
	gsh_append_arg(option_string);
	free(option_string);
	asprintf(&option_string, "%d", $3);
	gsh_append_arg(option_string);
	free(option_string);
}
|
OPTION STRING STRING
{
	char option;

	if(!strcmp($2, "geometry"))
		option='g';
	else
	{
		ARWARN("Invalid option.");
		break;
	}

	{
		char * option_string;

		asprintf(&option_string, "-o%c", option);
		gsh_append_arg(option_string);
		free(option_string);
		gsh_append_arg($3);
	}
}
|
OPTION STRING NUM
{
	char option;

	if(!strcmp($2, "update_frequency"))
		option='u';
	if(!strcmp($2, "rows"))
		option = 'r';
	else
		break;

	{
		char * option_string;

		asprintf(&option_string, "-o%c", option);
		gsh_append_arg(option_string);
		free(option_string);
		asprintf(&option_string, "%d", $3);
		gsh_append_arg(option_string);
		free(option_string);
	}
}
;

add:
ADD PROMPT STRING
{
	gsh_append_arg((char *)"-at");
	gsh_append_arg($3);
}
|
ADD VIEWER STRING
{
	gsh_append_arg((char *)"-ae");
	gsh_append_arg($3);
}
|
ADD LABEL STRING
{
	gsh_append_arg((char *)"-al");
	gsh_append_arg($3);
	ARBUG($3);
}
|
ADD BUTTON STRING
{
	gsh_append_arg($3);
	ARBUG($3);
}
|
ADD UPDATING PROGRESS STRING
{
	gsh_append_arg((char*)"-aup");
	gsh_append_arg($4);

}
|
ADD UPDATING LABEL STRING
{
	gsh_append_arg((char*)"-aul");
	gsh_append_arg($4);
}
|
ADD BUTTONS buttons
;

buttons:
/* empty */
|
buttons button COMMA
|
buttons button
;

button:
STRING
{
	gsh_append_arg($1);
}
;

