/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void 
generic_image_button(struct GSH * gsh, char *command, 
		     GtkWidget * image)
{
	gsh_command_button(gsh, command);
	if(!GTK_IS_MENU(gsh->rows.v))
	{
		gtk_button_set_image(GTK_BUTTON(gsh->button), image);
		gtk_button_set_relief(GTK_BUTTON(gsh->button), GTK_RELIEF_NONE);
	}
	else
	{
		GtkWidget * label;
		GtkWidget * hrow;
		label=gtk_bin_get_child(GTK_BIN(gsh->button));
		gtk_widget_ref(label);
		gtk_container_remove(GTK_CONTAINER(gsh->button), label);
		hrow=gtk_hbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(gsh->button), hrow);
		gtk_widget_show(hrow);
		gtk_box_pack_start(GTK_BOX(hrow), image, FALSE, FALSE, 0);
		gtk_widget_show(image);
		gtk_container_add(GTK_CONTAINER(hrow), label);

		gtk_widget_show(label);
	}
}

void
gsh_image_button(struct GSH * gsh, char *command, char *name)
{
	GtkWidget *image;
	gboolean is_file;

	is_file = g_file_test(name, G_FILE_TEST_EXISTS);

	ARIFB(is_file)
		image = gtk_image_new_from_file(name);
	else
		image = gtk_image_new_from_stock((const gchar *)name,
			GTK_ICON_SIZE_DND);

	generic_image_button(gsh, command, image);
}

