/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"


static void
gsh_append_updater(struct GSH * gsh, gsh_updater_data * item)
{

#ifdef DEBUG
	ARBUG("gsh_append_updater()");
#endif				/* DEBUG */

	if (ARPBOOL(gsh) && ARPBOOL(item))
		gsh->update.list = g_slist_prepend(gsh->update.list, item);

#ifdef DEBUG
	ARBUG("end gsh_append_updater()");
#endif				/* DEBUG */
}

static void
gsh_assign_updater(gsh_updater_data * item,
		   void (*function) (const gchar *, gpointer),
		   const gchar *command, GtkWidget *widget)
{
	/* Assign the values to ITEM's members.  */

	ar_asprintf(&item->command, "%s", command);

	/* No allocation necessary as these are duplicate pointers.  */

	item->widget = widget;
	item->function = function;
}

void
gsh_add_updater(struct GSH * gsh,
		void (*function) (const gchar *, gpointer),
		const gchar *command, GtkWidget *widget)
{
	gsh_updater_data *item;

	/* Allocate memory for ITEM cell.  */
	item = (gsh_updater_data *) xmalloc(sizeof(gsh_updater_data));
	/* Initialize.  */
	gsh_assign_updater(item, function, command, widget);
	/* Add to singly linked list.  */
	gsh_append_updater(gsh, item);
}

static void
gsh_update_each(gpointer data, gpointer user_data)
{
	UNUSED(user_data);	/* USER_DATA is unused.  */

	/*
	 * Ensure that the argument containing the structure is not
	 * empty.
	 */

	ARWIFNP(data)
	{
		gsh_updater_data *item;

		/*
		 * Assign data to structure and call function pointer
		 * with parameters.
		 */
		item = (gsh_updater_data *) data;
		ARPASSERT(item->function);
		item->function(item->command, item->widget);
	}
}

static gint
gsh_perform_updates(gpointer data)
{
	struct GSH *gsh;

#ifdef DEBUG
	ARBUG("gsh_perform_updates()");
#endif				/* DEBUG */

	gsh = (struct GSH *) data;


	if (ARPBOOL(gsh) && ARPBOOL(gsh->update.list))
		g_slist_foreach(gsh->update.list, gsh_update_each, gsh);
	else
	{
		ARWARN("data invalid, operation not performed.");
		return FALSE;
	}

	return (TRUE);
}

void
gsh_start_updates(struct GSH * gsh)
{

#ifdef DEBUG
	ARBUG("gsh_start_updates()");
#endif				/* DEBUG */

	ARWIFNP (gsh)
	{
		(void) gsh_perform_updates(gsh);
		(void) g_timeout_add(gsh->update.period, gsh_perform_updates,
				     gsh);
	}
}
