/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_check_results(char **results)
{

	/*
	 * This ensures that the result string is not empty, avoiding
	 * certain formatting problems.
	 */
	/* Otherwise, a GTK warning and termination occurs.  */
	ARPASSERT(*results);

	if (*results[0] == '\0')
	{
		free(*results);
		asprintf(results, "(empty)");
	}
}

static void
gsh_update_label(const gchar *command, gpointer widget)
{
	gchar *results;

#ifdef DEBUG
	ARBUG("gsh_update_label()");
#endif				/* DEBUG */

	ARPASSERT(command);
	ARPASSERT(widget);

	results = antiright_pipe_read((char *)command);
	gsh_check_results(&results);
	gsh_set_label((GtkWidget *) widget, results);
	g_free(results);
}

void
gsh_add_updated_label(struct GSH * gsh, const gchar *command)
{
	GtkWidget *widget;

#ifdef DEBUG
	g_message("gsh_add_updated_label()");
#endif				/* DEBUG */

	ARPASSERT(gsh);
	ARPASSERT(command);

	widget = gsh_add_label(gsh, (char *)command);
	gsh_add_updater(gsh, &gsh_update_label, command, (gpointer) widget);
}
