%{

#include "gtkshell.h"

%}
%%
[A-Za-z] yylval.string=strdup(yytext); return CHAR;
\"[^\"]*\"	 { 	
			/* Remove quotes.  */ 
			yylval.string=strdup(yytext+1); 
			yylval.string[yyleng-2]='\0';
			return STRING;
	 	}
[0-9]+		yylval.number=atoi(yytext); return NUM;
, 		return COMMA;
;		return END;
::		return IFS;
option		return OPTION;
button		return BUTTON;
add		return ADD;
prompt		return PROMPT;
viewer		return VIEWER;
label		return LABEL;
progress	return PROGRESS;
updating	return UPDATING;
buttons		return BUTTONS;

[ \t\n]		/* ignore */;
"//".*$		/* comment */;

%%
